# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include eks_service.R
NULL

#' Associate encryption configuration to an existing cluster
#'
#' @description
#' Associate encryption configuration to an existing cluster.
#'
#' See [https://paws-r.github.io/docs/eks/associate_encryption_config.html](https://paws-r.github.io/docs/eks/associate_encryption_config.html) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the cluster that you are associating with encryption
#' configuration.
#' @param encryptionConfig &#91;required&#93; The configuration you are using for encryption.
#' @param clientRequestToken The client request token you are using with the encryption
#' configuration.
#'
#' @keywords internal
#'
#' @rdname eks_associate_encryption_config
eks_associate_encryption_config <- function(clusterName, encryptionConfig, clientRequestToken = NULL) {
  op <- new_operation(
    name = "AssociateEncryptionConfig",
    http_method = "POST",
    http_path = "/clusters/{name}/encryption-config/associate",
    paginator = list()
  )
  input <- .eks$associate_encryption_config_input(clusterName = clusterName, encryptionConfig = encryptionConfig, clientRequestToken = clientRequestToken)
  output <- .eks$associate_encryption_config_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$associate_encryption_config <- eks_associate_encryption_config

#' Associate an identity provider configuration to a cluster
#'
#' @description
#' Associate an identity provider configuration to a cluster.
#'
#' See [https://paws-r.github.io/docs/eks/associate_identity_provider_config.html](https://paws-r.github.io/docs/eks/associate_identity_provider_config.html) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the cluster to associate the configuration to.
#' @param oidc &#91;required&#93; An object that represents an OpenID Connect (OIDC) identity provider
#' configuration.
#' @param tags The metadata to apply to the configuration to assist with categorization
#' and organization. Each tag consists of a key and an optional value. You
#' define both.
#' @param clientRequestToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @keywords internal
#'
#' @rdname eks_associate_identity_provider_config
eks_associate_identity_provider_config <- function(clusterName, oidc, tags = NULL, clientRequestToken = NULL) {
  op <- new_operation(
    name = "AssociateIdentityProviderConfig",
    http_method = "POST",
    http_path = "/clusters/{name}/identity-provider-configs/associate",
    paginator = list()
  )
  input <- .eks$associate_identity_provider_config_input(clusterName = clusterName, oidc = oidc, tags = tags, clientRequestToken = clientRequestToken)
  output <- .eks$associate_identity_provider_config_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$associate_identity_provider_config <- eks_associate_identity_provider_config

#' Creates an Amazon EKS add-on
#'
#' @description
#' Creates an Amazon EKS add-on.
#'
#' See [https://paws-r.github.io/docs/eks/create_addon.html](https://paws-r.github.io/docs/eks/create_addon.html) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the cluster to create the add-on for.
#' @param addonName &#91;required&#93; The name of the add-on. The name must match one of the names returned by
#' [`describe_addon_versions`](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html)
#' .
#' @param addonVersion The version of the add-on. The version must match one of the versions
#' returned by
#' [`describe_addon_versions`](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html)
#' .
#' @param serviceAccountRoleArn The Amazon Resource Name (ARN) of an existing IAM role to bind to the
#' add-on's service account. The role must be assigned the IAM permissions
#' required by the add-on. If you don't specify an existing IAM role, then
#' the add-on uses the permissions assigned to the node IAM role. For more
#' information, see [Amazon EKS node IAM
#' role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
#' in the *Amazon EKS User Guide*.
#' 
#' To specify an existing IAM role, you must have an IAM OpenID Connect
#' (OIDC) provider created for your cluster. For more information, see
#' [Enabling IAM roles for service accounts on your
#' cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
#' in the *Amazon EKS User Guide*.
#' @param resolveConflicts How to resolve parameter value conflicts when migrating an existing
#' add-on to an Amazon EKS add-on.
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param tags The metadata to apply to the cluster to assist with categorization and
#' organization. Each tag consists of a key and an optional value. You
#' define both.
#'
#' @keywords internal
#'
#' @rdname eks_create_addon
eks_create_addon <- function(clusterName, addonName, addonVersion = NULL, serviceAccountRoleArn = NULL, resolveConflicts = NULL, clientRequestToken = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateAddon",
    http_method = "POST",
    http_path = "/clusters/{name}/addons",
    paginator = list()
  )
  input <- .eks$create_addon_input(clusterName = clusterName, addonName = addonName, addonVersion = addonVersion, serviceAccountRoleArn = serviceAccountRoleArn, resolveConflicts = resolveConflicts, clientRequestToken = clientRequestToken, tags = tags)
  output <- .eks$create_addon_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$create_addon <- eks_create_addon

#' Creates an Amazon EKS control plane
#'
#' @description
#' Creates an Amazon EKS control plane.
#'
#' See [https://paws-r.github.io/docs/eks/create_cluster.html](https://paws-r.github.io/docs/eks/create_cluster.html) for full documentation.
#'
#' @param name &#91;required&#93; The unique name to give to your cluster.
#' @param version The desired Kubernetes version for your cluster. If you don't specify a
#' value here, the latest version available in Amazon EKS is used.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role that provides permissions
#' for the Kubernetes control plane to make calls to Amazon Web Services
#' API operations on your behalf. For more information, see [Amazon EKS
#' Service IAM
#' Role](https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html)
#' in the *Amazon EKS User Guide* .
#' @param resourcesVpcConfig &#91;required&#93; The VPC configuration that's used by the cluster control plane. Amazon
#' EKS VPC resources have specific requirements to work properly with
#' Kubernetes. For more information, see [Cluster VPC
#' Considerations](https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html)
#' and [Cluster Security Group
#' Considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html)
#' in the *Amazon EKS User Guide*. You must specify at least two subnets.
#' You can specify up to five security groups. However, we recommend that
#' you use a dedicated security group for your cluster control plane.
#' @param kubernetesNetworkConfig The Kubernetes network configuration for the cluster.
#' @param logging Enable or disable exporting the Kubernetes control plane logs for your
#' cluster to CloudWatch Logs. By default, cluster control plane logs
#' aren't exported to CloudWatch Logs. For more information, see [Amazon
#' EKS Cluster control plane
#' logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
#' in the *Amazon EKS User Guide* .
#' 
#' CloudWatch Logs ingestion, archive storage, and data scanning rates
#' apply to exported control plane logs. For more information, see
#' [CloudWatch Pricing](https://aws.amazon.com/cloudwatch/pricing/).
#' @param clientRequestToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param tags The metadata to apply to the cluster to assist with categorization and
#' organization. Each tag consists of a key and an optional value. You
#' define both.
#' @param encryptionConfig The encryption configuration for the cluster.
#'
#' @keywords internal
#'
#' @rdname eks_create_cluster
eks_create_cluster <- function(name, version = NULL, roleArn, resourcesVpcConfig, kubernetesNetworkConfig = NULL, logging = NULL, clientRequestToken = NULL, tags = NULL, encryptionConfig = NULL) {
  op <- new_operation(
    name = "CreateCluster",
    http_method = "POST",
    http_path = "/clusters",
    paginator = list()
  )
  input <- .eks$create_cluster_input(name = name, version = version, roleArn = roleArn, resourcesVpcConfig = resourcesVpcConfig, kubernetesNetworkConfig = kubernetesNetworkConfig, logging = logging, clientRequestToken = clientRequestToken, tags = tags, encryptionConfig = encryptionConfig)
  output <- .eks$create_cluster_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$create_cluster <- eks_create_cluster

#' Creates an Fargate profile for your Amazon EKS cluster
#'
#' @description
#' Creates an Fargate profile for your Amazon EKS cluster. You must have at least one Fargate profile in a cluster to be able to run pods on Fargate.
#'
#' See [https://paws-r.github.io/docs/eks/create_fargate_profile.html](https://paws-r.github.io/docs/eks/create_fargate_profile.html) for full documentation.
#'
#' @param fargateProfileName &#91;required&#93; The name of the Fargate profile.
#' @param clusterName &#91;required&#93; The name of the Amazon EKS cluster to apply the Fargate profile to.
#' @param podExecutionRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the pod execution role to use for pods
#' that match the selectors in the Fargate profile. The pod execution role
#' allows Fargate infrastructure to register with your cluster as a node,
#' and it provides read access to Amazon ECR image repositories. For more
#' information, see [Pod Execution
#' Role](https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html)
#' in the *Amazon EKS User Guide*.
#' @param subnets The IDs of subnets to launch your pods into. At this time, pods running
#' on Fargate are not assigned public IP addresses, so only private subnets
#' (with no direct route to an Internet Gateway) are accepted for this
#' parameter.
#' @param selectors The selectors to match for pods to use this Fargate profile. Each
#' selector must have an associated namespace. Optionally, you can also
#' specify labels for a namespace. You may specify up to five selectors in
#' a Fargate profile.
#' @param clientRequestToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param tags The metadata to apply to the Fargate profile to assist with
#' categorization and organization. Each tag consists of a key and an
#' optional value. You define both. Fargate profile tags do not propagate
#' to any other resources associated with the Fargate profile, such as the
#' pods that are scheduled with it.
#'
#' @keywords internal
#'
#' @rdname eks_create_fargate_profile
eks_create_fargate_profile <- function(fargateProfileName, clusterName, podExecutionRoleArn, subnets = NULL, selectors = NULL, clientRequestToken = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateFargateProfile",
    http_method = "POST",
    http_path = "/clusters/{name}/fargate-profiles",
    paginator = list()
  )
  input <- .eks$create_fargate_profile_input(fargateProfileName = fargateProfileName, clusterName = clusterName, podExecutionRoleArn = podExecutionRoleArn, subnets = subnets, selectors = selectors, clientRequestToken = clientRequestToken, tags = tags)
  output <- .eks$create_fargate_profile_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$create_fargate_profile <- eks_create_fargate_profile

#' Creates a managed node group for an Amazon EKS cluster
#'
#' @description
#' Creates a managed node group for an Amazon EKS cluster. You can only create a node group for your cluster that is equal to the current Kubernetes version for the cluster. All node groups are created with the latest AMI release version for the respective minor Kubernetes version of the cluster, unless you deploy a custom AMI using a launch template. For more information about using launch templates, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html).
#'
#' See [https://paws-r.github.io/docs/eks/create_nodegroup.html](https://paws-r.github.io/docs/eks/create_nodegroup.html) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the cluster to create the node group in.
#' @param nodegroupName &#91;required&#93; The unique name to give your node group.
#' @param scalingConfig The scaling configuration details for the Auto Scaling group that is
#' created for your node group.
#' @param diskSize The root device disk size (in GiB) for your node group instances. The
#' default disk size is 20 GiB. If you specify `launchTemplate`, then don't
#' specify `diskSize`, or the node group deployment will fail. For more
#' information about using launch templates with Amazon EKS, see [Launch
#' template
#' support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#' @param subnets &#91;required&#93; The subnets to use for the Auto Scaling group that is created for your
#' node group. If you specify `launchTemplate`, then don't specify
#' [`SubnetId`](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html)
#' in your launch template, or the node group deployment will fail. For
#' more information about using launch templates with Amazon EKS, see
#' [Launch template
#' support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#' @param instanceTypes Specify the instance types for a node group. If you specify a GPU
#' instance type, be sure to specify `AL2_x86_64_GPU` with the `amiType`
#' parameter. If you specify `launchTemplate`, then you can specify zero or
#' one instance type in your launch template *or* you can specify 0-20
#' instance types for `instanceTypes`. If however, you specify an instance
#' type in your launch template *and* specify any `instanceTypes`, the node
#' group deployment will fail. If you don't specify an instance type in a
#' launch template or for `instanceTypes`, then `t3.medium` is used, by
#' default. If you specify `Spot` for `capacityType`, then we recommend
#' specifying multiple values for `instanceTypes`. For more information,
#' see [Managed node group capacity
#' types](https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html#managed-node-group-capacity-types)
#' and [Launch template
#' support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#' @param amiType The AMI type for your node group. GPU instance types should use the
#' `AL2_x86_64_GPU` AMI type. Non-GPU instances should use the `AL2_x86_64`
#' AMI type. Arm instances should use the `AL2_ARM_64` AMI type. All types
#' use the Amazon EKS optimized Amazon Linux 2 AMI. If you specify
#' `launchTemplate`, and your launch template uses a custom AMI, then don't
#' specify `amiType`, or the node group deployment will fail. For more
#' information about using launch templates with Amazon EKS, see [Launch
#' template
#' support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#' @param remoteAccess The remote access (SSH) configuration to use with your node group. If
#' you specify `launchTemplate`, then don't specify `remoteAccess`, or the
#' node group deployment will fail. For more information about using launch
#' templates with Amazon EKS, see [Launch template
#' support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#' @param nodeRole &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role to associate with your
#' node group. The Amazon EKS worker node `kubelet` daemon makes calls to
#' Amazon Web Services APIs on your behalf. Nodes receive permissions for
#' these API calls through an IAM instance profile and associated policies.
#' Before you can launch nodes and register them into a cluster, you must
#' create an IAM role for those nodes to use when they are launched. For
#' more information, see [Amazon EKS node IAM
#' role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
#' in the *Amazon EKS User Guide* . If you specify `launchTemplate`, then
#' don't specify
#' [`IamInstanceProfile`](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html)
#' in your launch template, or the node group deployment will fail. For
#' more information about using launch templates with Amazon EKS, see
#' [Launch template
#' support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#' @param labels The Kubernetes labels to be applied to the nodes in the node group when
#' they are created.
#' @param taints The Kubernetes taints to be applied to the nodes in the node group. For
#' more information, see [Node taints on managed node
#' groups](https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html).
#' @param tags The metadata to apply to the node group to assist with categorization
#' and organization. Each tag consists of a key and an optional value. You
#' define both. Node group tags do not propagate to any other resources
#' associated with the node group, such as the Amazon EC2 instances or
#' subnets.
#' @param clientRequestToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param launchTemplate An object representing a node group's launch template specification. If
#' specified, then do not specify `instanceTypes`, `diskSize`, or
#' `remoteAccess` and make sure that the launch template meets the
#' requirements in `launchTemplateSpecification`.
#' @param updateConfig The node group update configuration.
#' @param capacityType The capacity type for your node group.
#' @param version The Kubernetes version to use for your managed nodes. By default, the
#' Kubernetes version of the cluster is used, and this is the only accepted
#' specified value. If you specify `launchTemplate`, and your launch
#' template uses a custom AMI, then don't specify `version`, or the node
#' group deployment will fail. For more information about using launch
#' templates with Amazon EKS, see [Launch template
#' support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#' @param releaseVersion The AMI version of the Amazon EKS optimized AMI to use with your node
#' group. By default, the latest available AMI version for the node group's
#' current Kubernetes version is used. For more information, see [Amazon
#' EKS optimized Amazon Linux 2 AMI
#' versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html)
#' in the *Amazon EKS User Guide*. If you specify `launchTemplate`, and
#' your launch template uses a custom AMI, then don't specify
#' `releaseVersion`, or the node group deployment will fail. For more
#' information about using launch templates with Amazon EKS, see [Launch
#' template
#' support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#'
#' @keywords internal
#'
#' @rdname eks_create_nodegroup
eks_create_nodegroup <- function(clusterName, nodegroupName, scalingConfig = NULL, diskSize = NULL, subnets, instanceTypes = NULL, amiType = NULL, remoteAccess = NULL, nodeRole, labels = NULL, taints = NULL, tags = NULL, clientRequestToken = NULL, launchTemplate = NULL, updateConfig = NULL, capacityType = NULL, version = NULL, releaseVersion = NULL) {
  op <- new_operation(
    name = "CreateNodegroup",
    http_method = "POST",
    http_path = "/clusters/{name}/node-groups",
    paginator = list()
  )
  input <- .eks$create_nodegroup_input(clusterName = clusterName, nodegroupName = nodegroupName, scalingConfig = scalingConfig, diskSize = diskSize, subnets = subnets, instanceTypes = instanceTypes, amiType = amiType, remoteAccess = remoteAccess, nodeRole = nodeRole, labels = labels, taints = taints, tags = tags, clientRequestToken = clientRequestToken, launchTemplate = launchTemplate, updateConfig = updateConfig, capacityType = capacityType, version = version, releaseVersion = releaseVersion)
  output <- .eks$create_nodegroup_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$create_nodegroup <- eks_create_nodegroup

#' Delete an Amazon EKS add-on
#'
#' @description
#' Delete an Amazon EKS add-on.
#'
#' See [https://paws-r.github.io/docs/eks/delete_addon.html](https://paws-r.github.io/docs/eks/delete_addon.html) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the cluster to delete the add-on from.
#' @param addonName &#91;required&#93; The name of the add-on. The name must match one of the names returned by
#' [`list_addons`](https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html)
#' .
#' @param preserve Specifying this option preserves the add-on software on your cluster but
#' Amazon EKS stops managing any settings for the add-on. If an IAM account
#' is associated with the add-on, it is not removed.
#'
#' @keywords internal
#'
#' @rdname eks_delete_addon
eks_delete_addon <- function(clusterName, addonName, preserve = NULL) {
  op <- new_operation(
    name = "DeleteAddon",
    http_method = "DELETE",
    http_path = "/clusters/{name}/addons/{addonName}",
    paginator = list()
  )
  input <- .eks$delete_addon_input(clusterName = clusterName, addonName = addonName, preserve = preserve)
  output <- .eks$delete_addon_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$delete_addon <- eks_delete_addon

#' Deletes the Amazon EKS cluster control plane
#'
#' @description
#' Deletes the Amazon EKS cluster control plane.
#'
#' See [https://paws-r.github.io/docs/eks/delete_cluster.html](https://paws-r.github.io/docs/eks/delete_cluster.html) for full documentation.
#'
#' @param name &#91;required&#93; The name of the cluster to delete.
#'
#' @keywords internal
#'
#' @rdname eks_delete_cluster
eks_delete_cluster <- function(name) {
  op <- new_operation(
    name = "DeleteCluster",
    http_method = "DELETE",
    http_path = "/clusters/{name}",
    paginator = list()
  )
  input <- .eks$delete_cluster_input(name = name)
  output <- .eks$delete_cluster_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$delete_cluster <- eks_delete_cluster

#' Deletes an Fargate profile
#'
#' @description
#' Deletes an Fargate profile.
#'
#' See [https://paws-r.github.io/docs/eks/delete_fargate_profile.html](https://paws-r.github.io/docs/eks/delete_fargate_profile.html) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the Amazon EKS cluster associated with the Fargate profile
#' to delete.
#' @param fargateProfileName &#91;required&#93; The name of the Fargate profile to delete.
#'
#' @keywords internal
#'
#' @rdname eks_delete_fargate_profile
eks_delete_fargate_profile <- function(clusterName, fargateProfileName) {
  op <- new_operation(
    name = "DeleteFargateProfile",
    http_method = "DELETE",
    http_path = "/clusters/{name}/fargate-profiles/{fargateProfileName}",
    paginator = list()
  )
  input <- .eks$delete_fargate_profile_input(clusterName = clusterName, fargateProfileName = fargateProfileName)
  output <- .eks$delete_fargate_profile_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$delete_fargate_profile <- eks_delete_fargate_profile

#' Deletes an Amazon EKS node group for a cluster
#'
#' @description
#' Deletes an Amazon EKS node group for a cluster.
#'
#' See [https://paws-r.github.io/docs/eks/delete_nodegroup.html](https://paws-r.github.io/docs/eks/delete_nodegroup.html) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the Amazon EKS cluster that is associated with your node
#' group.
#' @param nodegroupName &#91;required&#93; The name of the node group to delete.
#'
#' @keywords internal
#'
#' @rdname eks_delete_nodegroup
eks_delete_nodegroup <- function(clusterName, nodegroupName) {
  op <- new_operation(
    name = "DeleteNodegroup",
    http_method = "DELETE",
    http_path = "/clusters/{name}/node-groups/{nodegroupName}",
    paginator = list()
  )
  input <- .eks$delete_nodegroup_input(clusterName = clusterName, nodegroupName = nodegroupName)
  output <- .eks$delete_nodegroup_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$delete_nodegroup <- eks_delete_nodegroup

#' Deregisters a connected cluster to remove it from the Amazon EKS control
#' plane
#'
#' @description
#' Deregisters a connected cluster to remove it from the Amazon EKS control plane.
#'
#' See [https://paws-r.github.io/docs/eks/deregister_cluster.html](https://paws-r.github.io/docs/eks/deregister_cluster.html) for full documentation.
#'
#' @param name &#91;required&#93; The name of the connected cluster to deregister.
#'
#' @keywords internal
#'
#' @rdname eks_deregister_cluster
eks_deregister_cluster <- function(name) {
  op <- new_operation(
    name = "DeregisterCluster",
    http_method = "DELETE",
    http_path = "/cluster-registrations/{name}",
    paginator = list()
  )
  input <- .eks$deregister_cluster_input(name = name)
  output <- .eks$deregister_cluster_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$deregister_cluster <- eks_deregister_cluster

#' Describes an Amazon EKS add-on
#'
#' @description
#' Describes an Amazon EKS add-on.
#'
#' See [https://paws-r.github.io/docs/eks/describe_addon.html](https://paws-r.github.io/docs/eks/describe_addon.html) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the cluster.
#' @param addonName &#91;required&#93; The name of the add-on. The name must match one of the names returned by
#' [`list_addons`](https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html)
#' .
#'
#' @keywords internal
#'
#' @rdname eks_describe_addon
eks_describe_addon <- function(clusterName, addonName) {
  op <- new_operation(
    name = "DescribeAddon",
    http_method = "GET",
    http_path = "/clusters/{name}/addons/{addonName}",
    paginator = list()
  )
  input <- .eks$describe_addon_input(clusterName = clusterName, addonName = addonName)
  output <- .eks$describe_addon_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_addon <- eks_describe_addon

#' Describes the Kubernetes versions that the add-on can be used with
#'
#' @description
#' Describes the Kubernetes versions that the add-on can be used with.
#'
#' See [https://paws-r.github.io/docs/eks/describe_addon_versions.html](https://paws-r.github.io/docs/eks/describe_addon_versions.html) for full documentation.
#'
#' @param kubernetesVersion The Kubernetes versions that the add-on can be used with.
#' @param maxResults The maximum number of results to return.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' `DescribeAddonVersionsRequest` where `maxResults` was used and the
#' results exceeded the value of that parameter. Pagination continues from
#' the end of the previous results that returned the `nextToken` value.
#' 
#' This token should be treated as an opaque identifier that is used only
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param addonName The name of the add-on. The name must match one of the names returned by
#' [`list_addons`](https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html)
#' .
#'
#' @keywords internal
#'
#' @rdname eks_describe_addon_versions
eks_describe_addon_versions <- function(kubernetesVersion = NULL, maxResults = NULL, nextToken = NULL, addonName = NULL) {
  op <- new_operation(
    name = "DescribeAddonVersions",
    http_method = "GET",
    http_path = "/addons/supported-versions",
    paginator = list()
  )
  input <- .eks$describe_addon_versions_input(kubernetesVersion = kubernetesVersion, maxResults = maxResults, nextToken = nextToken, addonName = addonName)
  output <- .eks$describe_addon_versions_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_addon_versions <- eks_describe_addon_versions

#' Returns descriptive information about an Amazon EKS cluster
#'
#' @description
#' Returns descriptive information about an Amazon EKS cluster.
#'
#' See [https://paws-r.github.io/docs/eks/describe_cluster.html](https://paws-r.github.io/docs/eks/describe_cluster.html) for full documentation.
#'
#' @param name &#91;required&#93; The name of the cluster to describe.
#'
#' @keywords internal
#'
#' @rdname eks_describe_cluster
eks_describe_cluster <- function(name) {
  op <- new_operation(
    name = "DescribeCluster",
    http_method = "GET",
    http_path = "/clusters/{name}",
    paginator = list()
  )
  input <- .eks$describe_cluster_input(name = name)
  output <- .eks$describe_cluster_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_cluster <- eks_describe_cluster

#' Returns descriptive information about an Fargate profile
#'
#' @description
#' Returns descriptive information about an Fargate profile.
#'
#' See [https://paws-r.github.io/docs/eks/describe_fargate_profile.html](https://paws-r.github.io/docs/eks/describe_fargate_profile.html) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the Amazon EKS cluster associated with the Fargate profile.
#' @param fargateProfileName &#91;required&#93; The name of the Fargate profile to describe.
#'
#' @keywords internal
#'
#' @rdname eks_describe_fargate_profile
eks_describe_fargate_profile <- function(clusterName, fargateProfileName) {
  op <- new_operation(
    name = "DescribeFargateProfile",
    http_method = "GET",
    http_path = "/clusters/{name}/fargate-profiles/{fargateProfileName}",
    paginator = list()
  )
  input <- .eks$describe_fargate_profile_input(clusterName = clusterName, fargateProfileName = fargateProfileName)
  output <- .eks$describe_fargate_profile_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_fargate_profile <- eks_describe_fargate_profile

#' Returns descriptive information about an identity provider configuration
#'
#' @description
#' Returns descriptive information about an identity provider configuration.
#'
#' See [https://paws-r.github.io/docs/eks/describe_identity_provider_config.html](https://paws-r.github.io/docs/eks/describe_identity_provider_config.html) for full documentation.
#'
#' @param clusterName &#91;required&#93; The cluster name that the identity provider configuration is associated
#' to.
#' @param identityProviderConfig &#91;required&#93; An object that represents an identity provider configuration.
#'
#' @keywords internal
#'
#' @rdname eks_describe_identity_provider_config
eks_describe_identity_provider_config <- function(clusterName, identityProviderConfig) {
  op <- new_operation(
    name = "DescribeIdentityProviderConfig",
    http_method = "POST",
    http_path = "/clusters/{name}/identity-provider-configs/describe",
    paginator = list()
  )
  input <- .eks$describe_identity_provider_config_input(clusterName = clusterName, identityProviderConfig = identityProviderConfig)
  output <- .eks$describe_identity_provider_config_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_identity_provider_config <- eks_describe_identity_provider_config

#' Returns descriptive information about an Amazon EKS node group
#'
#' @description
#' Returns descriptive information about an Amazon EKS node group.
#'
#' See [https://paws-r.github.io/docs/eks/describe_nodegroup.html](https://paws-r.github.io/docs/eks/describe_nodegroup.html) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the Amazon EKS cluster associated with the node group.
#' @param nodegroupName &#91;required&#93; The name of the node group to describe.
#'
#' @keywords internal
#'
#' @rdname eks_describe_nodegroup
eks_describe_nodegroup <- function(clusterName, nodegroupName) {
  op <- new_operation(
    name = "DescribeNodegroup",
    http_method = "GET",
    http_path = "/clusters/{name}/node-groups/{nodegroupName}",
    paginator = list()
  )
  input <- .eks$describe_nodegroup_input(clusterName = clusterName, nodegroupName = nodegroupName)
  output <- .eks$describe_nodegroup_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_nodegroup <- eks_describe_nodegroup

#' Returns descriptive information about an update against your Amazon EKS
#' cluster or associated managed node group or Amazon EKS add-on
#'
#' @description
#' Returns descriptive information about an update against your Amazon EKS cluster or associated managed node group or Amazon EKS add-on.
#'
#' See [https://paws-r.github.io/docs/eks/describe_update.html](https://paws-r.github.io/docs/eks/describe_update.html) for full documentation.
#'
#' @param name &#91;required&#93; The name of the Amazon EKS cluster associated with the update.
#' @param updateId &#91;required&#93; The ID of the update to describe.
#' @param nodegroupName The name of the Amazon EKS node group associated with the update. This
#' parameter is required if the update is a node group update.
#' @param addonName The name of the add-on. The name must match one of the names returned by
#' [`list_addons`](https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html)
#' . This parameter is required if the update is an add-on update.
#'
#' @keywords internal
#'
#' @rdname eks_describe_update
eks_describe_update <- function(name, updateId, nodegroupName = NULL, addonName = NULL) {
  op <- new_operation(
    name = "DescribeUpdate",
    http_method = "GET",
    http_path = "/clusters/{name}/updates/{updateId}",
    paginator = list()
  )
  input <- .eks$describe_update_input(name = name, updateId = updateId, nodegroupName = nodegroupName, addonName = addonName)
  output <- .eks$describe_update_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_update <- eks_describe_update

#' Disassociates an identity provider configuration from a cluster
#'
#' @description
#' Disassociates an identity provider configuration from a cluster. If you disassociate an identity provider from your cluster, users included in the provider can no longer access the cluster. However, you can still access the cluster with Amazon Web Services IAM users.
#'
#' See [https://paws-r.github.io/docs/eks/disassociate_identity_provider_config.html](https://paws-r.github.io/docs/eks/disassociate_identity_provider_config.html) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the cluster to disassociate an identity provider from.
#' @param identityProviderConfig &#91;required&#93; An object that represents an identity provider configuration.
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @keywords internal
#'
#' @rdname eks_disassociate_identity_provider_config
eks_disassociate_identity_provider_config <- function(clusterName, identityProviderConfig, clientRequestToken = NULL) {
  op <- new_operation(
    name = "DisassociateIdentityProviderConfig",
    http_method = "POST",
    http_path = "/clusters/{name}/identity-provider-configs/disassociate",
    paginator = list()
  )
  input <- .eks$disassociate_identity_provider_config_input(clusterName = clusterName, identityProviderConfig = identityProviderConfig, clientRequestToken = clientRequestToken)
  output <- .eks$disassociate_identity_provider_config_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$disassociate_identity_provider_config <- eks_disassociate_identity_provider_config

#' Lists the available add-ons
#'
#' @description
#' Lists the available add-ons.
#'
#' See [https://paws-r.github.io/docs/eks/list_addons.html](https://paws-r.github.io/docs/eks/list_addons.html) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the cluster.
#' @param maxResults The maximum number of add-on results returned by `ListAddonsRequest` in
#' paginated output. When you use this parameter, `ListAddonsRequest`
#' returns only `maxResults` results in a single page along with a
#' `nextToken` response element. You can see the remaining results of the
#' initial request by sending another `ListAddonsRequest` request with the
#' returned `nextToken` value. This value can be between 1 and 100. If you
#' don't use this parameter, `ListAddonsRequest` returns up to 100 results
#' and a `nextToken` value, if applicable.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' `ListAddonsRequest` where `maxResults` was used and the results exceeded
#' the value of that parameter. Pagination continues from the end of the
#' previous results that returned the `nextToken` value.
#' 
#' This token should be treated as an opaque identifier that is used only
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#'
#' @keywords internal
#'
#' @rdname eks_list_addons
eks_list_addons <- function(clusterName, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAddons",
    http_method = "GET",
    http_path = "/clusters/{name}/addons",
    paginator = list()
  )
  input <- .eks$list_addons_input(clusterName = clusterName, maxResults = maxResults, nextToken = nextToken)
  output <- .eks$list_addons_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_addons <- eks_list_addons

#' Lists the Amazon EKS clusters in your Amazon Web Services account in the
#' specified Region
#'
#' @description
#' Lists the Amazon EKS clusters in your Amazon Web Services account in the specified Region.
#'
#' See [https://paws-r.github.io/docs/eks/list_clusters.html](https://paws-r.github.io/docs/eks/list_clusters.html) for full documentation.
#'
#' @param maxResults The maximum number of cluster results returned by
#' [`list_clusters`][eks_list_clusters] in paginated output. When you use
#' this parameter, [`list_clusters`][eks_list_clusters] returns only
#' `maxResults` results in a single page along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another [`list_clusters`][eks_list_clusters] request with the
#' returned `nextToken` value. This value can be between 1 and 100. If you
#' don't use this parameter, [`list_clusters`][eks_list_clusters] returns
#' up to 100 results and a `nextToken` value if applicable.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_clusters`][eks_list_clusters] request where `maxResults` was used
#' and the results exceeded the value of that parameter. Pagination
#' continues from the end of the previous results that returned the
#' `nextToken` value.
#' 
#' This token should be treated as an opaque identifier that is used only
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param include Indicates whether external clusters are included in the returned list.
#' Use '`all`' to return connected clusters, or blank to return only Amazon
#' EKS clusters. '`all`' must be in lowercase otherwise an error occurs.
#'
#' @keywords internal
#'
#' @rdname eks_list_clusters
eks_list_clusters <- function(maxResults = NULL, nextToken = NULL, include = NULL) {
  op <- new_operation(
    name = "ListClusters",
    http_method = "GET",
    http_path = "/clusters",
    paginator = list()
  )
  input <- .eks$list_clusters_input(maxResults = maxResults, nextToken = nextToken, include = include)
  output <- .eks$list_clusters_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_clusters <- eks_list_clusters

#' Lists the Fargate profiles associated with the specified cluster in your
#' Amazon Web Services account in the specified Region
#'
#' @description
#' Lists the Fargate profiles associated with the specified cluster in your Amazon Web Services account in the specified Region.
#'
#' See [https://paws-r.github.io/docs/eks/list_fargate_profiles.html](https://paws-r.github.io/docs/eks/list_fargate_profiles.html) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the Amazon EKS cluster that you would like to list Fargate
#' profiles in.
#' @param maxResults The maximum number of Fargate profile results returned by
#' [`list_fargate_profiles`][eks_list_fargate_profiles] in paginated
#' output. When you use this parameter,
#' [`list_fargate_profiles`][eks_list_fargate_profiles] returns only
#' `maxResults` results in a single page along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another [`list_fargate_profiles`][eks_list_fargate_profiles]
#' request with the returned `nextToken` value. This value can be between 1
#' and 100. If you don't use this parameter,
#' [`list_fargate_profiles`][eks_list_fargate_profiles] returns up to 100
#' results and a `nextToken` value if applicable.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_fargate_profiles`][eks_list_fargate_profiles] request where
#' `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value.
#'
#' @keywords internal
#'
#' @rdname eks_list_fargate_profiles
eks_list_fargate_profiles <- function(clusterName, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListFargateProfiles",
    http_method = "GET",
    http_path = "/clusters/{name}/fargate-profiles",
    paginator = list()
  )
  input <- .eks$list_fargate_profiles_input(clusterName = clusterName, maxResults = maxResults, nextToken = nextToken)
  output <- .eks$list_fargate_profiles_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_fargate_profiles <- eks_list_fargate_profiles

#' A list of identity provider configurations
#'
#' @description
#' A list of identity provider configurations.
#'
#' See [https://paws-r.github.io/docs/eks/list_identity_provider_configs.html](https://paws-r.github.io/docs/eks/list_identity_provider_configs.html) for full documentation.
#'
#' @param clusterName &#91;required&#93; The cluster name that you want to list identity provider configurations
#' for.
#' @param maxResults The maximum number of identity provider configurations returned by
#' [`list_identity_provider_configs`][eks_list_identity_provider_configs]
#' in paginated output. When you use this parameter,
#' [`list_identity_provider_configs`][eks_list_identity_provider_configs]
#' returns only `maxResults` results in a single page along with a
#' `nextToken` response element. You can see the remaining results of the
#' initial request by sending another
#' [`list_identity_provider_configs`][eks_list_identity_provider_configs]
#' request with the returned `nextToken` value. This value can be between 1
#' and 100. If you don't use this parameter,
#' [`list_identity_provider_configs`][eks_list_identity_provider_configs]
#' returns up to 100 results and a `nextToken` value, if applicable.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' `IdentityProviderConfigsRequest` where `maxResults` was used and the
#' results exceeded the value of that parameter. Pagination continues from
#' the end of the previous results that returned the `nextToken` value.
#'
#' @keywords internal
#'
#' @rdname eks_list_identity_provider_configs
eks_list_identity_provider_configs <- function(clusterName, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListIdentityProviderConfigs",
    http_method = "GET",
    http_path = "/clusters/{name}/identity-provider-configs",
    paginator = list()
  )
  input <- .eks$list_identity_provider_configs_input(clusterName = clusterName, maxResults = maxResults, nextToken = nextToken)
  output <- .eks$list_identity_provider_configs_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_identity_provider_configs <- eks_list_identity_provider_configs

#' Lists the Amazon EKS managed node groups associated with the specified
#' cluster in your Amazon Web Services account in the specified Region
#'
#' @description
#' Lists the Amazon EKS managed node groups associated with the specified cluster in your Amazon Web Services account in the specified Region. Self-managed node groups are not listed.
#'
#' See [https://paws-r.github.io/docs/eks/list_nodegroups.html](https://paws-r.github.io/docs/eks/list_nodegroups.html) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the Amazon EKS cluster that you would like to list node
#' groups in.
#' @param maxResults The maximum number of node group results returned by
#' [`list_nodegroups`][eks_list_nodegroups] in paginated output. When you
#' use this parameter, [`list_nodegroups`][eks_list_nodegroups] returns
#' only `maxResults` results in a single page along with a `nextToken`
#' response element. You can see the remaining results of the initial
#' request by sending another [`list_nodegroups`][eks_list_nodegroups]
#' request with the returned `nextToken` value. This value can be between 1
#' and 100. If you don't use this parameter,
#' [`list_nodegroups`][eks_list_nodegroups] returns up to 100 results and a
#' `nextToken` value if applicable.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_nodegroups`][eks_list_nodegroups] request where `maxResults` was
#' used and the results exceeded the value of that parameter. Pagination
#' continues from the end of the previous results that returned the
#' `nextToken` value.
#'
#' @keywords internal
#'
#' @rdname eks_list_nodegroups
eks_list_nodegroups <- function(clusterName, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListNodegroups",
    http_method = "GET",
    http_path = "/clusters/{name}/node-groups",
    paginator = list()
  )
  input <- .eks$list_nodegroups_input(clusterName = clusterName, maxResults = maxResults, nextToken = nextToken)
  output <- .eks$list_nodegroups_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_nodegroups <- eks_list_nodegroups

#' List the tags for an Amazon EKS resource
#'
#' @description
#' List the tags for an Amazon EKS resource.
#'
#' See [https://paws-r.github.io/docs/eks/list_tags_for_resource.html](https://paws-r.github.io/docs/eks/list_tags_for_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource for which to
#' list the tags. Currently, the supported resources are Amazon EKS
#' clusters and managed node groups.
#'
#' @keywords internal
#'
#' @rdname eks_list_tags_for_resource
eks_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .eks$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .eks$list_tags_for_resource_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_tags_for_resource <- eks_list_tags_for_resource

#' Lists the updates associated with an Amazon EKS cluster or managed node
#' group in your Amazon Web Services account, in the specified Region
#'
#' @description
#' Lists the updates associated with an Amazon EKS cluster or managed node group in your Amazon Web Services account, in the specified Region.
#'
#' See [https://paws-r.github.io/docs/eks/list_updates.html](https://paws-r.github.io/docs/eks/list_updates.html) for full documentation.
#'
#' @param name &#91;required&#93; The name of the Amazon EKS cluster to list updates for.
#' @param nodegroupName The name of the Amazon EKS managed node group to list updates for.
#' @param addonName The names of the installed add-ons that have available updates.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_updates`][eks_list_updates] request where `maxResults` was used
#' and the results exceeded the value of that parameter. Pagination
#' continues from the end of the previous results that returned the
#' `nextToken` value.
#' @param maxResults The maximum number of update results returned by
#' [`list_updates`][eks_list_updates] in paginated output. When you use
#' this parameter, [`list_updates`][eks_list_updates] returns only
#' `maxResults` results in a single page along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another [`list_updates`][eks_list_updates] request with the
#' returned `nextToken` value. This value can be between 1 and 100. If you
#' don't use this parameter, [`list_updates`][eks_list_updates] returns up
#' to 100 results and a `nextToken` value if applicable.
#'
#' @keywords internal
#'
#' @rdname eks_list_updates
eks_list_updates <- function(name, nodegroupName = NULL, addonName = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListUpdates",
    http_method = "GET",
    http_path = "/clusters/{name}/updates",
    paginator = list()
  )
  input <- .eks$list_updates_input(name = name, nodegroupName = nodegroupName, addonName = addonName, nextToken = nextToken, maxResults = maxResults)
  output <- .eks$list_updates_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_updates <- eks_list_updates

#' Connects a Kubernetes cluster to the Amazon EKS control plane
#'
#' @description
#' Connects a Kubernetes cluster to the Amazon EKS control plane.
#'
#' See [https://paws-r.github.io/docs/eks/register_cluster.html](https://paws-r.github.io/docs/eks/register_cluster.html) for full documentation.
#'
#' @param name &#91;required&#93; Define a unique name for this cluster for your Region.
#' @param connectorConfig &#91;required&#93; The configuration settings required to connect the Kubernetes cluster to
#' the Amazon EKS control plane.
#' @param clientRequestToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param tags The metadata that you apply to the cluster to assist with categorization
#' and organization. Each tag consists of a key and an optional value, both
#' of which you define. Cluster tags do not propagate to any other
#' resources associated with the cluster.
#'
#' @keywords internal
#'
#' @rdname eks_register_cluster
eks_register_cluster <- function(name, connectorConfig, clientRequestToken = NULL, tags = NULL) {
  op <- new_operation(
    name = "RegisterCluster",
    http_method = "POST",
    http_path = "/cluster-registrations",
    paginator = list()
  )
  input <- .eks$register_cluster_input(name = name, connectorConfig = connectorConfig, clientRequestToken = clientRequestToken, tags = tags)
  output <- .eks$register_cluster_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$register_cluster <- eks_register_cluster

#' Associates the specified tags to a resource with the specified
#' resourceArn
#'
#' @description
#' Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well. Tags that you create for Amazon EKS resources do not propagate to any other resources associated with the cluster. For example, if you tag a cluster with this operation, that tag does not automatically propagate to the subnets and nodes associated with the cluster.
#'
#' See [https://paws-r.github.io/docs/eks/tag_resource.html](https://paws-r.github.io/docs/eks/tag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to which to add tags.
#' Currently, the supported resources are Amazon EKS clusters and managed
#' node groups.
#' @param tags &#91;required&#93; The tags to add to the resource. A tag is an array of key-value pairs.
#'
#' @keywords internal
#'
#' @rdname eks_tag_resource
eks_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .eks$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .eks$tag_resource_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$tag_resource <- eks_tag_resource

#' Deletes specified tags from a resource
#'
#' @description
#' Deletes specified tags from a resource.
#'
#' See [https://paws-r.github.io/docs/eks/untag_resource.html](https://paws-r.github.io/docs/eks/untag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource from which to delete
#' tags. Currently, the supported resources are Amazon EKS clusters and
#' managed node groups.
#' @param tagKeys &#91;required&#93; The keys of the tags to be removed.
#'
#' @keywords internal
#'
#' @rdname eks_untag_resource
eks_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .eks$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .eks$untag_resource_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$untag_resource <- eks_untag_resource

#' Updates an Amazon EKS add-on
#'
#' @description
#' Updates an Amazon EKS add-on.
#'
#' See [https://paws-r.github.io/docs/eks/update_addon.html](https://paws-r.github.io/docs/eks/update_addon.html) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the cluster.
#' @param addonName &#91;required&#93; The name of the add-on. The name must match one of the names returned by
#' [`list_addons`](https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html)
#' .
#' @param addonVersion The version of the add-on. The version must match one of the versions
#' returned by
#' [`describe_addon_versions`](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html)
#' .
#' @param serviceAccountRoleArn The Amazon Resource Name (ARN) of an existing IAM role to bind to the
#' add-on's service account. The role must be assigned the IAM permissions
#' required by the add-on. If you don't specify an existing IAM role, then
#' the add-on uses the permissions assigned to the node IAM role. For more
#' information, see [Amazon EKS node IAM
#' role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
#' in the *Amazon EKS User Guide*.
#' 
#' To specify an existing IAM role, you must have an IAM OpenID Connect
#' (OIDC) provider created for your cluster. For more information, see
#' [Enabling IAM roles for service accounts on your
#' cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
#' in the *Amazon EKS User Guide*.
#' @param resolveConflicts How to resolve parameter value conflicts when applying the new version
#' of the add-on to the cluster.
#' @param clientRequestToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @keywords internal
#'
#' @rdname eks_update_addon
eks_update_addon <- function(clusterName, addonName, addonVersion = NULL, serviceAccountRoleArn = NULL, resolveConflicts = NULL, clientRequestToken = NULL) {
  op <- new_operation(
    name = "UpdateAddon",
    http_method = "POST",
    http_path = "/clusters/{name}/addons/{addonName}/update",
    paginator = list()
  )
  input <- .eks$update_addon_input(clusterName = clusterName, addonName = addonName, addonVersion = addonVersion, serviceAccountRoleArn = serviceAccountRoleArn, resolveConflicts = resolveConflicts, clientRequestToken = clientRequestToken)
  output <- .eks$update_addon_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$update_addon <- eks_update_addon

#' Updates an Amazon EKS cluster configuration
#'
#' @description
#' Updates an Amazon EKS cluster configuration. Your cluster continues to function during the update. The response output includes an update ID that you can use to track the status of your cluster update with the [`describe_update`][eks_describe_update] API operation.
#'
#' See [https://paws-r.github.io/docs/eks/update_cluster_config.html](https://paws-r.github.io/docs/eks/update_cluster_config.html) for full documentation.
#'
#' @param name &#91;required&#93; The name of the Amazon EKS cluster to update.
#' @param resourcesVpcConfig 
#' @param logging Enable or disable exporting the Kubernetes control plane logs for your
#' cluster to CloudWatch Logs. By default, cluster control plane logs
#' aren't exported to CloudWatch Logs. For more information, see [Amazon
#' EKS cluster control plane
#' logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
#' in the *Amazon EKS User Guide* .
#' 
#' CloudWatch Logs ingestion, archive storage, and data scanning rates
#' apply to exported control plane logs. For more information, see
#' [CloudWatch Pricing](https://aws.amazon.com/cloudwatch/pricing/).
#' @param clientRequestToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @keywords internal
#'
#' @rdname eks_update_cluster_config
eks_update_cluster_config <- function(name, resourcesVpcConfig = NULL, logging = NULL, clientRequestToken = NULL) {
  op <- new_operation(
    name = "UpdateClusterConfig",
    http_method = "POST",
    http_path = "/clusters/{name}/update-config",
    paginator = list()
  )
  input <- .eks$update_cluster_config_input(name = name, resourcesVpcConfig = resourcesVpcConfig, logging = logging, clientRequestToken = clientRequestToken)
  output <- .eks$update_cluster_config_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$update_cluster_config <- eks_update_cluster_config

#' Updates an Amazon EKS cluster to the specified Kubernetes version
#'
#' @description
#' Updates an Amazon EKS cluster to the specified Kubernetes version. Your cluster continues to function during the update. The response output includes an update ID that you can use to track the status of your cluster update with the [`describe_update`][eks_describe_update] API operation.
#'
#' See [https://paws-r.github.io/docs/eks/update_cluster_version.html](https://paws-r.github.io/docs/eks/update_cluster_version.html) for full documentation.
#'
#' @param name &#91;required&#93; The name of the Amazon EKS cluster to update.
#' @param version &#91;required&#93; The desired Kubernetes version following a successful update.
#' @param clientRequestToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @keywords internal
#'
#' @rdname eks_update_cluster_version
eks_update_cluster_version <- function(name, version, clientRequestToken = NULL) {
  op <- new_operation(
    name = "UpdateClusterVersion",
    http_method = "POST",
    http_path = "/clusters/{name}/updates",
    paginator = list()
  )
  input <- .eks$update_cluster_version_input(name = name, version = version, clientRequestToken = clientRequestToken)
  output <- .eks$update_cluster_version_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$update_cluster_version <- eks_update_cluster_version

#' Updates an Amazon EKS managed node group configuration
#'
#' @description
#' Updates an Amazon EKS managed node group configuration. Your node group continues to function during the update. The response output includes an update ID that you can use to track the status of your node group update with the [`describe_update`][eks_describe_update] API operation. Currently you can update the Kubernetes labels for a node group or the scaling configuration.
#'
#' See [https://paws-r.github.io/docs/eks/update_nodegroup_config.html](https://paws-r.github.io/docs/eks/update_nodegroup_config.html) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the Amazon EKS cluster that the managed node group resides
#' in.
#' @param nodegroupName &#91;required&#93; The name of the managed node group to update.
#' @param labels The Kubernetes labels to be applied to the nodes in the node group after
#' the update.
#' @param taints The Kubernetes taints to be applied to the nodes in the node group after
#' the update. For more information, see [Node taints on managed node
#' groups](https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html).
#' @param scalingConfig The scaling configuration details for the Auto Scaling group after the
#' update.
#' @param updateConfig The node group update configuration.
#' @param clientRequestToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @keywords internal
#'
#' @rdname eks_update_nodegroup_config
eks_update_nodegroup_config <- function(clusterName, nodegroupName, labels = NULL, taints = NULL, scalingConfig = NULL, updateConfig = NULL, clientRequestToken = NULL) {
  op <- new_operation(
    name = "UpdateNodegroupConfig",
    http_method = "POST",
    http_path = "/clusters/{name}/node-groups/{nodegroupName}/update-config",
    paginator = list()
  )
  input <- .eks$update_nodegroup_config_input(clusterName = clusterName, nodegroupName = nodegroupName, labels = labels, taints = taints, scalingConfig = scalingConfig, updateConfig = updateConfig, clientRequestToken = clientRequestToken)
  output <- .eks$update_nodegroup_config_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$update_nodegroup_config <- eks_update_nodegroup_config

#' Updates the Kubernetes version or AMI version of an Amazon EKS managed
#' node group
#'
#' @description
#' Updates the Kubernetes version or AMI version of an Amazon EKS managed node group.
#'
#' See [https://paws-r.github.io/docs/eks/update_nodegroup_version.html](https://paws-r.github.io/docs/eks/update_nodegroup_version.html) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the Amazon EKS cluster that is associated with the managed
#' node group to update.
#' @param nodegroupName &#91;required&#93; The name of the managed node group to update.
#' @param version The Kubernetes version to update to. If no version is specified, then
#' the Kubernetes version of the node group does not change. You can
#' specify the Kubernetes version of the cluster to update the node group
#' to the latest AMI version of the cluster's Kubernetes version. If you
#' specify `launchTemplate`, and your launch template uses a custom AMI,
#' then don't specify `version`, or the node group update will fail. For
#' more information about using launch templates with Amazon EKS, see
#' [Launch template
#' support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#' @param releaseVersion The AMI version of the Amazon EKS optimized AMI to use for the update.
#' By default, the latest available AMI version for the node group's
#' Kubernetes version is used. For more information, see [Amazon EKS
#' optimized Amazon Linux 2 AMI
#' versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html)
#' in the *Amazon EKS User Guide*. If you specify `launchTemplate`, and
#' your launch template uses a custom AMI, then don't specify
#' `releaseVersion`, or the node group update will fail. For more
#' information about using launch templates with Amazon EKS, see [Launch
#' template
#' support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#' @param launchTemplate An object representing a node group's launch template specification. You
#' can only update a node group using a launch template if the node group
#' was originally deployed with a launch template.
#' @param force Force the update if the existing node group's pods are unable to be
#' drained due to a pod disruption budget issue. If an update fails because
#' pods could not be drained, you can force the update after it fails to
#' terminate the old node whether or not any pods are running on the node.
#' @param clientRequestToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @keywords internal
#'
#' @rdname eks_update_nodegroup_version
eks_update_nodegroup_version <- function(clusterName, nodegroupName, version = NULL, releaseVersion = NULL, launchTemplate = NULL, force = NULL, clientRequestToken = NULL) {
  op <- new_operation(
    name = "UpdateNodegroupVersion",
    http_method = "POST",
    http_path = "/clusters/{name}/node-groups/{nodegroupName}/update-version",
    paginator = list()
  )
  input <- .eks$update_nodegroup_version_input(clusterName = clusterName, nodegroupName = nodegroupName, version = version, releaseVersion = releaseVersion, launchTemplate = launchTemplate, force = force, clientRequestToken = clientRequestToken)
  output <- .eks$update_nodegroup_version_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$update_nodegroup_version <- eks_update_nodegroup_version
