% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_create_service}
\alias{ecs_create_service}
\title{Runs and maintains a desired number of tasks from a specified task
definition}
\usage{
ecs_create_service(cluster, serviceName, taskDefinition, loadBalancers,
  serviceRegistries, desiredCount, clientToken, launchType,
  capacityProviderStrategy, platformVersion, role,
  deploymentConfiguration, placementConstraints, placementStrategy,
  networkConfiguration, healthCheckGracePeriodSeconds, schedulingStrategy,
  deploymentController, tags, enableECSManagedTags, propagateTags)
}
\arguments{
\item{cluster}{The short name or full Amazon Resource Name (ARN) of the cluster on
which to run your service. If you do not specify a cluster, the default
cluster is assumed.}

\item{serviceName}{[required] The name of your service. Up to 255 letters (uppercase and lowercase),
numbers, and hyphens are allowed. Service names must be unique within a
cluster, but you can have similarly named services in multiple clusters
within a Region or across multiple Regions.}

\item{taskDefinition}{The \code{family} and \code{revision} (\code{family:revision}) or full ARN of the task
definition to run in your service. If a \code{revision} is not specified, the
latest \code{ACTIVE} revision is used.

A task definition must be specified if the service is using the \code{ECS}
deployment controller.}

\item{loadBalancers}{A load balancer object representing the load balancers to use with your
service. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html}{Service Load Balancing}
in the \emph{Amazon Elastic Container Service Developer Guide}.

If the service is using the rolling update (\code{ECS}) deployment controller
and using either an Application Load Balancer or Network Load Balancer,
you can specify multiple target groups to attach to the service. The
service-linked role is required for services that make use of multiple
target groups. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html}{Using Service-Linked Roles for Amazon ECS}
in the \emph{Amazon Elastic Container Service Developer Guide}.

If the service is using the \code{CODE_DEPLOY} deployment controller, the
service is required to use either an Application Load Balancer or
Network Load Balancer. When creating an AWS CodeDeploy deployment group,
you specify two target groups (referred to as a \code{targetGroupPair}).
During a deployment, AWS CodeDeploy determines which task set in your
service has the status \code{PRIMARY} and associates one target group with
it, and then associates the other target group with the replacement task
set. The load balancer can also have up to two listeners: a required
listener for production traffic and an optional listener that allows you
perform validation tests with Lambda functions before routing production
traffic to it.

After you create a service using the \code{ECS} deployment controller, the
load balancer name or target group ARN, container name, and container
port specified in the service definition are immutable. If you are using
the \code{CODE_DEPLOY} deployment controller, these values can be changed
when updating the service.

For Application Load Balancers and Network Load Balancers, this object
must contain the load balancer target group ARN, the container name (as
it appears in a container definition), and the container port to access
from the load balancer. When a task from this service is placed on a
container instance, the container instance and port combination is
registered as a target in the target group specified here.

For Classic Load Balancers, this object must contain the load balancer
name, the container name (as it appears in a container definition), and
the container port to access from the load balancer. When a task from
this service is placed on a container instance, the container instance
is registered with the load balancer specified here.

Services with tasks that use the \code{awsvpc} network mode (for example,
those with the Fargate launch type) only support Application Load
Balancers and Network Load Balancers. Classic Load Balancers are not
supported. Also, when you create any target groups for these services,
you must choose \code{ip} as the target type, not \code{instance}, because tasks
that use the \code{awsvpc} network mode are associated with an elastic
network interface, not an Amazon EC2 instance.}

\item{serviceRegistries}{The details of the service discovery registries to assign to this
service. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html}{Service Discovery}.

Service discovery is supported for Fargate tasks if you are using
platform version v1.1.0 or later. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html}{AWS Fargate Platform Versions}.}

\item{desiredCount}{The number of instantiations of the specified task definition to place
and keep running on your cluster.

This is required if \code{schedulingStrategy} is \code{REPLICA} or is not
specified. If \code{schedulingStrategy} is \code{DAEMON} then this is not
required.}

\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Up to 32 ASCII characters are allowed.}

\item{launchType}{The launch type on which to run your service. For more information, see
\href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html}{Amazon ECS Launch Types}
in the \emph{Amazon Elastic Container Service Developer Guide}.

If a \code{launchType} is specified, the \code{capacityProviderStrategy} parameter
must be omitted.}

\item{capacityProviderStrategy}{The capacity provider strategy to use for the service.

A capacity provider strategy consists of one or more capacity providers
along with the \code{base} and \code{weight} to assign to them. A capacity
provider must be associated with the cluster to be used in a capacity
provider strategy. The PutClusterCapacityProviders API is used to
associate a capacity provider with a cluster. Only capacity providers
with an \code{ACTIVE} or \code{UPDATING} status can be used.

If a \code{capacityProviderStrategy} is specified, the \code{launchType} parameter
must be omitted. If no \code{capacityProviderStrategy} or \code{launchType} is
specified, the \code{defaultCapacityProviderStrategy} for the cluster is
used.

If specifying a capacity provider that uses an Auto Scaling group, the
capacity provider must already be created. New capacity providers can be
created with the CreateCapacityProvider API operation.

To use a AWS Fargate capacity provider, specify either the \code{FARGATE} or
\code{FARGATE_SPOT} capacity providers. The AWS Fargate capacity providers
are available to all accounts and only need to be associated with a
cluster to be used.

The PutClusterCapacityProviders API operation is used to update the list
of available capacity providers for a cluster after the cluster is
created.}

\item{platformVersion}{The platform version that your tasks in the service are running on. A
platform version is specified only for tasks using the Fargate launch
type. If one isn\'t specified, the \code{LATEST} platform version is used by
default. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html}{AWS Fargate Platform Versions}
in the \emph{Amazon Elastic Container Service Developer Guide}.}

\item{role}{The name or full Amazon Resource Name (ARN) of the IAM role that allows
Amazon ECS to make calls to your load balancer on your behalf. This
parameter is only permitted if you are using a load balancer with your
service and your task definition does not use the \code{awsvpc} network mode.
If you specify the \code{role} parameter, you must also specify a load
balancer object with the \code{loadBalancers} parameter.

If your account has already created the Amazon ECS service-linked role,
that role is used by default for your service unless you specify a role
here. The service-linked role is required if your task definition uses
the \code{awsvpc} network mode or if the service is configured to use service
discovery, an external deployment controller, multiple target groups, or
Elastic Inference accelerators in which case you should not specify a
role here. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html}{Using Service-Linked Roles for Amazon ECS}
in the \emph{Amazon Elastic Container Service Developer Guide}.

If your specified role has a path other than \code{/}, then you must either
specify the full role ARN (this is recommended) or prefix the role name
with the path. For example, if a role with the name \code{bar} has a path of
\verb{/foo/} then you would specify \verb{/foo/bar} as the role name. For more
information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names}{Friendly Names and Paths}
in the \emph{IAM User Guide}.}

\item{deploymentConfiguration}{Optional deployment parameters that control how many tasks run during
the deployment and the ordering of stopping and starting tasks.}

\item{placementConstraints}{An array of placement constraint objects to use for tasks in your
service. You can specify a maximum of 10 constraints per task (this
limit includes constraints in the task definition and those specified at
runtime).}

\item{placementStrategy}{The placement strategy objects to use for tasks in your service. You can
specify a maximum of five strategy rules per service.}

\item{networkConfiguration}{The network configuration for the service. This parameter is required
for task definitions that use the \code{awsvpc} network mode to receive their
own elastic network interface, and it is not supported for other network
modes. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html}{Task Networking}
in the \emph{Amazon Elastic Container Service Developer Guide}.}

\item{healthCheckGracePeriodSeconds}{The period of time, in seconds, that the Amazon ECS service scheduler
should ignore unhealthy Elastic Load Balancing target health checks
after a task has first started. This is only valid if your service is
configured to use a load balancer. If your service\'s tasks take a while
to start and respond to Elastic Load Balancing health checks, you can
specify a health check grace period of up to 2,147,483,647 seconds.
During that time, the ECS service scheduler ignores health check status.
This grace period can prevent the ECS service scheduler from marking
tasks as unhealthy and stopping them before they have time to come up.}

\item{schedulingStrategy}{The scheduling strategy to use for the service. For more information,
see
\href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html}{Services}.

There are two service scheduler strategies available:
\itemize{
\item \code{REPLICA}-The replica scheduling strategy places and maintains the
desired number of tasks across your cluster. By default, the service
scheduler spreads tasks across Availability Zones. You can use task
placement strategies and constraints to customize task placement
decisions. This scheduler strategy is required if the service is
using the \code{CODE_DEPLOY} or \code{EXTERNAL} deployment controller types.
\item \code{DAEMON}-The daemon scheduling strategy deploys exactly one task on
each active container instance that meets all of the task placement
constraints that you specify in your cluster. When you\'re using
this strategy, you don\'t need to specify a desired number of tasks,
a task placement strategy, or use Service Auto Scaling policies.

Tasks using the Fargate launch type or the \code{CODE_DEPLOY} or
\code{EXTERNAL} deployment controller types don\'t support the \code{DAEMON}
scheduling strategy.
}}

\item{deploymentController}{The deployment controller to use for the service.}

\item{tags}{The metadata that you apply to the service to help you categorize and
organize them. Each tag consists of a key and an optional value, both of
which you define. When a service is deleted, the tags are deleted as
well.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per resource - 50
\item For each resource, each tag key must be unique, and each tag key can
have only one value.
\item Maximum key length - 128 Unicode characters in UTF-8
\item Maximum value length - 256 Unicode characters in UTF-8
\item If your tagging schema is used across multiple services and
resources, remember that other services may have restrictions on
allowed characters. Generally allowed characters are: letters,
numbers, and spaces representable in UTF-8, and the following
characters: + - = . \\_ : / @.
\item Tag keys and values are case-sensitive.
\item Do not use \verb{aws:}, \verb{AWS:}, or any upper or lowercase combination of
such as a prefix for either keys or values as it is reserved for AWS
use. You cannot edit or delete tag keys or values with this prefix.
Tags with this prefix do not count against your tags per resource
limit.
}}

\item{enableECSManagedTags}{Specifies whether to enable Amazon ECS managed tags for the tasks within
the service. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html}{Tagging Your Amazon ECS Resources}
in the \emph{Amazon Elastic Container Service Developer Guide}.}

\item{propagateTags}{Specifies whether to propagate the tags from the task definition or the
service to the tasks in the service. If no value is specified, the tags
are not propagated. Tags can only be propagated to the tasks within the
service during service creation. To add tags to a task after service
creation, use the TagResource API action.}
}
\description{
Runs and maintains a desired number of tasks from a specified task
definition. If the number of tasks running in a service drops below the
\code{desiredCount}, Amazon ECS runs another copy of the task in the
specified cluster. To update an existing service, see UpdateService.
}
\details{
In addition to maintaining the desired count of tasks in your service,
you can optionally run your service behind one or more load balancers.
The load balancers distribute traffic across the tasks that are
associated with the service. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html}{Service Load Balancing}
in the \emph{Amazon Elastic Container Service Developer Guide}.

Tasks for services that \emph{do not} use a load balancer are considered
healthy if they\'re in the \code{RUNNING} state. Tasks for services that \emph{do}
use a load balancer are considered healthy if they\'re in the \code{RUNNING}
state and the container instance that they\'re hosted on is reported as
healthy by the load balancer.

There are two service scheduler strategies available:
\itemize{
\item \code{REPLICA} - The replica scheduling strategy places and maintains the
desired number of tasks across your cluster. By default, the service
scheduler spreads tasks across Availability Zones. You can use task
placement strategies and constraints to customize task placement
decisions. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html}{Service Scheduler Concepts}
in the \emph{Amazon Elastic Container Service Developer Guide}.
\item \code{DAEMON} - The daemon scheduling strategy deploys exactly one task
on each active container instance that meets all of the task
placement constraints that you specify in your cluster. When using
this strategy, you don\'t need to specify a desired number of tasks,
a task placement strategy, or use Service Auto Scaling policies. For
more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html}{Service Scheduler Concepts}
in the \emph{Amazon Elastic Container Service Developer Guide}.
}

You can optionally specify a deployment configuration for your service.
The deployment is triggered by changing properties, such as the task
definition or the desired count of a service, with an UpdateService
operation. The default value for a replica service for
\code{minimumHealthyPercent} is 100\%. The default value for a daemon service
for \code{minimumHealthyPercent} is 0\%.

If a service is using the \code{ECS} deployment controller, the minimum
healthy percent represents a lower limit on the number of tasks in a
service that must remain in the \code{RUNNING} state during a deployment, as
a percentage of the desired number of tasks (rounded up to the nearest
integer), and while any container instances are in the \code{DRAINING} state
if the service contains tasks using the EC2 launch type. This parameter
enables you to deploy without using additional cluster capacity. For
example, if your service has a desired number of four tasks and a
minimum healthy percent of 50\%, the scheduler might stop two existing
tasks to free up cluster capacity before starting two new tasks. Tasks
for services that \emph{do not} use a load balancer are considered healthy if
they\'re in the \code{RUNNING} state. Tasks for services that \emph{do} use a load
balancer are considered healthy if they\'re in the \code{RUNNING} state and
they\'re reported as healthy by the load balancer. The default value for
minimum healthy percent is 100\%.

If a service is using the \code{ECS} deployment controller, the \strong{maximum
percent} parameter represents an upper limit on the number of tasks in
a service that are allowed in the \code{RUNNING} or \code{PENDING} state during a
deployment, as a percentage of the desired number of tasks (rounded down
to the nearest integer), and while any container instances are in the
\code{DRAINING} state if the service contains tasks using the EC2 launch
type. This parameter enables you to define the deployment batch size.
For example, if your service has a desired number of four tasks and a
maximum percent value of 200\%, the scheduler may start four new tasks
before stopping the four older tasks (provided that the cluster
resources required to do this are available). The default value for
maximum percent is 200\%.

If a service is using either the \code{CODE_DEPLOY} or \code{EXTERNAL} deployment
controller types and tasks that use the EC2 launch type, the \strong{minimum
healthy percent} and \strong{maximum percent} values are used only to define
the lower and upper limit on the number of the tasks in the service that
remain in the \code{RUNNING} state while the container instances are in the
\code{DRAINING} state. If the tasks in the service use the Fargate launch
type, the minimum healthy percent and maximum percent values aren\'t
used, although they\'re currently visible when describing your service.

When creating a service that uses the \code{EXTERNAL} deployment controller,
you can specify only parameters that aren\'t controlled at the task set
level. The only required parameter is the service name. You control your
services using the CreateTaskSet operation. For more information, see
\href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html}{Amazon ECS Deployment Types}
in the \emph{Amazon Elastic Container Service Developer Guide}.

When the service scheduler launches new tasks, it determines task
placement in your cluster using the following logic:
\itemize{
\item Determine which of the container instances in your cluster can
support your service\'s task definition (for example, they have the
required CPU, memory, ports, and container instance attributes).
\item By default, the service scheduler attempts to balance tasks across
Availability Zones in this manner (although you can choose a
different placement strategy) with the \code{placementStrategy}
parameter):
\itemize{
\item Sort the valid container instances, giving priority to instances
that have the fewest number of running tasks for this service in
their respective Availability Zone. For example, if zone A has
one running service task and zones B and C each have zero, valid
container instances in either zone B or C are considered optimal
for placement.
\item Place the new service task on a valid container instance in an
optimal Availability Zone (based on the previous steps),
favoring container instances with the fewest number of running
tasks for this service.
}
}
}
\section{Request syntax}{
\preformatted{svc$create_service(
  cluster = "string",
  serviceName = "string",
  taskDefinition = "string",
  loadBalancers = list(
    list(
      targetGroupArn = "string",
      loadBalancerName = "string",
      containerName = "string",
      containerPort = 123
    )
  ),
  serviceRegistries = list(
    list(
      registryArn = "string",
      port = 123,
      containerName = "string",
      containerPort = 123
    )
  ),
  desiredCount = 123,
  clientToken = "string",
  launchType = "EC2"|"FARGATE",
  capacityProviderStrategy = list(
    list(
      capacityProvider = "string",
      weight = 123,
      base = 123
    )
  ),
  platformVersion = "string",
  role = "string",
  deploymentConfiguration = list(
    maximumPercent = 123,
    minimumHealthyPercent = 123
  ),
  placementConstraints = list(
    list(
      type = "distinctInstance"|"memberOf",
      expression = "string"
    )
  ),
  placementStrategy = list(
    list(
      type = "random"|"spread"|"binpack",
      field = "string"
    )
  ),
  networkConfiguration = list(
    awsvpcConfiguration = list(
      subnets = list(
        "string"
      ),
      securityGroups = list(
        "string"
      ),
      assignPublicIp = "ENABLED"|"DISABLED"
    )
  ),
  healthCheckGracePeriodSeconds = 123,
  schedulingStrategy = "REPLICA"|"DAEMON",
  deploymentController = list(
    type = "ECS"|"CODE_DEPLOY"|"EXTERNAL"
  ),
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  ),
  enableECSManagedTags = TRUE|FALSE,
  propagateTags = "TASK_DEFINITION"|"SERVICE"
)
}
}

\examples{
# This example creates a service in your default region called
# `ecs-simple-service`. The service uses the `hello_world` task
# definition and it maintains 10 copies of that task.
\dontrun{svc$create_service(
  desiredCount = 10L,
  serviceName = "ecs-simple-service",
  taskDefinition = "hello_world"
)}

# This example creates a service in your default region called
# `ecs-simple-service-elb`. The service uses the `ecs-demo` task
# definition and it maintains 10 copies of that task. You must reference
# an existing load balancer in the same region by its name.
\dontrun{svc$create_service(
  desiredCount = 10L,
  loadBalancers = list(
    list(
      containerName = "simple-app",
      containerPort = 80L,
      loadBalancerName = "EC2Contai-EcsElast-15DCDAURT3ZO2"
    )
  ),
  role = "ecsServiceRole",
  serviceName = "ecs-simple-service-elb",
  taskDefinition = "console-sample-app-static"
)}

}
\keyword{internal}
