% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_client_vpn_authorization_rules}
\alias{ec2_describe_client_vpn_authorization_rules}
\title{Describes the authorization rules for a specified Client VPN endpoint}
\usage{
ec2_describe_client_vpn_authorization_rules(ClientVpnEndpointId, DryRun,
  NextToken, Filters, MaxResults)
}
\arguments{
\item{ClientVpnEndpointId}{[required] The ID of the Client VPN endpoint.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{NextToken}{The token to retrieve the next page of results.}

\item{Filters}{One or more filters. Filter names and values are case-sensitive.}

\item{MaxResults}{The maximum number of results to return for the request in a single
page. The remaining results can be seen by sending another request with
the nextToken value.}
}
\description{
Describes the authorization rules for a specified Client VPN endpoint.
}
\section{Request syntax}{
\preformatted{svc$describe_client_vpn_authorization_rules(
  ClientVpnEndpointId = "string",
  DryRun = TRUE|FALSE,
  NextToken = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123
)
}
}

\keyword{internal}
