# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include ec2instanceconnect_service.R
NULL

#' Pushes an SSH public key to a particular OS user on a given EC2 instance
#' for 60 seconds
#'
#' Pushes an SSH public key to a particular OS user on a given EC2 instance
#' for 60 seconds.
#'
#' @usage
#' ec2instanceconnect_send_ssh_public_key(InstanceId, InstanceOSUser,
#'   SSHPublicKey, AvailabilityZone)
#'
#' @param InstanceId &#91;required&#93; The EC2 instance you wish to publish the SSH key to.
#' @param InstanceOSUser &#91;required&#93; The OS user on the EC2 instance whom the key may be used to authenticate
#' as.
#' @param SSHPublicKey &#91;required&#93; The public key to be published to the instance. To use it after
#' publication you must have the matching private key.
#' @param AvailabilityZone &#91;required&#93; The availability zone the EC2 instance was launched in.
#'
#' @section Request syntax:
#' ```
#' svc$send_ssh_public_key(
#'   InstanceId = "string",
#'   InstanceOSUser = "string",
#'   SSHPublicKey = "string",
#'   AvailabilityZone = "string"
#' )
#' ```
#'
#' @examples
#' # The following example pushes a sample SSH public key to the EC2 instance
#' # i-abcd1234 in AZ us-west-2b for use by the instance OS user ec2-user.
#' \donttest{svc$send_ssh_public_key(
#'   AvailabilityZone = "us-west-2a",
#'   InstanceId = "i-abcd1234",
#'   InstanceOSUser = "ec2-user",
#'   SSHPublicKey = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQC3FlHqj2eqCdrGHuA6dRjfZXQ4HX5lXEIRHa..."
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2instanceconnect_send_ssh_public_key
ec2instanceconnect_send_ssh_public_key <- function(InstanceId, InstanceOSUser, SSHPublicKey, AvailabilityZone) {
  op <- new_operation(
    name = "SendSSHPublicKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2instanceconnect$send_ssh_public_key_input(InstanceId = InstanceId, InstanceOSUser = InstanceOSUser, SSHPublicKey = SSHPublicKey, AvailabilityZone = AvailabilityZone)
  output <- .ec2instanceconnect$send_ssh_public_key_output()
  svc <- .ec2instanceconnect$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2instanceconnect$operations$send_ssh_public_key <- ec2instanceconnect_send_ssh_public_key
