% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_apply_environment_managed_action}
\alias{elasticbeanstalk_apply_environment_managed_action}
\title{Applies a scheduled managed action immediately}
\usage{
elasticbeanstalk_apply_environment_managed_action(EnvironmentName,
  EnvironmentId, ActionId)
}
\arguments{
\item{EnvironmentName}{The name of the target environment.}

\item{EnvironmentId}{The environment ID of the target environment.}

\item{ActionId}{[required] The action ID of the scheduled managed action to execute.}
}
\value{
A list with the following syntax:\preformatted{list(
  ActionId = "string",
  ActionDescription = "string",
  ActionType = "InstanceRefresh"|"PlatformUpdate"|"Unknown",
  Status = "string"
)
}
}
\description{
Applies a scheduled managed action immediately. A managed action can be
applied only if its status is \code{Scheduled}. Get the status and action ID
of a managed action with
\code{\link[=elasticbeanstalk_describe_environment_managed_actions]{describe_environment_managed_actions}}.
}
\section{Request syntax}{
\preformatted{svc$apply_environment_managed_action(
  EnvironmentName = "string",
  EnvironmentId = "string",
  ActionId = "string"
)
}
}

\keyword{internal}
