% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_attach_certificate_to_distribution}
\alias{lightsail_attach_certificate_to_distribution}
\title{Attaches an SSL/TLS certificate to your Amazon Lightsail content
delivery network (CDN) distribution}
\usage{
lightsail_attach_certificate_to_distribution(distributionName,
  certificateName)
}
\arguments{
\item{distributionName}{[required] The name of the distribution that the certificate will be attached to.

Use the \code{GetDistributions} action to get a list of distribution names
that you can specify.}

\item{certificateName}{[required] The name of the certificate to attach to a distribution.

Only certificates with a status of \code{ISSUED} can be attached to a
distribution.

Use the \code{GetCertificates} action to get a list of certificate names that
you can specify.

This is the name of the certificate resource type and is used only to
reference the certificate in other API actions. It can be different than
the domain name of the certificate. For example, your certificate name
might be \code{WordPress-Blog-Certificate} and the domain name of the
certificate might be \code{example.com}.}
}
\description{
Attaches an SSL/TLS certificate to your Amazon Lightsail content
delivery network (CDN) distribution.

After the certificate is attached, your distribution accepts HTTPS
traffic for all of the domains that are associated with the certificate.

Use the \code{CreateCertificate} action to create a certificate that you can
attach to your distribution.

Only certificates created in the \code{us-east-1} AWS Region can be attached
to Lightsail distributions. Lightsail distributions are global resources
that can reference an origin in any AWS Region, and distribute its
content globally. However, all distributions are located in the
\code{us-east-1} Region.
}
\section{Request syntax}{
\preformatted{svc$attach_certificate_to_distribution(
  distributionName = "string",
  certificateName = "string"
)
}
}

\keyword{internal}
