% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_deregister_task_definition}
\alias{ecs_deregister_task_definition}
\title{Deregisters the specified task definition by family and revision}
\usage{
ecs_deregister_task_definition(taskDefinition)
}
\arguments{
\item{taskDefinition}{[required] The \code{family} and \code{revision} (\code{family:revision}) or full Amazon Resource
Name (ARN) of the task definition to deregister. You must specify a
\code{revision}.}
}
\description{
Deregisters the specified task definition by family and revision. Upon
deregistration, the task definition is marked as \code{INACTIVE}. Existing
tasks and services that reference an \code{INACTIVE} task definition continue
to run without disruption. Existing services that reference an
\code{INACTIVE} task definition can still scale up or down by modifying the
service's desired count.

You cannot use an \code{INACTIVE} task definition to run new tasks or create
new services, and you cannot update an existing service to reference an
\code{INACTIVE} task definition. However, there may be up to a 10-minute
window following deregistration where these restrictions have not yet
taken effect.

At this time, \code{INACTIVE} task definitions remain discoverable in your
account indefinitely. However, this behavior is subject to change in the
future, so you should not rely on \code{INACTIVE} task definitions persisting
beyond the lifecycle of any associated tasks and services.
}
\section{Request syntax}{
\preformatted{svc$deregister_task_definition(
  taskDefinition = "string"
)
}
}

\keyword{internal}
