% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_describe_image_scan_findings}
\alias{ecr_describe_image_scan_findings}
\title{Returns the scan findings for the specified image}
\usage{
ecr_describe_image_scan_findings(registryId, repositoryName, imageId,
  nextToken, maxResults)
}
\arguments{
\item{registryId}{The AWS account ID associated with the registry that contains the
repository in which to describe the image scan findings for. If you do
not specify a registry, the default registry is assumed.}

\item{repositoryName}{[required] The repository for the image for which to describe the scan findings.}

\item{imageId}{[required]}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated
\code{DescribeImageScanFindings} request where \code{maxResults} was used and the
results exceeded the value of that parameter. Pagination continues from
the end of the previous results that returned the \code{nextToken} value.
This value is null when there are no more results to return.}

\item{maxResults}{The maximum number of image scan results returned by
\code{DescribeImageScanFindings} in paginated output. When this parameter is
used, \code{DescribeImageScanFindings} only returns \code{maxResults} results in a
single page along with a \code{nextToken} response element. The remaining
results of the initial request can be seen by sending another
\code{DescribeImageScanFindings} request with the returned \code{nextToken} value.
This value can be between 1 and 1000. If this parameter is not used,
then \code{DescribeImageScanFindings} returns up to 100 results and a
\code{nextToken} value, if applicable.}
}
\description{
Returns the scan findings for the specified image.
}
\section{Request syntax}{
\preformatted{svc$describe_image_scan_findings(
  registryId = "string",
  repositoryName = "string",
  imageId = list(
    imageDigest = "string",
    imageTag = "string"
  ),
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
