% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_instance_export_task}
\alias{ec2_create_instance_export_task}
\title{Exports a running or stopped instance to an Amazon S3 bucket}
\usage{
ec2_create_instance_export_task(Description, ExportToS3Task, InstanceId,
  TargetEnvironment, TagSpecifications)
}
\arguments{
\item{Description}{A description for the conversion task or the resource being exported.
The maximum length is 255 characters.}

\item{ExportToS3Task}{[required] The format and location for an instance export task.}

\item{InstanceId}{[required] The ID of the instance.}

\item{TargetEnvironment}{[required] The target virtualization environment.}

\item{TagSpecifications}{The tags to apply to the instance export task during creation.}
}
\description{
Exports a running or stopped instance to an Amazon S3 bucket.

For information about the supported operating systems, image formats,
and known limitations for the types of instances you can export, see
\href{https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html}{Exporting an Instance as a VM Using VM Import/Export}
in the \emph{VM Import/Export User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_instance_export_task(
  Description = "string",
  ExportToS3Task = list(
    ContainerFormat = "ova",
    DiskImageFormat = "VMDK"|"RAW"|"VHD",
    S3Bucket = "string",
    S3Prefix = "string"
  ),
  InstanceId = "string",
  TargetEnvironment = "citrix"|"vmware"|"microsoft",
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  )
)
}
}

\keyword{internal}
