# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include swf_service.R
NULL

#' Returns the number of closed workflow executions within the given domain
#' that meet the specified filtering criteria
#'
#' @description
#' Returns the number of closed workflow executions within the given domain that meet the specified filtering criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_count_closed_workflow_executions/](https://www.paws-r-sdk.com/docs/swf_count_closed_workflow_executions/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain containing the workflow executions to count.
#' @param startTimeFilter If specified, only workflow executions that meet the start time criteria
#' of the filter are counted.
#' 
#' `startTimeFilter` and `closeTimeFilter` are mutually exclusive. You must
#' specify one of these in a request but not both.
#' @param closeTimeFilter If specified, only workflow executions that meet the close time criteria
#' of the filter are counted.
#' 
#' `startTimeFilter` and `closeTimeFilter` are mutually exclusive. You must
#' specify one of these in a request but not both.
#' @param executionFilter If specified, only workflow executions matching the `WorkflowId` in the
#' filter are counted.
#' 
#' `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are
#' mutually exclusive. You can specify at most one of these in a request.
#' @param typeFilter If specified, indicates the type of the workflow executions to be
#' counted.
#' 
#' `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are
#' mutually exclusive. You can specify at most one of these in a request.
#' @param tagFilter If specified, only executions that have a tag that matches the filter
#' are counted.
#' 
#' `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are
#' mutually exclusive. You can specify at most one of these in a request.
#' @param closeStatusFilter If specified, only workflow executions that match this close status are
#' counted. This filter has an affect only if `executionStatus` is
#' specified as `CLOSED`.
#' 
#' `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are
#' mutually exclusive. You can specify at most one of these in a request.
#'
#' @keywords internal
#'
#' @rdname swf_count_closed_workflow_executions
swf_count_closed_workflow_executions <- function(domain, startTimeFilter = NULL, closeTimeFilter = NULL, executionFilter = NULL, typeFilter = NULL, tagFilter = NULL, closeStatusFilter = NULL) {
  op <- new_operation(
    name = "CountClosedWorkflowExecutions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$count_closed_workflow_executions_input(domain = domain, startTimeFilter = startTimeFilter, closeTimeFilter = closeTimeFilter, executionFilter = executionFilter, typeFilter = typeFilter, tagFilter = tagFilter, closeStatusFilter = closeStatusFilter)
  output <- .swf$count_closed_workflow_executions_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$count_closed_workflow_executions <- swf_count_closed_workflow_executions

#' Returns the number of open workflow executions within the given domain
#' that meet the specified filtering criteria
#'
#' @description
#' Returns the number of open workflow executions within the given domain that meet the specified filtering criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_count_open_workflow_executions/](https://www.paws-r-sdk.com/docs/swf_count_open_workflow_executions/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain containing the workflow executions to count.
#' @param startTimeFilter &#91;required&#93; Specifies the start time criteria that workflow executions must meet in
#' order to be counted.
#' @param typeFilter Specifies the type of the workflow executions to be counted.
#' 
#' `executionFilter`, `typeFilter` and `tagFilter` are mutually exclusive.
#' You can specify at most one of these in a request.
#' @param tagFilter If specified, only executions that have a tag that matches the filter
#' are counted.
#' 
#' `executionFilter`, `typeFilter` and `tagFilter` are mutually exclusive.
#' You can specify at most one of these in a request.
#' @param executionFilter If specified, only workflow executions matching the `WorkflowId` in the
#' filter are counted.
#' 
#' `executionFilter`, `typeFilter` and `tagFilter` are mutually exclusive.
#' You can specify at most one of these in a request.
#'
#' @keywords internal
#'
#' @rdname swf_count_open_workflow_executions
swf_count_open_workflow_executions <- function(domain, startTimeFilter, typeFilter = NULL, tagFilter = NULL, executionFilter = NULL) {
  op <- new_operation(
    name = "CountOpenWorkflowExecutions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$count_open_workflow_executions_input(domain = domain, startTimeFilter = startTimeFilter, typeFilter = typeFilter, tagFilter = tagFilter, executionFilter = executionFilter)
  output <- .swf$count_open_workflow_executions_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$count_open_workflow_executions <- swf_count_open_workflow_executions

#' Returns the estimated number of activity tasks in the specified task
#' list
#'
#' @description
#' Returns the estimated number of activity tasks in the specified task list. The count returned is an approximation and isn't guaranteed to be exact. If you specify a task list that no activity task was ever scheduled in then `0` is returned.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_count_pending_activity_tasks/](https://www.paws-r-sdk.com/docs/swf_count_pending_activity_tasks/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the task list.
#' @param taskList &#91;required&#93; The name of the task list.
#'
#' @keywords internal
#'
#' @rdname swf_count_pending_activity_tasks
swf_count_pending_activity_tasks <- function(domain, taskList) {
  op <- new_operation(
    name = "CountPendingActivityTasks",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$count_pending_activity_tasks_input(domain = domain, taskList = taskList)
  output <- .swf$count_pending_activity_tasks_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$count_pending_activity_tasks <- swf_count_pending_activity_tasks

#' Returns the estimated number of decision tasks in the specified task
#' list
#'
#' @description
#' Returns the estimated number of decision tasks in the specified task list. The count returned is an approximation and isn't guaranteed to be exact. If you specify a task list that no decision task was ever scheduled in then `0` is returned.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_count_pending_decision_tasks/](https://www.paws-r-sdk.com/docs/swf_count_pending_decision_tasks/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the task list.
#' @param taskList &#91;required&#93; The name of the task list.
#'
#' @keywords internal
#'
#' @rdname swf_count_pending_decision_tasks
swf_count_pending_decision_tasks <- function(domain, taskList) {
  op <- new_operation(
    name = "CountPendingDecisionTasks",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$count_pending_decision_tasks_input(domain = domain, taskList = taskList)
  output <- .swf$count_pending_decision_tasks_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$count_pending_decision_tasks <- swf_count_pending_decision_tasks

#' Deletes the specified activity type
#'
#' @description
#' Deletes the specified *activity type*.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_delete_activity_type/](https://www.paws-r-sdk.com/docs/swf_delete_activity_type/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain in which the activity type is registered.
#' @param activityType &#91;required&#93; The activity type to delete.
#'
#' @keywords internal
#'
#' @rdname swf_delete_activity_type
swf_delete_activity_type <- function(domain, activityType) {
  op <- new_operation(
    name = "DeleteActivityType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$delete_activity_type_input(domain = domain, activityType = activityType)
  output <- .swf$delete_activity_type_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$delete_activity_type <- swf_delete_activity_type

#' Deletes the specified workflow type
#'
#' @description
#' Deletes the specified *workflow type*.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_delete_workflow_type/](https://www.paws-r-sdk.com/docs/swf_delete_workflow_type/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain in which the workflow type is registered.
#' @param workflowType &#91;required&#93; The workflow type to delete.
#'
#' @keywords internal
#'
#' @rdname swf_delete_workflow_type
swf_delete_workflow_type <- function(domain, workflowType) {
  op <- new_operation(
    name = "DeleteWorkflowType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$delete_workflow_type_input(domain = domain, workflowType = workflowType)
  output <- .swf$delete_workflow_type_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$delete_workflow_type <- swf_delete_workflow_type

#' Deprecates the specified activity type
#'
#' @description
#' Deprecates the specified *activity type*. After an activity type has been deprecated, you cannot create new tasks of that activity type. Tasks of this type that were scheduled before the type was deprecated continue to run.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_deprecate_activity_type/](https://www.paws-r-sdk.com/docs/swf_deprecate_activity_type/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain in which the activity type is registered.
#' @param activityType &#91;required&#93; The activity type to deprecate.
#'
#' @keywords internal
#'
#' @rdname swf_deprecate_activity_type
swf_deprecate_activity_type <- function(domain, activityType) {
  op <- new_operation(
    name = "DeprecateActivityType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$deprecate_activity_type_input(domain = domain, activityType = activityType)
  output <- .swf$deprecate_activity_type_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$deprecate_activity_type <- swf_deprecate_activity_type

#' Deprecates the specified domain
#'
#' @description
#' Deprecates the specified domain. After a domain has been deprecated it cannot be used to create new workflow executions or register new types. However, you can still use visibility actions on this domain. Deprecating a domain also deprecates all activity and workflow types registered in the domain. Executions that were started before the domain was deprecated continues to run.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_deprecate_domain/](https://www.paws-r-sdk.com/docs/swf_deprecate_domain/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the domain to deprecate.
#'
#' @keywords internal
#'
#' @rdname swf_deprecate_domain
swf_deprecate_domain <- function(name) {
  op <- new_operation(
    name = "DeprecateDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$deprecate_domain_input(name = name)
  output <- .swf$deprecate_domain_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$deprecate_domain <- swf_deprecate_domain

#' Deprecates the specified workflow type
#'
#' @description
#' Deprecates the specified *workflow type*. After a workflow type has been deprecated, you cannot create new executions of that type. Executions that were started before the type was deprecated continues to run. A deprecated workflow type may still be used when calling visibility actions.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_deprecate_workflow_type/](https://www.paws-r-sdk.com/docs/swf_deprecate_workflow_type/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain in which the workflow type is registered.
#' @param workflowType &#91;required&#93; The workflow type to deprecate.
#'
#' @keywords internal
#'
#' @rdname swf_deprecate_workflow_type
swf_deprecate_workflow_type <- function(domain, workflowType) {
  op <- new_operation(
    name = "DeprecateWorkflowType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$deprecate_workflow_type_input(domain = domain, workflowType = workflowType)
  output <- .swf$deprecate_workflow_type_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$deprecate_workflow_type <- swf_deprecate_workflow_type

#' Returns information about the specified activity type
#'
#' @description
#' Returns information about the specified activity type. This includes configuration settings provided when the type was registered and other general information about the type.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_describe_activity_type/](https://www.paws-r-sdk.com/docs/swf_describe_activity_type/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain in which the activity type is registered.
#' @param activityType &#91;required&#93; The activity type to get information about. Activity types are
#' identified by the `name` and `version` that were supplied when the
#' activity was registered.
#'
#' @keywords internal
#'
#' @rdname swf_describe_activity_type
swf_describe_activity_type <- function(domain, activityType) {
  op <- new_operation(
    name = "DescribeActivityType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$describe_activity_type_input(domain = domain, activityType = activityType)
  output <- .swf$describe_activity_type_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$describe_activity_type <- swf_describe_activity_type

#' Returns information about the specified domain, including description
#' and status
#'
#' @description
#' Returns information about the specified domain, including description and status.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_describe_domain/](https://www.paws-r-sdk.com/docs/swf_describe_domain/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the domain to describe.
#'
#' @keywords internal
#'
#' @rdname swf_describe_domain
swf_describe_domain <- function(name) {
  op <- new_operation(
    name = "DescribeDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$describe_domain_input(name = name)
  output <- .swf$describe_domain_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$describe_domain <- swf_describe_domain

#' Returns information about the specified workflow execution including its
#' type and some statistics
#'
#' @description
#' Returns information about the specified workflow execution including its type and some statistics.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_describe_workflow_execution/](https://www.paws-r-sdk.com/docs/swf_describe_workflow_execution/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain containing the workflow execution.
#' @param execution &#91;required&#93; The workflow execution to describe.
#'
#' @keywords internal
#'
#' @rdname swf_describe_workflow_execution
swf_describe_workflow_execution <- function(domain, execution) {
  op <- new_operation(
    name = "DescribeWorkflowExecution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$describe_workflow_execution_input(domain = domain, execution = execution)
  output <- .swf$describe_workflow_execution_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$describe_workflow_execution <- swf_describe_workflow_execution

#' Returns information about the specified workflow type
#'
#' @description
#' Returns information about the specified *workflow type*. This includes configuration settings specified when the type was registered and other information such as creation date, current status, etc.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_describe_workflow_type/](https://www.paws-r-sdk.com/docs/swf_describe_workflow_type/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain in which this workflow type is registered.
#' @param workflowType &#91;required&#93; The workflow type to describe.
#'
#' @keywords internal
#'
#' @rdname swf_describe_workflow_type
swf_describe_workflow_type <- function(domain, workflowType) {
  op <- new_operation(
    name = "DescribeWorkflowType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$describe_workflow_type_input(domain = domain, workflowType = workflowType)
  output <- .swf$describe_workflow_type_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$describe_workflow_type <- swf_describe_workflow_type

#' Returns the history of the specified workflow execution
#'
#' @description
#' Returns the history of the specified workflow execution. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the `nextPageToken` returned by the initial call.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_get_workflow_execution_history/](https://www.paws-r-sdk.com/docs/swf_get_workflow_execution_history/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain containing the workflow execution.
#' @param execution &#91;required&#93; Specifies the workflow execution for which to return the history.
#' @param nextPageToken If `NextPageToken` is returned there are more results available. The
#' value of `NextPageToken` is a unique pagination token for each page.
#' Make the call again using the returned token to retrieve the next page.
#' Keep all other arguments unchanged. Each pagination token expires after
#' 24 hours. Using an expired pagination token will return a `400` error:
#' "`Specified token has exceeded its maximum lifetime`".
#' 
#' The configured `maximumPageSize` determines how many results can be
#' returned in a single call.
#' @param maximumPageSize The maximum number of results that are returned per call. Use
#' `nextPageToken` to obtain further pages of results.
#' @param reverseOrder When set to `true`, returns the events in reverse order. By default the
#' results are returned in ascending order of the `eventTimeStamp` of the
#' events.
#'
#' @keywords internal
#'
#' @rdname swf_get_workflow_execution_history
swf_get_workflow_execution_history <- function(domain, execution, nextPageToken = NULL, maximumPageSize = NULL, reverseOrder = NULL) {
  op <- new_operation(
    name = "GetWorkflowExecutionHistory",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextPageToken", limit_key = "maximumPageSize", output_token = "nextPageToken", result_key = "events")
  )
  input <- .swf$get_workflow_execution_history_input(domain = domain, execution = execution, nextPageToken = nextPageToken, maximumPageSize = maximumPageSize, reverseOrder = reverseOrder)
  output <- .swf$get_workflow_execution_history_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$get_workflow_execution_history <- swf_get_workflow_execution_history

#' Returns information about all activities registered in the specified
#' domain that match the specified name and registration status
#'
#' @description
#' Returns information about all activities registered in the specified domain that match the specified name and registration status. The result includes information like creation date, current status of the activity, etc. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the `nextPageToken` returned by the initial call.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_list_activity_types/](https://www.paws-r-sdk.com/docs/swf_list_activity_types/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain in which the activity types have been registered.
#' @param name If specified, only lists the activity types that have this name.
#' @param registrationStatus &#91;required&#93; Specifies the registration status of the activity types to list.
#' @param nextPageToken If `NextPageToken` is returned there are more results available. The
#' value of `NextPageToken` is a unique pagination token for each page.
#' Make the call again using the returned token to retrieve the next page.
#' Keep all other arguments unchanged. Each pagination token expires after
#' 24 hours. Using an expired pagination token will return a `400` error:
#' "`Specified token has exceeded its maximum lifetime`".
#' 
#' The configured `maximumPageSize` determines how many results can be
#' returned in a single call.
#' @param maximumPageSize The maximum number of results that are returned per call. Use
#' `nextPageToken` to obtain further pages of results.
#' @param reverseOrder When set to `true`, returns the results in reverse order. By default,
#' the results are returned in ascending alphabetical order by `name` of
#' the activity types.
#'
#' @keywords internal
#'
#' @rdname swf_list_activity_types
swf_list_activity_types <- function(domain, name = NULL, registrationStatus, nextPageToken = NULL, maximumPageSize = NULL, reverseOrder = NULL) {
  op <- new_operation(
    name = "ListActivityTypes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextPageToken", limit_key = "maximumPageSize", output_token = "nextPageToken", result_key = "typeInfos")
  )
  input <- .swf$list_activity_types_input(domain = domain, name = name, registrationStatus = registrationStatus, nextPageToken = nextPageToken, maximumPageSize = maximumPageSize, reverseOrder = reverseOrder)
  output <- .swf$list_activity_types_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$list_activity_types <- swf_list_activity_types

#' Returns a list of closed workflow executions in the specified domain
#' that meet the filtering criteria
#'
#' @description
#' Returns a list of closed workflow executions in the specified domain that meet the filtering criteria. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken returned by the initial call.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_list_closed_workflow_executions/](https://www.paws-r-sdk.com/docs/swf_list_closed_workflow_executions/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the workflow executions to list.
#' @param startTimeFilter If specified, the workflow executions are included in the returned
#' results based on whether their start times are within the range
#' specified by this filter. Also, if this parameter is specified, the
#' returned results are ordered by their start times.
#' 
#' `startTimeFilter` and `closeTimeFilter` are mutually exclusive. You must
#' specify one of these in a request but not both.
#' @param closeTimeFilter If specified, the workflow executions are included in the returned
#' results based on whether their close times are within the range
#' specified by this filter. Also, if this parameter is specified, the
#' returned results are ordered by their close times.
#' 
#' `startTimeFilter` and `closeTimeFilter` are mutually exclusive. You must
#' specify one of these in a request but not both.
#' @param executionFilter If specified, only workflow executions matching the workflow ID
#' specified in the filter are returned.
#' 
#' `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are
#' mutually exclusive. You can specify at most one of these in a request.
#' @param closeStatusFilter If specified, only workflow executions that match this *close status*
#' are listed. For example, if TERMINATED is specified, then only
#' TERMINATED workflow executions are listed.
#' 
#' `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are
#' mutually exclusive. You can specify at most one of these in a request.
#' @param typeFilter If specified, only executions of the type specified in the filter are
#' returned.
#' 
#' `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are
#' mutually exclusive. You can specify at most one of these in a request.
#' @param tagFilter If specified, only executions that have the matching tag are listed.
#' 
#' `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are
#' mutually exclusive. You can specify at most one of these in a request.
#' @param nextPageToken If `NextPageToken` is returned there are more results available. The
#' value of `NextPageToken` is a unique pagination token for each page.
#' Make the call again using the returned token to retrieve the next page.
#' Keep all other arguments unchanged. Each pagination token expires after
#' 24 hours. Using an expired pagination token will return a `400` error:
#' "`Specified token has exceeded its maximum lifetime`".
#' 
#' The configured `maximumPageSize` determines how many results can be
#' returned in a single call.
#' @param maximumPageSize The maximum number of results that are returned per call. Use
#' `nextPageToken` to obtain further pages of results.
#' @param reverseOrder When set to `true`, returns the results in reverse order. By default the
#' results are returned in descending order of the start or the close time
#' of the executions.
#'
#' @keywords internal
#'
#' @rdname swf_list_closed_workflow_executions
swf_list_closed_workflow_executions <- function(domain, startTimeFilter = NULL, closeTimeFilter = NULL, executionFilter = NULL, closeStatusFilter = NULL, typeFilter = NULL, tagFilter = NULL, nextPageToken = NULL, maximumPageSize = NULL, reverseOrder = NULL) {
  op <- new_operation(
    name = "ListClosedWorkflowExecutions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextPageToken", limit_key = "maximumPageSize", output_token = "nextPageToken", result_key = "executionInfos")
  )
  input <- .swf$list_closed_workflow_executions_input(domain = domain, startTimeFilter = startTimeFilter, closeTimeFilter = closeTimeFilter, executionFilter = executionFilter, closeStatusFilter = closeStatusFilter, typeFilter = typeFilter, tagFilter = tagFilter, nextPageToken = nextPageToken, maximumPageSize = maximumPageSize, reverseOrder = reverseOrder)
  output <- .swf$list_closed_workflow_executions_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$list_closed_workflow_executions <- swf_list_closed_workflow_executions

#' Returns the list of domains registered in the account
#'
#' @description
#' Returns the list of domains registered in the account. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken returned by the initial call.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_list_domains/](https://www.paws-r-sdk.com/docs/swf_list_domains/) for full documentation.
#'
#' @param nextPageToken If `NextPageToken` is returned there are more results available. The
#' value of `NextPageToken` is a unique pagination token for each page.
#' Make the call again using the returned token to retrieve the next page.
#' Keep all other arguments unchanged. Each pagination token expires after
#' 24 hours. Using an expired pagination token will return a `400` error:
#' "`Specified token has exceeded its maximum lifetime`".
#' 
#' The configured `maximumPageSize` determines how many results can be
#' returned in a single call.
#' @param registrationStatus &#91;required&#93; Specifies the registration status of the domains to list.
#' @param maximumPageSize The maximum number of results that are returned per call. Use
#' `nextPageToken` to obtain further pages of results.
#' @param reverseOrder When set to `true`, returns the results in reverse order. By default,
#' the results are returned in ascending alphabetical order by `name` of
#' the domains.
#'
#' @keywords internal
#'
#' @rdname swf_list_domains
swf_list_domains <- function(nextPageToken = NULL, registrationStatus, maximumPageSize = NULL, reverseOrder = NULL) {
  op <- new_operation(
    name = "ListDomains",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextPageToken", limit_key = "maximumPageSize", output_token = "nextPageToken", result_key = "domainInfos")
  )
  input <- .swf$list_domains_input(nextPageToken = nextPageToken, registrationStatus = registrationStatus, maximumPageSize = maximumPageSize, reverseOrder = reverseOrder)
  output <- .swf$list_domains_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$list_domains <- swf_list_domains

#' Returns a list of open workflow executions in the specified domain that
#' meet the filtering criteria
#'
#' @description
#' Returns a list of open workflow executions in the specified domain that meet the filtering criteria. The results may be split into multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken returned by the initial call.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_list_open_workflow_executions/](https://www.paws-r-sdk.com/docs/swf_list_open_workflow_executions/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the workflow executions to list.
#' @param startTimeFilter &#91;required&#93; Workflow executions are included in the returned results based on
#' whether their start times are within the range specified by this filter.
#' @param typeFilter If specified, only executions of the type specified in the filter are
#' returned.
#' 
#' `executionFilter`, `typeFilter` and `tagFilter` are mutually exclusive.
#' You can specify at most one of these in a request.
#' @param tagFilter If specified, only executions that have the matching tag are listed.
#' 
#' `executionFilter`, `typeFilter` and `tagFilter` are mutually exclusive.
#' You can specify at most one of these in a request.
#' @param nextPageToken If `NextPageToken` is returned there are more results available. The
#' value of `NextPageToken` is a unique pagination token for each page.
#' Make the call again using the returned token to retrieve the next page.
#' Keep all other arguments unchanged. Each pagination token expires after
#' 24 hours. Using an expired pagination token will return a `400` error:
#' "`Specified token has exceeded its maximum lifetime`".
#' 
#' The configured `maximumPageSize` determines how many results can be
#' returned in a single call.
#' @param maximumPageSize The maximum number of results that are returned per call. Use
#' `nextPageToken` to obtain further pages of results.
#' @param reverseOrder When set to `true`, returns the results in reverse order. By default the
#' results are returned in descending order of the start time of the
#' executions.
#' @param executionFilter If specified, only workflow executions matching the workflow ID
#' specified in the filter are returned.
#' 
#' `executionFilter`, `typeFilter` and `tagFilter` are mutually exclusive.
#' You can specify at most one of these in a request.
#'
#' @keywords internal
#'
#' @rdname swf_list_open_workflow_executions
swf_list_open_workflow_executions <- function(domain, startTimeFilter, typeFilter = NULL, tagFilter = NULL, nextPageToken = NULL, maximumPageSize = NULL, reverseOrder = NULL, executionFilter = NULL) {
  op <- new_operation(
    name = "ListOpenWorkflowExecutions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextPageToken", limit_key = "maximumPageSize", output_token = "nextPageToken", result_key = "executionInfos")
  )
  input <- .swf$list_open_workflow_executions_input(domain = domain, startTimeFilter = startTimeFilter, typeFilter = typeFilter, tagFilter = tagFilter, nextPageToken = nextPageToken, maximumPageSize = maximumPageSize, reverseOrder = reverseOrder, executionFilter = executionFilter)
  output <- .swf$list_open_workflow_executions_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$list_open_workflow_executions <- swf_list_open_workflow_executions

#' List tags for a given domain
#'
#' @description
#' List tags for a given domain.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/swf_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the Amazon SWF domain.
#'
#' @keywords internal
#'
#' @rdname swf_list_tags_for_resource
swf_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .swf$list_tags_for_resource_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$list_tags_for_resource <- swf_list_tags_for_resource

#' Returns information about workflow types in the specified domain
#'
#' @description
#' Returns information about workflow types in the specified domain. The results may be split into multiple pages that can be retrieved by making the call repeatedly.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_list_workflow_types/](https://www.paws-r-sdk.com/docs/swf_list_workflow_types/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain in which the workflow types have been registered.
#' @param name If specified, lists the workflow type with this name.
#' @param registrationStatus &#91;required&#93; Specifies the registration status of the workflow types to list.
#' @param nextPageToken If `NextPageToken` is returned there are more results available. The
#' value of `NextPageToken` is a unique pagination token for each page.
#' Make the call again using the returned token to retrieve the next page.
#' Keep all other arguments unchanged. Each pagination token expires after
#' 24 hours. Using an expired pagination token will return a `400` error:
#' "`Specified token has exceeded its maximum lifetime`".
#' 
#' The configured `maximumPageSize` determines how many results can be
#' returned in a single call.
#' @param maximumPageSize The maximum number of results that are returned per call. Use
#' `nextPageToken` to obtain further pages of results.
#' @param reverseOrder When set to `true`, returns the results in reverse order. By default the
#' results are returned in ascending alphabetical order of the `name` of
#' the workflow types.
#'
#' @keywords internal
#'
#' @rdname swf_list_workflow_types
swf_list_workflow_types <- function(domain, name = NULL, registrationStatus, nextPageToken = NULL, maximumPageSize = NULL, reverseOrder = NULL) {
  op <- new_operation(
    name = "ListWorkflowTypes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextPageToken", limit_key = "maximumPageSize", output_token = "nextPageToken", result_key = "typeInfos")
  )
  input <- .swf$list_workflow_types_input(domain = domain, name = name, registrationStatus = registrationStatus, nextPageToken = nextPageToken, maximumPageSize = maximumPageSize, reverseOrder = reverseOrder)
  output <- .swf$list_workflow_types_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$list_workflow_types <- swf_list_workflow_types

#' Used by workers to get an ActivityTask from the specified activity
#' taskList
#'
#' @description
#' Used by workers to get an ActivityTask from the specified activity `taskList`. This initiates a long poll, where the service holds the HTTP connection open and responds as soon as a task becomes available. The maximum time the service holds on to the request before responding is 60 seconds. If no task is available within 60 seconds, the poll returns an empty result. An empty result, in this context, means that an ActivityTask is returned, but that the value of taskToken is an empty string. If a task is returned, the worker should use its type to identify and process it correctly.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_poll_for_activity_task/](https://www.paws-r-sdk.com/docs/swf_poll_for_activity_task/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain that contains the task lists being polled.
#' @param taskList &#91;required&#93; Specifies the task list to poll for activity tasks.
#' 
#' The specified string must not start or end with whitespace. It must not
#' contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control
#' characters (``U+0000`-`U+001f`` | ``U+007f`-`U+009f``). Also, it must *not* be
#' the literal string `arn`.
#' @param identity Identity of the worker making the request, recorded in the
#' `ActivityTaskStarted` event in the workflow history. This enables
#' diagnostic tracing when problems arise. The form of this identity is
#' user defined.
#'
#' @keywords internal
#'
#' @rdname swf_poll_for_activity_task
swf_poll_for_activity_task <- function(domain, taskList, identity = NULL) {
  op <- new_operation(
    name = "PollForActivityTask",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$poll_for_activity_task_input(domain = domain, taskList = taskList, identity = identity)
  output <- .swf$poll_for_activity_task_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$poll_for_activity_task <- swf_poll_for_activity_task

#' Used by deciders to get a DecisionTask from the specified decision
#' taskList
#'
#' @description
#' Used by deciders to get a DecisionTask from the specified decision `taskList`. A decision task may be returned for any open workflow execution that is using the specified task list. The task includes a paginated view of the history of the workflow execution. The decider should use the workflow type and the history to determine how to properly handle the task.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_poll_for_decision_task/](https://www.paws-r-sdk.com/docs/swf_poll_for_decision_task/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain containing the task lists to poll.
#' @param taskList &#91;required&#93; Specifies the task list to poll for decision tasks.
#' 
#' The specified string must not contain a `:` (colon), `/` (slash), `|`
#' (vertical bar), or any control characters (``U+0000`-`U+001f`` |
#' ``U+007f`-`U+009f``). Also, it must *not* be the literal string `arn`.
#' @param identity Identity of the decider making the request, which is recorded in the
#' DecisionTaskStarted event in the workflow history. This enables
#' diagnostic tracing when problems arise. The form of this identity is
#' user defined.
#' @param nextPageToken If `NextPageToken` is returned there are more results available. The
#' value of `NextPageToken` is a unique pagination token for each page.
#' Make the call again using the returned token to retrieve the next page.
#' Keep all other arguments unchanged. Each pagination token expires after
#' 24 hours. Using an expired pagination token will return a `400` error:
#' "`Specified token has exceeded its maximum lifetime`".
#' 
#' The configured `maximumPageSize` determines how many results can be
#' returned in a single call.
#' 
#' The `nextPageToken` returned by this action cannot be used with
#' [`get_workflow_execution_history`][swf_get_workflow_execution_history]
#' to get the next page. You must call
#' [`poll_for_decision_task`][swf_poll_for_decision_task] again (with the
#' `nextPageToken`) to retrieve the next page of history records. Calling
#' [`poll_for_decision_task`][swf_poll_for_decision_task] with a
#' `nextPageToken` doesn't return a new decision task.
#' @param maximumPageSize The maximum number of results that are returned per call. Use
#' `nextPageToken` to obtain further pages of results.
#' 
#' This is an upper limit only; the actual number of results returned per
#' call may be fewer than the specified maximum.
#' @param reverseOrder When set to `true`, returns the events in reverse order. By default the
#' results are returned in ascending order of the `eventTimestamp` of the
#' events.
#' @param startAtPreviousStartedEvent When set to `true`, returns the events with `eventTimestamp` greater
#' than or equal to `eventTimestamp` of the most recent
#' `DecisionTaskStarted` event. By default, this parameter is set to
#' `false`.
#'
#' @keywords internal
#'
#' @rdname swf_poll_for_decision_task
swf_poll_for_decision_task <- function(domain, taskList, identity = NULL, nextPageToken = NULL, maximumPageSize = NULL, reverseOrder = NULL, startAtPreviousStartedEvent = NULL) {
  op <- new_operation(
    name = "PollForDecisionTask",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextPageToken", limit_key = "maximumPageSize", output_token = "nextPageToken", result_key = "events")
  )
  input <- .swf$poll_for_decision_task_input(domain = domain, taskList = taskList, identity = identity, nextPageToken = nextPageToken, maximumPageSize = maximumPageSize, reverseOrder = reverseOrder, startAtPreviousStartedEvent = startAtPreviousStartedEvent)
  output <- .swf$poll_for_decision_task_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$poll_for_decision_task <- swf_poll_for_decision_task

#' Used by activity workers to report to the service that the ActivityTask
#' represented by the specified taskToken is still making progress
#'
#' @description
#' Used by activity workers to report to the service that the ActivityTask represented by the specified `taskToken` is still making progress. The worker can also specify details of the progress, for example percent complete, using the `details` parameter. This action can also be used by the worker as a mechanism to check if cancellation is being requested for the activity task. If a cancellation is being attempted for the specified task, then the boolean `cancelRequested` flag returned by the service is set to `true`.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_record_activity_task_heartbeat/](https://www.paws-r-sdk.com/docs/swf_record_activity_task_heartbeat/) for full documentation.
#'
#' @param taskToken &#91;required&#93; The `taskToken` of the ActivityTask.
#' 
#' `taskToken` is generated by the service and should be treated as an
#' opaque value. If the task is passed to another process, its `taskToken`
#' must also be passed. This enables it to provide its progress and respond
#' with results.
#' @param details If specified, contains details about the progress of the task.
#'
#' @keywords internal
#'
#' @rdname swf_record_activity_task_heartbeat
swf_record_activity_task_heartbeat <- function(taskToken, details = NULL) {
  op <- new_operation(
    name = "RecordActivityTaskHeartbeat",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$record_activity_task_heartbeat_input(taskToken = taskToken, details = details)
  output <- .swf$record_activity_task_heartbeat_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$record_activity_task_heartbeat <- swf_record_activity_task_heartbeat

#' Registers a new activity type along with its configuration settings in
#' the specified domain
#'
#' @description
#' Registers a new *activity type* along with its configuration settings in the specified domain.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_register_activity_type/](https://www.paws-r-sdk.com/docs/swf_register_activity_type/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain in which this activity is to be registered.
#' @param name &#91;required&#93; The name of the activity type within the domain.
#' 
#' The specified string must not contain a `:` (colon), `/` (slash), `|`
#' (vertical bar), or any control characters (``U+0000`-`U+001f`` |
#' ``U+007f`-`U+009f``). Also, it must *not* be the literal string `arn`.
#' @param version &#91;required&#93; The version of the activity type.
#' 
#' The activity type consists of the name and version, the combination of
#' which must be unique within the domain.
#' 
#' The specified string must not contain a `:` (colon), `/` (slash), `|`
#' (vertical bar), or any control characters (``U+0000`-`U+001f`` |
#' ``U+007f`-`U+009f``). Also, it must *not* be the literal string `arn`.
#' @param description A textual description of the activity type.
#' @param defaultTaskStartToCloseTimeout If set, specifies the default maximum duration that a worker can take to
#' process tasks of this activity type. This default can be overridden when
#' scheduling an activity task using the `ScheduleActivityTask` Decision.
#' 
#' The duration is specified in seconds, an integer greater than or equal
#' to `0`. You can use `NONE` to specify unlimited duration.
#' @param defaultTaskHeartbeatTimeout If set, specifies the default maximum time before which a worker
#' processing a task of this type must report progress by calling
#' [`record_activity_task_heartbeat`][swf_record_activity_task_heartbeat].
#' If the timeout is exceeded, the activity task is automatically timed
#' out. This default can be overridden when scheduling an activity task
#' using the `ScheduleActivityTask` Decision. If the activity worker
#' subsequently attempts to record a heartbeat or returns a result, the
#' activity worker receives an `UnknownResource` fault. In this case,
#' Amazon SWF no longer considers the activity task to be valid; the
#' activity worker should clean up the activity task.
#' 
#' The duration is specified in seconds, an integer greater than or equal
#' to `0`. You can use `NONE` to specify unlimited duration.
#' @param defaultTaskList If set, specifies the default task list to use for scheduling tasks of
#' this activity type. This default task list is used if a task list isn't
#' provided when a task is scheduled through the `ScheduleActivityTask`
#' Decision.
#' @param defaultTaskPriority The default task priority to assign to the activity type. If not
#' assigned, then `0` is used. Valid values are integers that range from
#' Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE`
#' (2147483647). Higher numbers indicate higher priority.
#' 
#' For more information about setting task priority, see [Setting Task
#' Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
#' in the *in the Amazon SWF Developer Guide.*.
#' @param defaultTaskScheduleToStartTimeout If set, specifies the default maximum duration that a task of this
#' activity type can wait before being assigned to a worker. This default
#' can be overridden when scheduling an activity task using the
#' `ScheduleActivityTask` Decision.
#' 
#' The duration is specified in seconds, an integer greater than or equal
#' to `0`. You can use `NONE` to specify unlimited duration.
#' @param defaultTaskScheduleToCloseTimeout If set, specifies the default maximum duration for a task of this
#' activity type. This default can be overridden when scheduling an
#' activity task using the `ScheduleActivityTask` Decision.
#' 
#' The duration is specified in seconds, an integer greater than or equal
#' to `0`. You can use `NONE` to specify unlimited duration.
#'
#' @keywords internal
#'
#' @rdname swf_register_activity_type
swf_register_activity_type <- function(domain, name, version, description = NULL, defaultTaskStartToCloseTimeout = NULL, defaultTaskHeartbeatTimeout = NULL, defaultTaskList = NULL, defaultTaskPriority = NULL, defaultTaskScheduleToStartTimeout = NULL, defaultTaskScheduleToCloseTimeout = NULL) {
  op <- new_operation(
    name = "RegisterActivityType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$register_activity_type_input(domain = domain, name = name, version = version, description = description, defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout, defaultTaskHeartbeatTimeout = defaultTaskHeartbeatTimeout, defaultTaskList = defaultTaskList, defaultTaskPriority = defaultTaskPriority, defaultTaskScheduleToStartTimeout = defaultTaskScheduleToStartTimeout, defaultTaskScheduleToCloseTimeout = defaultTaskScheduleToCloseTimeout)
  output <- .swf$register_activity_type_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$register_activity_type <- swf_register_activity_type

#' Registers a new domain
#'
#' @description
#' Registers a new domain.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_register_domain/](https://www.paws-r-sdk.com/docs/swf_register_domain/) for full documentation.
#'
#' @param name &#91;required&#93; Name of the domain to register. The name must be unique in the region
#' that the domain is registered in.
#' 
#' The specified string must not start or end with whitespace. It must not
#' contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control
#' characters (``U+0000`-`U+001f`` | ``U+007f`-`U+009f``). Also, it must *not* be
#' the literal string `arn`.
#' @param description A text description of the domain.
#' @param workflowExecutionRetentionPeriodInDays &#91;required&#93; The duration (in days) that records and histories of workflow executions
#' on the domain should be kept by the service. After the retention period,
#' the workflow execution isn't available in the results of visibility
#' calls.
#' 
#' If you pass the value `NONE` or `0` (zero), then the workflow execution
#' history isn't retained. As soon as the workflow execution completes, the
#' execution record and its history are deleted.
#' 
#' The maximum workflow execution retention period is 90 days. For more
#' information about Amazon SWF service limits, see: [Amazon SWF Service
#' Limits](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html)
#' in the *Amazon SWF Developer Guide*.
#' @param tags Tags to be added when registering a domain.
#' 
#' Tags may only contain unicode letters, digits, whitespace, or these
#' symbols: `_ . : / = + - @@`.
#'
#' @keywords internal
#'
#' @rdname swf_register_domain
swf_register_domain <- function(name, description = NULL, workflowExecutionRetentionPeriodInDays, tags = NULL) {
  op <- new_operation(
    name = "RegisterDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$register_domain_input(name = name, description = description, workflowExecutionRetentionPeriodInDays = workflowExecutionRetentionPeriodInDays, tags = tags)
  output <- .swf$register_domain_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$register_domain <- swf_register_domain

#' Registers a new workflow type and its configuration settings in the
#' specified domain
#'
#' @description
#' Registers a new *workflow type* and its configuration settings in the specified domain.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_register_workflow_type/](https://www.paws-r-sdk.com/docs/swf_register_workflow_type/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain in which to register the workflow type.
#' @param name &#91;required&#93; The name of the workflow type.
#' 
#' The specified string must not contain a `:` (colon), `/` (slash), `|`
#' (vertical bar), or any control characters (``U+0000`-`U+001f`` |
#' ``U+007f`-`U+009f``). Also, it must *not* be the literal string `arn`.
#' @param version &#91;required&#93; The version of the workflow type.
#' 
#' The workflow type consists of the name and version, the combination of
#' which must be unique within the domain. To get a list of all currently
#' registered workflow types, use the
#' [`list_workflow_types`][swf_list_workflow_types] action.
#' 
#' The specified string must not contain a `:` (colon), `/` (slash), `|`
#' (vertical bar), or any control characters (``U+0000`-`U+001f`` |
#' ``U+007f`-`U+009f``). Also, it must *not* be the literal string `arn`.
#' @param description Textual description of the workflow type.
#' @param defaultTaskStartToCloseTimeout If set, specifies the default maximum duration of decision tasks for
#' this workflow type. This default can be overridden when starting a
#' workflow execution using the
#' [`start_workflow_execution`][swf_start_workflow_execution] action or the
#' `StartChildWorkflowExecution` Decision.
#' 
#' The duration is specified in seconds, an integer greater than or equal
#' to `0`. You can use `NONE` to specify unlimited duration.
#' @param defaultExecutionStartToCloseTimeout If set, specifies the default maximum duration for executions of this
#' workflow type. You can override this default when starting an execution
#' through the [`start_workflow_execution`][swf_start_workflow_execution]
#' Action or `StartChildWorkflowExecution` Decision.
#' 
#' The duration is specified in seconds; an integer greater than or equal
#' to 0. Unlike some of the other timeout parameters in Amazon SWF, you
#' cannot specify a value of "NONE" for
#' `defaultExecutionStartToCloseTimeout`; there is a one-year max limit on
#' the time that a workflow execution can run. Exceeding this limit always
#' causes the workflow execution to time out.
#' @param defaultTaskList If set, specifies the default task list to use for scheduling decision
#' tasks for executions of this workflow type. This default is used only if
#' a task list isn't provided when starting the execution through the
#' [`start_workflow_execution`][swf_start_workflow_execution] Action or
#' `StartChildWorkflowExecution` Decision.
#' @param defaultTaskPriority The default task priority to assign to the workflow type. If not
#' assigned, then `0` is used. Valid values are integers that range from
#' Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE`
#' (2147483647). Higher numbers indicate higher priority.
#' 
#' For more information about setting task priority, see [Setting Task
#' Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
#' in the *Amazon SWF Developer Guide*.
#' @param defaultChildPolicy If set, specifies the default policy to use for the child workflow
#' executions when a workflow execution of this type is terminated, by
#' calling the
#' [`terminate_workflow_execution`][swf_terminate_workflow_execution]
#' action explicitly or due to an expired timeout. This default can be
#' overridden when starting a workflow execution using the
#' [`start_workflow_execution`][swf_start_workflow_execution] action or the
#' `StartChildWorkflowExecution` Decision.
#' 
#' The supported child policies are:
#' 
#' -   `TERMINATE` – The child executions are terminated.
#' 
#' -   `REQUEST_CANCEL` – A request to cancel is attempted for each child
#'     execution by recording a `WorkflowExecutionCancelRequested` event in
#'     its history. It is up to the decider to take appropriate actions
#'     when it receives an execution history with this event.
#' 
#' -   `ABANDON` – No action is taken. The child executions continue to
#'     run.
#' @param defaultLambdaRole The default IAM role attached to this workflow type.
#' 
#' Executions of this workflow type need IAM roles to invoke Lambda
#' functions. If you don't specify an IAM role when you start this workflow
#' type, the default Lambda role is attached to the execution. For more
#' information, see
#' <https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html>
#' in the *Amazon SWF Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname swf_register_workflow_type
swf_register_workflow_type <- function(domain, name, version, description = NULL, defaultTaskStartToCloseTimeout = NULL, defaultExecutionStartToCloseTimeout = NULL, defaultTaskList = NULL, defaultTaskPriority = NULL, defaultChildPolicy = NULL, defaultLambdaRole = NULL) {
  op <- new_operation(
    name = "RegisterWorkflowType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$register_workflow_type_input(domain = domain, name = name, version = version, description = description, defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout, defaultExecutionStartToCloseTimeout = defaultExecutionStartToCloseTimeout, defaultTaskList = defaultTaskList, defaultTaskPriority = defaultTaskPriority, defaultChildPolicy = defaultChildPolicy, defaultLambdaRole = defaultLambdaRole)
  output <- .swf$register_workflow_type_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$register_workflow_type <- swf_register_workflow_type

#' Records a WorkflowExecutionCancelRequested event in the currently
#' running workflow execution identified by the given domain, workflowId,
#' and runId
#'
#' @description
#' Records a `WorkflowExecutionCancelRequested` event in the currently running workflow execution identified by the given domain, workflowId, and runId. This logically requests the cancellation of the workflow execution as a whole. It is up to the decider to take appropriate actions when it receives an execution history with this event.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_request_cancel_workflow_execution/](https://www.paws-r-sdk.com/docs/swf_request_cancel_workflow_execution/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain containing the workflow execution to cancel.
#' @param workflowId &#91;required&#93; The workflowId of the workflow execution to cancel.
#' @param runId The runId of the workflow execution to cancel.
#'
#' @keywords internal
#'
#' @rdname swf_request_cancel_workflow_execution
swf_request_cancel_workflow_execution <- function(domain, workflowId, runId = NULL) {
  op <- new_operation(
    name = "RequestCancelWorkflowExecution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$request_cancel_workflow_execution_input(domain = domain, workflowId = workflowId, runId = runId)
  output <- .swf$request_cancel_workflow_execution_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$request_cancel_workflow_execution <- swf_request_cancel_workflow_execution

#' Used by workers to tell the service that the ActivityTask identified by
#' the taskToken was successfully canceled
#'
#' @description
#' Used by workers to tell the service that the ActivityTask identified by the `taskToken` was successfully canceled. Additional `details` can be provided using the `details` argument.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_respond_activity_task_canceled/](https://www.paws-r-sdk.com/docs/swf_respond_activity_task_canceled/) for full documentation.
#'
#' @param taskToken &#91;required&#93; The `taskToken` of the ActivityTask.
#' 
#' `taskToken` is generated by the service and should be treated as an
#' opaque value. If the task is passed to another process, its `taskToken`
#' must also be passed. This enables it to provide its progress and respond
#' with results.
#' @param details Information about the cancellation.
#'
#' @keywords internal
#'
#' @rdname swf_respond_activity_task_canceled
swf_respond_activity_task_canceled <- function(taskToken, details = NULL) {
  op <- new_operation(
    name = "RespondActivityTaskCanceled",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$respond_activity_task_canceled_input(taskToken = taskToken, details = details)
  output <- .swf$respond_activity_task_canceled_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$respond_activity_task_canceled <- swf_respond_activity_task_canceled

#' Used by workers to tell the service that the ActivityTask identified by
#' the taskToken completed successfully with a result (if provided)
#'
#' @description
#' Used by workers to tell the service that the ActivityTask identified by the `taskToken` completed successfully with a `result` (if provided). The `result` appears in the `ActivityTaskCompleted` event in the workflow history.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_respond_activity_task_completed/](https://www.paws-r-sdk.com/docs/swf_respond_activity_task_completed/) for full documentation.
#'
#' @param taskToken &#91;required&#93; The `taskToken` of the ActivityTask.
#' 
#' `taskToken` is generated by the service and should be treated as an
#' opaque value. If the task is passed to another process, its `taskToken`
#' must also be passed. This enables it to provide its progress and respond
#' with results.
#' @param result The result of the activity task. It is a free form string that is
#' implementation specific.
#'
#' @keywords internal
#'
#' @rdname swf_respond_activity_task_completed
swf_respond_activity_task_completed <- function(taskToken, result = NULL) {
  op <- new_operation(
    name = "RespondActivityTaskCompleted",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$respond_activity_task_completed_input(taskToken = taskToken, result = result)
  output <- .swf$respond_activity_task_completed_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$respond_activity_task_completed <- swf_respond_activity_task_completed

#' Used by workers to tell the service that the ActivityTask identified by
#' the taskToken has failed with reason (if specified)
#'
#' @description
#' Used by workers to tell the service that the ActivityTask identified by the `taskToken` has failed with `reason` (if specified). The `reason` and `details` appear in the `ActivityTaskFailed` event added to the workflow history.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_respond_activity_task_failed/](https://www.paws-r-sdk.com/docs/swf_respond_activity_task_failed/) for full documentation.
#'
#' @param taskToken &#91;required&#93; The `taskToken` of the ActivityTask.
#' 
#' `taskToken` is generated by the service and should be treated as an
#' opaque value. If the task is passed to another process, its `taskToken`
#' must also be passed. This enables it to provide its progress and respond
#' with results.
#' @param reason Description of the error that may assist in diagnostics.
#' @param details Detailed information about the failure.
#'
#' @keywords internal
#'
#' @rdname swf_respond_activity_task_failed
swf_respond_activity_task_failed <- function(taskToken, reason = NULL, details = NULL) {
  op <- new_operation(
    name = "RespondActivityTaskFailed",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$respond_activity_task_failed_input(taskToken = taskToken, reason = reason, details = details)
  output <- .swf$respond_activity_task_failed_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$respond_activity_task_failed <- swf_respond_activity_task_failed

#' Used by deciders to tell the service that the DecisionTask identified by
#' the taskToken has successfully completed
#'
#' @description
#' Used by deciders to tell the service that the DecisionTask identified by the `taskToken` has successfully completed. The `decisions` argument specifies the list of decisions made while processing the task.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_respond_decision_task_completed/](https://www.paws-r-sdk.com/docs/swf_respond_decision_task_completed/) for full documentation.
#'
#' @param taskToken &#91;required&#93; The `taskToken` from the DecisionTask.
#' 
#' `taskToken` is generated by the service and should be treated as an
#' opaque value. If the task is passed to another process, its `taskToken`
#' must also be passed. This enables it to provide its progress and respond
#' with results.
#' @param decisions The list of decisions (possibly empty) made by the decider while
#' processing this decision task. See the docs for the Decision structure
#' for details.
#' @param executionContext User defined context to add to workflow execution.
#' @param taskList The task list to use for the future decision tasks of this workflow
#' execution. This list overrides the original task list you specified
#' while starting the workflow execution.
#' @param taskListScheduleToStartTimeout Specifies a timeout (in seconds) for the task list override. When this
#' parameter is missing, the task list override is permanent. This
#' parameter makes it possible to temporarily override the task list. If a
#' decision task scheduled on the override task list is not started within
#' the timeout, the decision task will time out. Amazon SWF will revert the
#' override and schedule a new decision task to the original task list.
#' 
#' If a decision task scheduled on the override task list is started within
#' the timeout, but not completed within the start-to-close timeout, Amazon
#' SWF will also revert the override and schedule a new decision task to
#' the original task list.
#'
#' @keywords internal
#'
#' @rdname swf_respond_decision_task_completed
swf_respond_decision_task_completed <- function(taskToken, decisions = NULL, executionContext = NULL, taskList = NULL, taskListScheduleToStartTimeout = NULL) {
  op <- new_operation(
    name = "RespondDecisionTaskCompleted",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$respond_decision_task_completed_input(taskToken = taskToken, decisions = decisions, executionContext = executionContext, taskList = taskList, taskListScheduleToStartTimeout = taskListScheduleToStartTimeout)
  output <- .swf$respond_decision_task_completed_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$respond_decision_task_completed <- swf_respond_decision_task_completed

#' Records a WorkflowExecutionSignaled event in the workflow execution
#' history and creates a decision task for the workflow execution
#' identified by the given domain, workflowId and runId
#'
#' @description
#' Records a `WorkflowExecutionSignaled` event in the workflow execution history and creates a decision task for the workflow execution identified by the given domain, workflowId and runId. The event is recorded with the specified user defined signalName and input (if provided).
#'
#' See [https://www.paws-r-sdk.com/docs/swf_signal_workflow_execution/](https://www.paws-r-sdk.com/docs/swf_signal_workflow_execution/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain containing the workflow execution to signal.
#' @param workflowId &#91;required&#93; The workflowId of the workflow execution to signal.
#' @param runId The runId of the workflow execution to signal.
#' @param signalName &#91;required&#93; The name of the signal. This name must be meaningful to the target
#' workflow.
#' @param input Data to attach to the `WorkflowExecutionSignaled` event in the target
#' workflow execution's history.
#'
#' @keywords internal
#'
#' @rdname swf_signal_workflow_execution
swf_signal_workflow_execution <- function(domain, workflowId, runId = NULL, signalName, input = NULL) {
  op <- new_operation(
    name = "SignalWorkflowExecution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$signal_workflow_execution_input(domain = domain, workflowId = workflowId, runId = runId, signalName = signalName, input = input)
  output <- .swf$signal_workflow_execution_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$signal_workflow_execution <- swf_signal_workflow_execution

#' Starts an execution of the workflow type in the specified domain using
#' the provided workflowId and input data
#'
#' @description
#' Starts an execution of the workflow type in the specified domain using the provided `workflowId` and input data.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_start_workflow_execution/](https://www.paws-r-sdk.com/docs/swf_start_workflow_execution/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain in which the workflow execution is created.
#' 
#' The specified string must not contain a `:` (colon), `/` (slash), `|`
#' (vertical bar), or any control characters (``U+0000`-`U+001f`` |
#' ``U+007f`-`U+009f``). Also, it must *not* be the literal string `arn`.
#' @param workflowId &#91;required&#93; The user defined identifier associated with the workflow execution. You
#' can use this to associate a custom identifier with the workflow
#' execution. You may specify the same identifier if a workflow execution
#' is logically a *restart* of a previous execution. You cannot have two
#' open workflow executions with the same `workflowId` at the same time
#' within the same domain.
#' 
#' The specified string must not contain a `:` (colon), `/` (slash), `|`
#' (vertical bar), or any control characters (``U+0000`-`U+001f`` |
#' ``U+007f`-`U+009f``). Also, it must *not* be the literal string `arn`.
#' @param workflowType &#91;required&#93; The type of the workflow to start.
#' @param taskList The task list to use for the decision tasks generated for this workflow
#' execution. This overrides the `defaultTaskList` specified when
#' registering the workflow type.
#' 
#' A task list for this workflow execution must be specified either as a
#' default for the workflow type or through this parameter. If neither this
#' parameter is set nor a default task list was specified at registration
#' time then a fault is returned.
#' 
#' The specified string must not contain a `:` (colon), `/` (slash), `|`
#' (vertical bar), or any control characters (``U+0000`-`U+001f`` |
#' ``U+007f`-`U+009f``). Also, it must *not* be the literal string `arn`.
#' @param taskPriority The task priority to use for this workflow execution. This overrides any
#' default priority that was assigned when the workflow type was
#' registered. If not set, then the default task priority for the workflow
#' type is used. Valid values are integers that range from Java's
#' `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647).
#' Higher numbers indicate higher priority.
#' 
#' For more information about setting task priority, see [Setting Task
#' Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
#' in the *Amazon SWF Developer Guide*.
#' @param input The input for the workflow execution. This is a free form string which
#' should be meaningful to the workflow you are starting. This `input` is
#' made available to the new workflow execution in the
#' `WorkflowExecutionStarted` history event.
#' @param executionStartToCloseTimeout The total duration for this workflow execution. This overrides the
#' defaultExecutionStartToCloseTimeout specified when registering the
#' workflow type.
#' 
#' The duration is specified in seconds; an integer greater than or equal
#' to `0`. Exceeding this limit causes the workflow execution to time out.
#' Unlike some of the other timeout parameters in Amazon SWF, you cannot
#' specify a value of "NONE" for this timeout; there is a one-year max
#' limit on the time that a workflow execution can run.
#' 
#' An execution start-to-close timeout must be specified either through
#' this parameter or as a default when the workflow type is registered. If
#' neither this parameter nor a default execution start-to-close timeout is
#' specified, a fault is returned.
#' @param tagList The list of tags to associate with the workflow execution. You can
#' specify a maximum of 5 tags. You can list workflow executions with a
#' specific tag by calling
#' [`list_open_workflow_executions`][swf_list_open_workflow_executions] or
#' [`list_closed_workflow_executions`][swf_list_closed_workflow_executions]
#' and specifying a TagFilter.
#' @param taskStartToCloseTimeout Specifies the maximum duration of decision tasks for this workflow
#' execution. This parameter overrides the `defaultTaskStartToCloseTimout`
#' specified when registering the workflow type using
#' [`register_workflow_type`][swf_register_workflow_type].
#' 
#' The duration is specified in seconds, an integer greater than or equal
#' to `0`. You can use `NONE` to specify unlimited duration.
#' 
#' A task start-to-close timeout for this workflow execution must be
#' specified either as a default for the workflow type or through this
#' parameter. If neither this parameter is set nor a default task
#' start-to-close timeout was specified at registration time then a fault
#' is returned.
#' @param childPolicy If set, specifies the policy to use for the child workflow executions of
#' this workflow execution if it is terminated, by calling the
#' [`terminate_workflow_execution`][swf_terminate_workflow_execution]
#' action explicitly or due to an expired timeout. This policy overrides
#' the default child policy specified when registering the workflow type
#' using [`register_workflow_type`][swf_register_workflow_type].
#' 
#' The supported child policies are:
#' 
#' -   `TERMINATE` – The child executions are terminated.
#' 
#' -   `REQUEST_CANCEL` – A request to cancel is attempted for each child
#'     execution by recording a `WorkflowExecutionCancelRequested` event in
#'     its history. It is up to the decider to take appropriate actions
#'     when it receives an execution history with this event.
#' 
#' -   `ABANDON` – No action is taken. The child executions continue to
#'     run.
#' 
#' A child policy for this workflow execution must be specified either as a
#' default for the workflow type or through this parameter. If neither this
#' parameter is set nor a default child policy was specified at
#' registration time then a fault is returned.
#' @param lambdaRole The IAM role to attach to this workflow execution.
#' 
#' Executions of this workflow type need IAM roles to invoke Lambda
#' functions. If you don't attach an IAM role, any attempt to schedule a
#' Lambda task fails. This results in a `ScheduleLambdaFunctionFailed`
#' history event. For more information, see
#' <https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html>
#' in the *Amazon SWF Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname swf_start_workflow_execution
swf_start_workflow_execution <- function(domain, workflowId, workflowType, taskList = NULL, taskPriority = NULL, input = NULL, executionStartToCloseTimeout = NULL, tagList = NULL, taskStartToCloseTimeout = NULL, childPolicy = NULL, lambdaRole = NULL) {
  op <- new_operation(
    name = "StartWorkflowExecution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$start_workflow_execution_input(domain = domain, workflowId = workflowId, workflowType = workflowType, taskList = taskList, taskPriority = taskPriority, input = input, executionStartToCloseTimeout = executionStartToCloseTimeout, tagList = tagList, taskStartToCloseTimeout = taskStartToCloseTimeout, childPolicy = childPolicy, lambdaRole = lambdaRole)
  output <- .swf$start_workflow_execution_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$start_workflow_execution <- swf_start_workflow_execution

#' Add a tag to a Amazon SWF domain
#'
#' @description
#' Add a tag to a Amazon SWF domain.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_tag_resource/](https://www.paws-r-sdk.com/docs/swf_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the Amazon SWF domain.
#' @param tags &#91;required&#93; The list of tags to add to a domain.
#' 
#' Tags may only contain unicode letters, digits, whitespace, or these
#' symbols: `_ . : / = + - @@`.
#'
#' @keywords internal
#'
#' @rdname swf_tag_resource
swf_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .swf$tag_resource_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$tag_resource <- swf_tag_resource

#' Records a WorkflowExecutionTerminated event and forces closure of the
#' workflow execution identified by the given domain, runId, and workflowId
#'
#' @description
#' Records a `WorkflowExecutionTerminated` event and forces closure of the workflow execution identified by the given domain, runId, and workflowId. The child policy, registered with the workflow type or specified when starting this execution, is applied to any open child workflow executions of this workflow execution.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_terminate_workflow_execution/](https://www.paws-r-sdk.com/docs/swf_terminate_workflow_execution/) for full documentation.
#'
#' @param domain &#91;required&#93; The domain of the workflow execution to terminate.
#' @param workflowId &#91;required&#93; The workflowId of the workflow execution to terminate.
#' @param runId The runId of the workflow execution to terminate.
#' @param reason A descriptive reason for terminating the workflow execution.
#' @param details Details for terminating the workflow execution.
#' @param childPolicy If set, specifies the policy to use for the child workflow executions of
#' the workflow execution being terminated. This policy overrides the child
#' policy specified for the workflow execution at registration time or when
#' starting the execution.
#' 
#' The supported child policies are:
#' 
#' -   `TERMINATE` – The child executions are terminated.
#' 
#' -   `REQUEST_CANCEL` – A request to cancel is attempted for each child
#'     execution by recording a `WorkflowExecutionCancelRequested` event in
#'     its history. It is up to the decider to take appropriate actions
#'     when it receives an execution history with this event.
#' 
#' -   `ABANDON` – No action is taken. The child executions continue to
#'     run.
#' 
#' A child policy for this workflow execution must be specified either as a
#' default for the workflow type or through this parameter. If neither this
#' parameter is set nor a default child policy was specified at
#' registration time then a fault is returned.
#'
#' @keywords internal
#'
#' @rdname swf_terminate_workflow_execution
swf_terminate_workflow_execution <- function(domain, workflowId, runId = NULL, reason = NULL, details = NULL, childPolicy = NULL) {
  op <- new_operation(
    name = "TerminateWorkflowExecution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$terminate_workflow_execution_input(domain = domain, workflowId = workflowId, runId = runId, reason = reason, details = details, childPolicy = childPolicy)
  output <- .swf$terminate_workflow_execution_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$terminate_workflow_execution <- swf_terminate_workflow_execution

#' Undeprecates a previously deprecated activity type
#'
#' @description
#' Undeprecates a previously deprecated *activity type*. After an activity type has been undeprecated, you can create new tasks of that activity type.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_undeprecate_activity_type/](https://www.paws-r-sdk.com/docs/swf_undeprecate_activity_type/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain of the deprecated activity type.
#' @param activityType &#91;required&#93; The activity type to undeprecate.
#'
#' @keywords internal
#'
#' @rdname swf_undeprecate_activity_type
swf_undeprecate_activity_type <- function(domain, activityType) {
  op <- new_operation(
    name = "UndeprecateActivityType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$undeprecate_activity_type_input(domain = domain, activityType = activityType)
  output <- .swf$undeprecate_activity_type_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$undeprecate_activity_type <- swf_undeprecate_activity_type

#' Undeprecates a previously deprecated domain
#'
#' @description
#' Undeprecates a previously deprecated domain. After a domain has been undeprecated it can be used to create new workflow executions or register new types.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_undeprecate_domain/](https://www.paws-r-sdk.com/docs/swf_undeprecate_domain/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the domain of the deprecated workflow type.
#'
#' @keywords internal
#'
#' @rdname swf_undeprecate_domain
swf_undeprecate_domain <- function(name) {
  op <- new_operation(
    name = "UndeprecateDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$undeprecate_domain_input(name = name)
  output <- .swf$undeprecate_domain_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$undeprecate_domain <- swf_undeprecate_domain

#' Undeprecates a previously deprecated workflow type
#'
#' @description
#' Undeprecates a previously deprecated *workflow type*. After a workflow type has been undeprecated, you can create new executions of that type.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_undeprecate_workflow_type/](https://www.paws-r-sdk.com/docs/swf_undeprecate_workflow_type/) for full documentation.
#'
#' @param domain &#91;required&#93; The name of the domain of the deprecated workflow type.
#' @param workflowType &#91;required&#93; The name of the domain of the deprecated workflow type.
#'
#' @keywords internal
#'
#' @rdname swf_undeprecate_workflow_type
swf_undeprecate_workflow_type <- function(domain, workflowType) {
  op <- new_operation(
    name = "UndeprecateWorkflowType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$undeprecate_workflow_type_input(domain = domain, workflowType = workflowType)
  output <- .swf$undeprecate_workflow_type_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$undeprecate_workflow_type <- swf_undeprecate_workflow_type

#' Remove a tag from a Amazon SWF domain
#'
#' @description
#' Remove a tag from a Amazon SWF domain.
#'
#' See [https://www.paws-r-sdk.com/docs/swf_untag_resource/](https://www.paws-r-sdk.com/docs/swf_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the Amazon SWF domain.
#' @param tagKeys &#91;required&#93; The list of tags to remove from the Amazon SWF domain.
#'
#' @keywords internal
#'
#' @rdname swf_untag_resource
swf_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .swf$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .swf$untag_resource_output()
  config <- get_config()
  svc <- .swf$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$untag_resource <- swf_untag_resource
