# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include mq_service.R
NULL

#' Creates a broker
#'
#' @description
#' Creates a broker. Note: This API is asynchronous.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_create_broker/](https://www.paws-r-sdk.com/docs/mq_create_broker/) for full documentation.
#'
#' @param AuthenticationStrategy Optional. The authentication strategy used to secure the broker. The
#' default is SIMPLE.
#' @param AutoMinorVersionUpgrade &#91;required&#93; Enables automatic upgrades to new minor versions for brokers, as new
#' versions are released and supported by Amazon MQ. Automatic upgrades
#' occur during the scheduled maintenance window of the broker or after a
#' manual broker reboot. Set to true by default, if no value is specified.
#' @param BrokerName &#91;required&#93; Required. The broker's name. This value must be unique in your Amazon
#' Web Services account, 1-50 characters long, must contain only letters,
#' numbers, dashes, and underscores, and must not contain white spaces,
#' brackets, wildcard characters, or special characters.
#' 
#' Do not add personally identifiable information (PII) or other
#' confidential or sensitive information in broker names. Broker names are
#' accessible to other Amazon Web Services services, including CloudWatch
#' Logs. Broker names are not intended to be used for private or sensitive
#' data.
#' @param Configuration A list of information about the configuration.
#' @param CreatorRequestId The unique ID that the requester receives for the created broker. Amazon
#' MQ passes your ID with the API action.
#' 
#' We recommend using a Universally Unique Identifier (UUID) for the
#' creatorRequestId. You may omit the creatorRequestId if your application
#' doesn't require idempotency.
#' @param DeploymentMode &#91;required&#93; Required. The broker's deployment mode.
#' @param EncryptionOptions Encryption options for the broker.
#' @param EngineType &#91;required&#93; Required. The type of broker engine. Currently, Amazon MQ supports
#' ACTIVEMQ and RABBITMQ.
#' @param EngineVersion &#91;required&#93; Required. The broker engine's version. For a list of supported engine
#' versions, see [Supported
#' engines](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/).
#' @param HostInstanceType &#91;required&#93; Required. The broker's instance type.
#' @param LdapServerMetadata Optional. The metadata of the LDAP server used to authenticate and
#' authorize connections to the broker. Does not apply to RabbitMQ brokers.
#' @param Logs Enables Amazon CloudWatch logging for brokers.
#' @param MaintenanceWindowStartTime The parameters that determine the WeeklyStartTime.
#' @param PubliclyAccessible &#91;required&#93; Enables connections from applications outside of the VPC that hosts the
#' broker's subnets. Set to false by default, if no value is provided.
#' @param SecurityGroups The list of rules (1 minimum, 125 maximum) that authorize connections to
#' brokers.
#' @param StorageType The broker's storage type.
#' @param SubnetIds The list of groups that define which subnets and IP ranges the broker
#' can use from different Availability Zones. If you specify more than one
#' subnet, the subnets must be in different Availability Zones. Amazon MQ
#' will not be able to create VPC endpoints for your broker with multiple
#' subnets in the same Availability Zone. A SINGLE_INSTANCE deployment
#' requires one subnet (for example, the default subnet). An
#' ACTIVE_STANDBY_MULTI_AZ Amazon MQ for ActiveMQ deployment requires two
#' subnets. A CLUSTER_MULTI_AZ Amazon MQ for RabbitMQ deployment has no
#' subnet requirements when deployed with public accessibility. Deployment
#' without public accessibility requires at least one subnet.
#' 
#' If you specify subnets in a [shared
#' VPC](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-sharing.html)
#' for a RabbitMQ broker, the associated VPC to which the specified subnets
#' belong must be owned by your Amazon Web Services account. Amazon MQ will
#' not be able to create VPC endpoints in VPCs that are not owned by your
#' Amazon Web Services account.
#' @param Tags Create tags when creating the broker.
#' @param Users &#91;required&#93; The list of broker users (persons or applications) who can access queues
#' and topics. For Amazon MQ for RabbitMQ brokers, one and only one
#' administrative user is accepted and created when a broker is first
#' provisioned. All subsequent broker users are created by making RabbitMQ
#' API calls directly to brokers or via the RabbitMQ web console.
#' @param DataReplicationMode Defines whether this broker is a part of a data replication pair.
#' @param DataReplicationPrimaryBrokerArn The Amazon Resource Name (ARN) of the primary broker that is used to
#' replicate data from in a data replication pair, and is applied to the
#' replica broker. Must be set when dataReplicationMode is set to CRDR.
#'
#' @keywords internal
#'
#' @rdname mq_create_broker
mq_create_broker <- function(AuthenticationStrategy = NULL, AutoMinorVersionUpgrade, BrokerName, Configuration = NULL, CreatorRequestId = NULL, DeploymentMode, EncryptionOptions = NULL, EngineType, EngineVersion, HostInstanceType, LdapServerMetadata = NULL, Logs = NULL, MaintenanceWindowStartTime = NULL, PubliclyAccessible, SecurityGroups = NULL, StorageType = NULL, SubnetIds = NULL, Tags = NULL, Users, DataReplicationMode = NULL, DataReplicationPrimaryBrokerArn = NULL) {
  op <- new_operation(
    name = "CreateBroker",
    http_method = "POST",
    http_path = "/v1/brokers",
    paginator = list()
  )
  input <- .mq$create_broker_input(AuthenticationStrategy = AuthenticationStrategy, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, BrokerName = BrokerName, Configuration = Configuration, CreatorRequestId = CreatorRequestId, DeploymentMode = DeploymentMode, EncryptionOptions = EncryptionOptions, EngineType = EngineType, EngineVersion = EngineVersion, HostInstanceType = HostInstanceType, LdapServerMetadata = LdapServerMetadata, Logs = Logs, MaintenanceWindowStartTime = MaintenanceWindowStartTime, PubliclyAccessible = PubliclyAccessible, SecurityGroups = SecurityGroups, StorageType = StorageType, SubnetIds = SubnetIds, Tags = Tags, Users = Users, DataReplicationMode = DataReplicationMode, DataReplicationPrimaryBrokerArn = DataReplicationPrimaryBrokerArn)
  output <- .mq$create_broker_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$create_broker <- mq_create_broker

#' Creates a new configuration for the specified configuration name
#'
#' @description
#' Creates a new configuration for the specified configuration name. Amazon MQ uses the default configuration (the engine type and version).
#'
#' See [https://www.paws-r-sdk.com/docs/mq_create_configuration/](https://www.paws-r-sdk.com/docs/mq_create_configuration/) for full documentation.
#'
#' @param AuthenticationStrategy Optional. The authentication strategy associated with the configuration.
#' The default is SIMPLE.
#' @param EngineType &#91;required&#93; Required. The type of broker engine. Currently, Amazon MQ supports
#' ACTIVEMQ and RABBITMQ.
#' @param EngineVersion &#91;required&#93; Required. The broker engine's version. For a list of supported engine
#' versions, see [Supported
#' engines](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/).
#' @param Name &#91;required&#93; Required. The name of the configuration. This value can contain only
#' alphanumeric characters, dashes, periods, underscores, and tildes (- .
#' _ ~). This value must be 1-150 characters long.
#' @param Tags Create tags when creating the configuration.
#'
#' @keywords internal
#'
#' @rdname mq_create_configuration
mq_create_configuration <- function(AuthenticationStrategy = NULL, EngineType, EngineVersion, Name, Tags = NULL) {
  op <- new_operation(
    name = "CreateConfiguration",
    http_method = "POST",
    http_path = "/v1/configurations",
    paginator = list()
  )
  input <- .mq$create_configuration_input(AuthenticationStrategy = AuthenticationStrategy, EngineType = EngineType, EngineVersion = EngineVersion, Name = Name, Tags = Tags)
  output <- .mq$create_configuration_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$create_configuration <- mq_create_configuration

#' Add a tag to a resource
#'
#' @description
#' Add a tag to a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_create_tags/](https://www.paws-r-sdk.com/docs/mq_create_tags/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource tag.
#' @param Tags The key-value pair for the resource tag.
#'
#' @keywords internal
#'
#' @rdname mq_create_tags
mq_create_tags <- function(ResourceArn, Tags = NULL) {
  op <- new_operation(
    name = "CreateTags",
    http_method = "POST",
    http_path = "/v1/tags/{resource-arn}",
    paginator = list()
  )
  input <- .mq$create_tags_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .mq$create_tags_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$create_tags <- mq_create_tags

#' Creates an ActiveMQ user
#'
#' @description
#' Creates an ActiveMQ user.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_create_user/](https://www.paws-r-sdk.com/docs/mq_create_user/) for full documentation.
#'
#' @param BrokerId &#91;required&#93; The unique ID that Amazon MQ generates for the broker.
#' @param ConsoleAccess Enables access to the ActiveMQ Web Console for the ActiveMQ user.
#' @param Groups The list of groups (20 maximum) to which the ActiveMQ user belongs. This
#' value can contain only alphanumeric characters, dashes, periods,
#' underscores, and tildes (- . _ ~). This value must be 2-100 characters
#' long.
#' @param Password &#91;required&#93; Required. The password of the user. This value must be at least 12
#' characters long, must contain at least 4 unique characters, and must not
#' contain commas, colons, or equal signs (,:=).
#' @param Username &#91;required&#93; The username of the ActiveMQ user. This value can contain only
#' alphanumeric characters, dashes, periods, underscores, and tildes (- .
#' _ ~). This value must be 2-100 characters long.
#' @param ReplicationUser Defines if this user is intended for CRDR replication purposes.
#'
#' @keywords internal
#'
#' @rdname mq_create_user
mq_create_user <- function(BrokerId, ConsoleAccess = NULL, Groups = NULL, Password, Username, ReplicationUser = NULL) {
  op <- new_operation(
    name = "CreateUser",
    http_method = "POST",
    http_path = "/v1/brokers/{broker-id}/users/{username}",
    paginator = list()
  )
  input <- .mq$create_user_input(BrokerId = BrokerId, ConsoleAccess = ConsoleAccess, Groups = Groups, Password = Password, Username = Username, ReplicationUser = ReplicationUser)
  output <- .mq$create_user_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$create_user <- mq_create_user

#' Deletes a broker
#'
#' @description
#' Deletes a broker. Note: This API is asynchronous.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_delete_broker/](https://www.paws-r-sdk.com/docs/mq_delete_broker/) for full documentation.
#'
#' @param BrokerId &#91;required&#93; The unique ID that Amazon MQ generates for the broker.
#'
#' @keywords internal
#'
#' @rdname mq_delete_broker
mq_delete_broker <- function(BrokerId) {
  op <- new_operation(
    name = "DeleteBroker",
    http_method = "DELETE",
    http_path = "/v1/brokers/{broker-id}",
    paginator = list()
  )
  input <- .mq$delete_broker_input(BrokerId = BrokerId)
  output <- .mq$delete_broker_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$delete_broker <- mq_delete_broker

#' Removes a tag from a resource
#'
#' @description
#' Removes a tag from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_delete_tags/](https://www.paws-r-sdk.com/docs/mq_delete_tags/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource tag.
#' @param TagKeys &#91;required&#93; An array of tag keys to delete
#'
#' @keywords internal
#'
#' @rdname mq_delete_tags
mq_delete_tags <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "DeleteTags",
    http_method = "DELETE",
    http_path = "/v1/tags/{resource-arn}",
    paginator = list()
  )
  input <- .mq$delete_tags_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .mq$delete_tags_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$delete_tags <- mq_delete_tags

#' Deletes an ActiveMQ user
#'
#' @description
#' Deletes an ActiveMQ user.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_delete_user/](https://www.paws-r-sdk.com/docs/mq_delete_user/) for full documentation.
#'
#' @param BrokerId &#91;required&#93; The unique ID that Amazon MQ generates for the broker.
#' @param Username &#91;required&#93; The username of the ActiveMQ user. This value can contain only
#' alphanumeric characters, dashes, periods, underscores, and tildes (- .
#' _ ~). This value must be 2-100 characters long.
#'
#' @keywords internal
#'
#' @rdname mq_delete_user
mq_delete_user <- function(BrokerId, Username) {
  op <- new_operation(
    name = "DeleteUser",
    http_method = "DELETE",
    http_path = "/v1/brokers/{broker-id}/users/{username}",
    paginator = list()
  )
  input <- .mq$delete_user_input(BrokerId = BrokerId, Username = Username)
  output <- .mq$delete_user_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$delete_user <- mq_delete_user

#' Returns information about the specified broker
#'
#' @description
#' Returns information about the specified broker.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_describe_broker/](https://www.paws-r-sdk.com/docs/mq_describe_broker/) for full documentation.
#'
#' @param BrokerId &#91;required&#93; The unique ID that Amazon MQ generates for the broker.
#'
#' @keywords internal
#'
#' @rdname mq_describe_broker
mq_describe_broker <- function(BrokerId) {
  op <- new_operation(
    name = "DescribeBroker",
    http_method = "GET",
    http_path = "/v1/brokers/{broker-id}",
    paginator = list()
  )
  input <- .mq$describe_broker_input(BrokerId = BrokerId)
  output <- .mq$describe_broker_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$describe_broker <- mq_describe_broker

#' Describe available engine types and versions
#'
#' @description
#' Describe available engine types and versions.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_describe_broker_engine_types/](https://www.paws-r-sdk.com/docs/mq_describe_broker_engine_types/) for full documentation.
#'
#' @param EngineType Filter response by engine type.
#' @param MaxResults The maximum number of brokers that Amazon MQ can return per page (20 by
#' default). This value must be an integer from 5 to 100.
#' @param NextToken The token that specifies the next page of results Amazon MQ should
#' return. To request the first page, leave nextToken empty.
#'
#' @keywords internal
#'
#' @rdname mq_describe_broker_engine_types
mq_describe_broker_engine_types <- function(EngineType = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeBrokerEngineTypes",
    http_method = "GET",
    http_path = "/v1/broker-engine-types",
    paginator = list()
  )
  input <- .mq$describe_broker_engine_types_input(EngineType = EngineType, MaxResults = MaxResults, NextToken = NextToken)
  output <- .mq$describe_broker_engine_types_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$describe_broker_engine_types <- mq_describe_broker_engine_types

#' Describe available broker instance options
#'
#' @description
#' Describe available broker instance options.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_describe_broker_instance_options/](https://www.paws-r-sdk.com/docs/mq_describe_broker_instance_options/) for full documentation.
#'
#' @param EngineType Filter response by engine type.
#' @param HostInstanceType Filter response by host instance type.
#' @param MaxResults The maximum number of brokers that Amazon MQ can return per page (20 by
#' default). This value must be an integer from 5 to 100.
#' @param NextToken The token that specifies the next page of results Amazon MQ should
#' return. To request the first page, leave nextToken empty.
#' @param StorageType Filter response by storage type.
#'
#' @keywords internal
#'
#' @rdname mq_describe_broker_instance_options
mq_describe_broker_instance_options <- function(EngineType = NULL, HostInstanceType = NULL, MaxResults = NULL, NextToken = NULL, StorageType = NULL) {
  op <- new_operation(
    name = "DescribeBrokerInstanceOptions",
    http_method = "GET",
    http_path = "/v1/broker-instance-options",
    paginator = list()
  )
  input <- .mq$describe_broker_instance_options_input(EngineType = EngineType, HostInstanceType = HostInstanceType, MaxResults = MaxResults, NextToken = NextToken, StorageType = StorageType)
  output <- .mq$describe_broker_instance_options_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$describe_broker_instance_options <- mq_describe_broker_instance_options

#' Returns information about the specified configuration
#'
#' @description
#' Returns information about the specified configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_describe_configuration/](https://www.paws-r-sdk.com/docs/mq_describe_configuration/) for full documentation.
#'
#' @param ConfigurationId &#91;required&#93; The unique ID that Amazon MQ generates for the configuration.
#'
#' @keywords internal
#'
#' @rdname mq_describe_configuration
mq_describe_configuration <- function(ConfigurationId) {
  op <- new_operation(
    name = "DescribeConfiguration",
    http_method = "GET",
    http_path = "/v1/configurations/{configuration-id}",
    paginator = list()
  )
  input <- .mq$describe_configuration_input(ConfigurationId = ConfigurationId)
  output <- .mq$describe_configuration_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$describe_configuration <- mq_describe_configuration

#' Returns the specified configuration revision for the specified
#' configuration
#'
#' @description
#' Returns the specified configuration revision for the specified configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_describe_configuration_revision/](https://www.paws-r-sdk.com/docs/mq_describe_configuration_revision/) for full documentation.
#'
#' @param ConfigurationId &#91;required&#93; The unique ID that Amazon MQ generates for the configuration.
#' @param ConfigurationRevision &#91;required&#93; The revision of the configuration.
#'
#' @keywords internal
#'
#' @rdname mq_describe_configuration_revision
mq_describe_configuration_revision <- function(ConfigurationId, ConfigurationRevision) {
  op <- new_operation(
    name = "DescribeConfigurationRevision",
    http_method = "GET",
    http_path = "/v1/configurations/{configuration-id}/revisions/{configuration-revision}",
    paginator = list()
  )
  input <- .mq$describe_configuration_revision_input(ConfigurationId = ConfigurationId, ConfigurationRevision = ConfigurationRevision)
  output <- .mq$describe_configuration_revision_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$describe_configuration_revision <- mq_describe_configuration_revision

#' Returns information about an ActiveMQ user
#'
#' @description
#' Returns information about an ActiveMQ user.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_describe_user/](https://www.paws-r-sdk.com/docs/mq_describe_user/) for full documentation.
#'
#' @param BrokerId &#91;required&#93; The unique ID that Amazon MQ generates for the broker.
#' @param Username &#91;required&#93; The username of the ActiveMQ user. This value can contain only
#' alphanumeric characters, dashes, periods, underscores, and tildes (- .
#' _ ~). This value must be 2-100 characters long.
#'
#' @keywords internal
#'
#' @rdname mq_describe_user
mq_describe_user <- function(BrokerId, Username) {
  op <- new_operation(
    name = "DescribeUser",
    http_method = "GET",
    http_path = "/v1/brokers/{broker-id}/users/{username}",
    paginator = list()
  )
  input <- .mq$describe_user_input(BrokerId = BrokerId, Username = Username)
  output <- .mq$describe_user_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$describe_user <- mq_describe_user

#' Returns a list of all brokers
#'
#' @description
#' Returns a list of all brokers.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_list_brokers/](https://www.paws-r-sdk.com/docs/mq_list_brokers/) for full documentation.
#'
#' @param MaxResults The maximum number of brokers that Amazon MQ can return per page (20 by
#' default). This value must be an integer from 5 to 100.
#' @param NextToken The token that specifies the next page of results Amazon MQ should
#' return. To request the first page, leave nextToken empty.
#'
#' @keywords internal
#'
#' @rdname mq_list_brokers
mq_list_brokers <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListBrokers",
    http_method = "GET",
    http_path = "/v1/brokers",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "BrokerSummaries")
  )
  input <- .mq$list_brokers_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .mq$list_brokers_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$list_brokers <- mq_list_brokers

#' Returns a list of all revisions for the specified configuration
#'
#' @description
#' Returns a list of all revisions for the specified configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_list_configuration_revisions/](https://www.paws-r-sdk.com/docs/mq_list_configuration_revisions/) for full documentation.
#'
#' @param ConfigurationId &#91;required&#93; The unique ID that Amazon MQ generates for the configuration.
#' @param MaxResults The maximum number of brokers that Amazon MQ can return per page (20 by
#' default). This value must be an integer from 5 to 100.
#' @param NextToken The token that specifies the next page of results Amazon MQ should
#' return. To request the first page, leave nextToken empty.
#'
#' @keywords internal
#'
#' @rdname mq_list_configuration_revisions
mq_list_configuration_revisions <- function(ConfigurationId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListConfigurationRevisions",
    http_method = "GET",
    http_path = "/v1/configurations/{configuration-id}/revisions",
    paginator = list()
  )
  input <- .mq$list_configuration_revisions_input(ConfigurationId = ConfigurationId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .mq$list_configuration_revisions_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$list_configuration_revisions <- mq_list_configuration_revisions

#' Returns a list of all configurations
#'
#' @description
#' Returns a list of all configurations.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_list_configurations/](https://www.paws-r-sdk.com/docs/mq_list_configurations/) for full documentation.
#'
#' @param MaxResults The maximum number of brokers that Amazon MQ can return per page (20 by
#' default). This value must be an integer from 5 to 100.
#' @param NextToken The token that specifies the next page of results Amazon MQ should
#' return. To request the first page, leave nextToken empty.
#'
#' @keywords internal
#'
#' @rdname mq_list_configurations
mq_list_configurations <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListConfigurations",
    http_method = "GET",
    http_path = "/v1/configurations",
    paginator = list()
  )
  input <- .mq$list_configurations_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .mq$list_configurations_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$list_configurations <- mq_list_configurations

#' Lists tags for a resource
#'
#' @description
#' Lists tags for a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_list_tags/](https://www.paws-r-sdk.com/docs/mq_list_tags/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource tag.
#'
#' @keywords internal
#'
#' @rdname mq_list_tags
mq_list_tags <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTags",
    http_method = "GET",
    http_path = "/v1/tags/{resource-arn}",
    paginator = list()
  )
  input <- .mq$list_tags_input(ResourceArn = ResourceArn)
  output <- .mq$list_tags_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$list_tags <- mq_list_tags

#' Returns a list of all ActiveMQ users
#'
#' @description
#' Returns a list of all ActiveMQ users.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_list_users/](https://www.paws-r-sdk.com/docs/mq_list_users/) for full documentation.
#'
#' @param BrokerId &#91;required&#93; The unique ID that Amazon MQ generates for the broker.
#' @param MaxResults The maximum number of brokers that Amazon MQ can return per page (20 by
#' default). This value must be an integer from 5 to 100.
#' @param NextToken The token that specifies the next page of results Amazon MQ should
#' return. To request the first page, leave nextToken empty.
#'
#' @keywords internal
#'
#' @rdname mq_list_users
mq_list_users <- function(BrokerId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListUsers",
    http_method = "GET",
    http_path = "/v1/brokers/{broker-id}/users",
    paginator = list()
  )
  input <- .mq$list_users_input(BrokerId = BrokerId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .mq$list_users_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$list_users <- mq_list_users

#' Promotes a data replication replica broker to the primary broker role
#'
#' @description
#' Promotes a data replication replica broker to the primary broker role.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_promote/](https://www.paws-r-sdk.com/docs/mq_promote/) for full documentation.
#'
#' @param BrokerId &#91;required&#93; The unique ID that Amazon MQ generates for the broker.
#' @param Mode &#91;required&#93; The Promote mode requested. Note: Valid values for the parameter are
#' SWITCHOVER, FAILOVER.
#'
#' @keywords internal
#'
#' @rdname mq_promote
mq_promote <- function(BrokerId, Mode) {
  op <- new_operation(
    name = "Promote",
    http_method = "POST",
    http_path = "/v1/brokers/{broker-id}/promote",
    paginator = list()
  )
  input <- .mq$promote_input(BrokerId = BrokerId, Mode = Mode)
  output <- .mq$promote_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$promote <- mq_promote

#' Reboots a broker
#'
#' @description
#' Reboots a broker. Note: This API is asynchronous.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_reboot_broker/](https://www.paws-r-sdk.com/docs/mq_reboot_broker/) for full documentation.
#'
#' @param BrokerId &#91;required&#93; The unique ID that Amazon MQ generates for the broker.
#'
#' @keywords internal
#'
#' @rdname mq_reboot_broker
mq_reboot_broker <- function(BrokerId) {
  op <- new_operation(
    name = "RebootBroker",
    http_method = "POST",
    http_path = "/v1/brokers/{broker-id}/reboot",
    paginator = list()
  )
  input <- .mq$reboot_broker_input(BrokerId = BrokerId)
  output <- .mq$reboot_broker_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$reboot_broker <- mq_reboot_broker

#' Adds a pending configuration change to a broker
#'
#' @description
#' Adds a pending configuration change to a broker.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_update_broker/](https://www.paws-r-sdk.com/docs/mq_update_broker/) for full documentation.
#'
#' @param AuthenticationStrategy Optional. The authentication strategy used to secure the broker. The
#' default is SIMPLE.
#' @param AutoMinorVersionUpgrade Enables automatic upgrades to new minor versions for brokers, as new
#' versions are released and supported by Amazon MQ. Automatic upgrades
#' occur during the scheduled maintenance window of the broker or after a
#' manual broker reboot.
#' @param BrokerId &#91;required&#93; The unique ID that Amazon MQ generates for the broker.
#' @param Configuration A list of information about the configuration.
#' @param EngineVersion The broker engine version. For a list of supported engine versions, see
#' [Supported
#' engines](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/).
#' @param HostInstanceType The broker's host instance type to upgrade to. For a list of supported
#' instance types, see [Broker instance
#' types](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker.html#broker-instance-types).
#' @param LdapServerMetadata Optional. The metadata of the LDAP server used to authenticate and
#' authorize connections to the broker. Does not apply to RabbitMQ brokers.
#' @param Logs Enables Amazon CloudWatch logging for brokers.
#' @param MaintenanceWindowStartTime The parameters that determine the WeeklyStartTime.
#' @param SecurityGroups The list of security groups (1 minimum, 5 maximum) that authorizes
#' connections to brokers.
#' @param DataReplicationMode Defines whether this broker is a part of a data replication pair.
#'
#' @keywords internal
#'
#' @rdname mq_update_broker
mq_update_broker <- function(AuthenticationStrategy = NULL, AutoMinorVersionUpgrade = NULL, BrokerId, Configuration = NULL, EngineVersion = NULL, HostInstanceType = NULL, LdapServerMetadata = NULL, Logs = NULL, MaintenanceWindowStartTime = NULL, SecurityGroups = NULL, DataReplicationMode = NULL) {
  op <- new_operation(
    name = "UpdateBroker",
    http_method = "PUT",
    http_path = "/v1/brokers/{broker-id}",
    paginator = list()
  )
  input <- .mq$update_broker_input(AuthenticationStrategy = AuthenticationStrategy, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, BrokerId = BrokerId, Configuration = Configuration, EngineVersion = EngineVersion, HostInstanceType = HostInstanceType, LdapServerMetadata = LdapServerMetadata, Logs = Logs, MaintenanceWindowStartTime = MaintenanceWindowStartTime, SecurityGroups = SecurityGroups, DataReplicationMode = DataReplicationMode)
  output <- .mq$update_broker_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$update_broker <- mq_update_broker

#' Updates the specified configuration
#'
#' @description
#' Updates the specified configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_update_configuration/](https://www.paws-r-sdk.com/docs/mq_update_configuration/) for full documentation.
#'
#' @param ConfigurationId &#91;required&#93; The unique ID that Amazon MQ generates for the configuration.
#' @param Data &#91;required&#93; Amazon MQ for Active MQ: The base64-encoded XML configuration. Amazon MQ
#' for RabbitMQ: the base64-encoded Cuttlefish configuration.
#' @param Description The description of the configuration.
#'
#' @keywords internal
#'
#' @rdname mq_update_configuration
mq_update_configuration <- function(ConfigurationId, Data, Description = NULL) {
  op <- new_operation(
    name = "UpdateConfiguration",
    http_method = "PUT",
    http_path = "/v1/configurations/{configuration-id}",
    paginator = list()
  )
  input <- .mq$update_configuration_input(ConfigurationId = ConfigurationId, Data = Data, Description = Description)
  output <- .mq$update_configuration_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$update_configuration <- mq_update_configuration

#' Updates the information for an ActiveMQ user
#'
#' @description
#' Updates the information for an ActiveMQ user.
#'
#' See [https://www.paws-r-sdk.com/docs/mq_update_user/](https://www.paws-r-sdk.com/docs/mq_update_user/) for full documentation.
#'
#' @param BrokerId &#91;required&#93; The unique ID that Amazon MQ generates for the broker.
#' @param ConsoleAccess Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
#' @param Groups The list of groups (20 maximum) to which the ActiveMQ user belongs. This
#' value can contain only alphanumeric characters, dashes, periods,
#' underscores, and tildes (- . _ ~). This value must be 2-100 characters
#' long.
#' @param Password The password of the user. This value must be at least 12 characters
#' long, must contain at least 4 unique characters, and must not contain
#' commas, colons, or equal signs (,:=).
#' @param Username &#91;required&#93; The username of the ActiveMQ user. This value can contain only
#' alphanumeric characters, dashes, periods, underscores, and tildes (- .
#' _ ~). This value must be 2-100 characters long.
#' @param ReplicationUser Defines whether the user is intended for data replication.
#'
#' @keywords internal
#'
#' @rdname mq_update_user
mq_update_user <- function(BrokerId, ConsoleAccess = NULL, Groups = NULL, Password = NULL, Username, ReplicationUser = NULL) {
  op <- new_operation(
    name = "UpdateUser",
    http_method = "PUT",
    http_path = "/v1/brokers/{broker-id}/users/{username}",
    paginator = list()
  )
  input <- .mq$update_user_input(BrokerId = BrokerId, ConsoleAccess = ConsoleAccess, Groups = Groups, Password = Password, Username = Username, ReplicationUser = ReplicationUser)
  output <- .mq$update_user_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$update_user <- mq_update_user
