% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swf_operations.R
\name{swf_describe_workflow_type}
\alias{swf_describe_workflow_type}
\title{Returns information about the specified \emph{workflow type}}
\usage{
swf_describe_workflow_type(domain, workflowType)
}
\arguments{
\item{domain}{[required] The name of the domain in which this workflow type is registered.}

\item{workflowType}{[required] The workflow type to describe.}
}
\description{
Returns information about the specified \emph{workflow type}. This includes
configuration settings specified when the type was registered and other
information such as creation date, current status, etc.
}
\details{
\strong{Access Control}

You can use IAM policies to control this action's access to Amazon SWF
resources as follows:
\itemize{
\item Use a \code{Resource} element with the domain name to limit the action to
only specified domains.
\item Use an \code{Action} element to allow or deny permission to call this
action.
\item Constrain the following parameters by using a \code{Condition} element
with the appropriate keys.
\item \code{workflowType.name}: String constraint. The key is
\code{swf:workflowType.name}.
\item \code{workflowType.version}: String constraint. The key is
\code{swf:workflowType.version}.
}

If the caller doesn't have sufficient permissions to invoke the action,
or the parameter values fall outside the specified constraints, the
action fails. The associated event attribute's \code{cause} parameter is set
to \code{OPERATION_NOT_PERMITTED}. For details and example IAM policies, see
\href{http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html}{Using IAM to Manage Access to Amazon SWF Workflows}
in the \emph{Amazon SWF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_workflow_type(
  domain = "string",
  workflowType = list(
    name = "string",
    version = "string"
  )
)
}
}

\keyword{internal}
