% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opensearchservice_operations.R
\name{opensearchservice_create_application}
\alias{opensearchservice_create_application}
\title{Creates an OpenSearch Application}
\usage{
opensearchservice_create_application(
  clientToken = NULL,
  name,
  dataSources = NULL,
  iamIdentityCenterOptions = NULL,
  appConfigs = NULL,
  tagList = NULL
)
}
\arguments{
\item{clientToken}{A unique client idempotency token. It will be auto generated if not
provided.}

\item{name}{[required] Name of the OpenSearch Appication to create. Application names are
unique across the applications owned by an account within an Amazon Web
Services Region.}

\item{dataSources}{Data sources to be associated with the OpenSearch Application.}

\item{iamIdentityCenterOptions}{Settings of IAM Identity Center for the OpenSearch Application.}

\item{appConfigs}{Configurations of the OpenSearch Application, inlcuding admin
configuration.}

\item{tagList}{}
}
\description{
Creates an OpenSearch Application.

See \url{https://www.paws-r-sdk.com/docs/opensearchservice_create_application/} for full documentation.
}
\keyword{internal}
