% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_list_subscriptions}
\alias{datazone_list_subscriptions}
\title{Lists subscriptions in Amazon DataZone}
\usage{
datazone_list_subscriptions(
  approverProjectId = NULL,
  domainIdentifier,
  maxResults = NULL,
  nextToken = NULL,
  owningProjectId = NULL,
  sortBy = NULL,
  sortOrder = NULL,
  status = NULL,
  subscribedListingId = NULL,
  subscriptionRequestIdentifier = NULL
)
}
\arguments{
\item{approverProjectId}{The identifier of the project for the subscription's approver.}

\item{domainIdentifier}{[required] The identifier of the Amazon DataZone domain.}

\item{maxResults}{The maximum number of subscriptions to return in a single call to
\code{\link[=datazone_list_subscriptions]{list_subscriptions}}. When the number of
subscriptions to be listed is greater than the value of \code{MaxResults},
the response contains a \code{NextToken} value that you can use in a
subsequent call to \code{\link[=datazone_list_subscriptions]{list_subscriptions}}
to list the next set of Subscriptions.}

\item{nextToken}{When the number of subscriptions is greater than the default value for
the \code{MaxResults} parameter, or if you explicitly specify a value for
\code{MaxResults} that is less than the number of subscriptions, the response
includes a pagination token named \code{NextToken}. You can specify this
\code{NextToken} value in a subsequent call to
\code{\link[=datazone_list_subscriptions]{list_subscriptions}} to list the next set
of subscriptions.}

\item{owningProjectId}{The identifier of the owning project.}

\item{sortBy}{Specifies the way in which the results of this action are to be sorted.}

\item{sortOrder}{Specifies the sort order for the results of this action.}

\item{status}{The status of the subscriptions that you want to list.}

\item{subscribedListingId}{The identifier of the subscribed listing for the subscriptions that you
want to list.}

\item{subscriptionRequestIdentifier}{The identifier of the subscription request for the subscriptions that
you want to list.}
}
\description{
Lists subscriptions in Amazon DataZone.

See \url{https://www.paws-r-sdk.com/docs/datazone_list_subscriptions/} for full documentation.
}
\keyword{internal}
