% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_list_calculation_executions}
\alias{athena_list_calculation_executions}
\title{Lists the calculations that have been submitted to a session in
descending order}
\usage{
athena_list_calculation_executions(
  SessionId,
  StateFilter = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{SessionId}{[required] The session ID.}

\item{StateFilter}{A filter for a specific calculation execution state. A description of
each state follows.

\code{CREATING} - The calculation is in the process of being created.

\code{CREATED} - The calculation has been created and is ready to run.

\code{QUEUED} - The calculation has been queued for processing.

\code{RUNNING} - The calculation is running.

\code{CANCELING} - A request to cancel the calculation has been received and
the system is working to stop it.

\code{CANCELED} - The calculation is no longer running as the result of a
cancel request.

\code{COMPLETED} - The calculation has completed without error.

\code{FAILED} - The calculation failed and is no longer running.}

\item{MaxResults}{The maximum number of calculation executions to return.}

\item{NextToken}{A token generated by the Athena service that specifies where to continue
pagination if a previous request was truncated. To obtain the next set
of pages, pass in the \code{NextToken} from the response object of the
previous page call.}
}
\description{
Lists the calculations that have been submitted to a session in descending order. Newer calculations are listed first; older calculations are listed later.

See \url{https://www.paws-r-sdk.com/docs/athena_list_calculation_executions/} for full documentation.
}
\keyword{internal}
