% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_search_types}
\alias{datazone_search_types}
\title{Searches for types in Amazon DataZone}
\usage{
datazone_search_types(
  domainIdentifier,
  filters = NULL,
  managed,
  maxResults = NULL,
  nextToken = NULL,
  searchIn = NULL,
  searchScope,
  searchText = NULL,
  sort = NULL
)
}
\arguments{
\item{domainIdentifier}{[required] The identifier of the Amazon DataZone domain in which to invoke the
\code{\link[=datazone_search_types]{search_types}} action.}

\item{filters}{The filters for the \code{\link[=datazone_search_types]{search_types}} action.}

\item{managed}{[required]}

\item{maxResults}{The maximum number of results to return in a single call to
\code{\link[=datazone_search_types]{search_types}}. When the number of results to
be listed is greater than the value of \code{MaxResults}, the response
contains a \code{NextToken} value that you can use in a subsequent call to
\code{\link[=datazone_search_types]{search_types}} to list the next set of results.}

\item{nextToken}{When the number of results is greater than the default value for the
\code{MaxResults} parameter, or if you explicitly specify a value for
\code{MaxResults} that is less than the number of results, the response
includes a pagination token named \code{NextToken}. You can specify this
\code{NextToken} value in a subsequent call to
\code{\link[=datazone_search_types]{search_types}} to list the next set of results.}

\item{searchIn}{}

\item{searchScope}{[required] Specifies the scope of the search for types.}

\item{searchText}{Specifies the text for which to search.}

\item{sort}{The specifies the way to sort the
\code{\link[=datazone_search_types]{search_types}} results.}
}
\description{
Searches for types in Amazon DataZone.

See \url{https://www.paws-r-sdk.com/docs/datazone_search_types/} for full documentation.
}
\keyword{internal}
