% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_operations.R
\name{kinesis_list_shards}
\alias{kinesis_list_shards}
\title{Lists the shards in a stream and provides information about each shard}
\usage{
kinesis_list_shards(StreamName, NextToken, ExclusiveStartShardId,
  MaxResults, StreamCreationTimestamp)
}
\arguments{
\item{StreamName}{The name of the data stream whose shards you want to list.

You cannot specify this parameter if you specify the \code{NextToken}
parameter.}

\item{NextToken}{When the number of shards in the data stream is greater than the default
value for the \code{MaxResults} parameter, or if you explicitly specify a
value for \code{MaxResults} that is less than the number of shards in the
data stream, the response includes a pagination token named \code{NextToken}.
You can specify this \code{NextToken} value in a subsequent call to
\code{ListShards} to list the next set of shards.

Don\'t specify \code{StreamName} or \code{StreamCreationTimestamp} if you specify
\code{NextToken} because the latter unambiguously identifies the stream.

You can optionally specify a value for the \code{MaxResults} parameter when
you specify \code{NextToken}. If you specify a \code{MaxResults} value that is
less than the number of shards that the operation returns if you don\'t
specify \code{MaxResults}, the response will contain a new \code{NextToken} value.
You can use the new \code{NextToken} value in a subsequent call to the
\code{ListShards} operation.

Tokens expire after 300 seconds. When you obtain a value for \code{NextToken}
in the response to a call to \code{ListShards}, you have 300 seconds to use
that value. If you specify an expired token in a call to \code{ListShards},
you get \code{ExpiredNextTokenException}.}

\item{ExclusiveStartShardId}{Specify this parameter to indicate that you want to list the shards
starting with the shard whose ID immediately follows
\code{ExclusiveStartShardId}.

If you don\'t specify this parameter, the default behavior is for
\code{ListShards} to list the shards starting with the first one in the
stream.

You cannot specify this parameter if you specify \code{NextToken}.}

\item{MaxResults}{The maximum number of shards to return in a single call to \code{ListShards}.
The minimum value you can specify for this parameter is 1, and the
maximum is 1,000, which is also the default.

When the number of shards to be listed is greater than the value of
\code{MaxResults}, the response contains a \code{NextToken} value that you can use
in a subsequent call to \code{ListShards} to list the next set of shards.}

\item{StreamCreationTimestamp}{Specify this input parameter to distinguish data streams that have the
same name. For example, if you create a data stream and then delete it,
and you later create another data stream with the same name, you can use
this input parameter to specify which of the two streams you want to
list the shards for.

You cannot specify this parameter if you specify the \code{NextToken}
parameter.}
}
\description{
Lists the shards in a stream and provides information about each shard.
This operation has a limit of 100 transactions per second per data
stream.
}
\details{
This API is a new operation that is used by the Amazon Kinesis Client
Library (KCL). If you have a fine-grained IAM policy that only allows
specific operations, you must update your policy to allow calls to this
API. For more information, see \href{https://docs.aws.amazon.com/streams/latest/dev/controlling-access.html}{Controlling Access to Amazon Kinesis Data Streams Resources Using IAM}.
}
\section{Request syntax}{
\preformatted{svc$list_shards(
  StreamName = "string",
  NextToken = "string",
  ExclusiveStartShardId = "string",
  MaxResults = 123,
  StreamCreationTimestamp = as.POSIXct(
    "2015-01-01"
  )
)
}
}

\keyword{internal}
