% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_create_script}
\alias{glue_create_script}
\title{Transforms a directed acyclic graph (DAG) into code}
\usage{
glue_create_script(DagNodes, DagEdges, Language)
}
\arguments{
\item{DagNodes}{A list of the nodes in the DAG.}

\item{DagEdges}{A list of the edges in the DAG.}

\item{Language}{The programming language of the resulting code from the DAG.}
}
\description{
Transforms a directed acyclic graph (DAG) into code.
}
\section{Request syntax}{
\preformatted{svc$create_script(
  DagNodes = list(
    list(
      Id = "string",
      NodeType = "string",
      Args = list(
        list(
          Name = "string",
          Value = "string",
          Param = TRUE|FALSE
        )
      ),
      LineNumber = 123
    )
  ),
  DagEdges = list(
    list(
      Source = "string",
      Target = "string",
      TargetParameter = "string"
    )
  ),
  Language = "PYTHON"|"SCALA"
)
}
}

\keyword{internal}
