% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_batch_get_crawlers}
\alias{glue_batch_get_crawlers}
\title{Returns a list of resource metadata for a given list of crawler names}
\usage{
glue_batch_get_crawlers(CrawlerNames)
}
\arguments{
\item{CrawlerNames}{[required] A list of crawler names, which might be the names returned from the
\code{\link[=glue_list_crawlers]{list_crawlers}} operation.}
}
\value{
A list with the following syntax:\preformatted{list(
  Crawlers = list(
    list(
      Name = "string",
      Role = "string",
      Targets = list(
        S3Targets = list(
          list(
            Path = "string",
            Exclusions = list(
              "string"
            ),
            ConnectionName = "string"
          )
        ),
        JdbcTargets = list(
          list(
            ConnectionName = "string",
            Path = "string",
            Exclusions = list(
              "string"
            )
          )
        ),
        MongoDBTargets = list(
          list(
            ConnectionName = "string",
            Path = "string",
            ScanAll = TRUE|FALSE
          )
        ),
        DynamoDBTargets = list(
          list(
            Path = "string",
            scanAll = TRUE|FALSE,
            scanRate = 123.0
          )
        ),
        CatalogTargets = list(
          list(
            DatabaseName = "string",
            Tables = list(
              "string"
            )
          )
        )
      ),
      DatabaseName = "string",
      Description = "string",
      Classifiers = list(
        "string"
      ),
      RecrawlPolicy = list(
        RecrawlBehavior = "CRAWL_EVERYTHING"|"CRAWL_NEW_FOLDERS_ONLY"
      ),
      SchemaChangePolicy = list(
        UpdateBehavior = "LOG"|"UPDATE_IN_DATABASE",
        DeleteBehavior = "LOG"|"DELETE_FROM_DATABASE"|"DEPRECATE_IN_DATABASE"
      ),
      LineageConfiguration = list(
        CrawlerLineageSettings = "ENABLE"|"DISABLE"
      ),
      State = "READY"|"RUNNING"|"STOPPING",
      TablePrefix = "string",
      Schedule = list(
        ScheduleExpression = "string",
        State = "SCHEDULED"|"NOT_SCHEDULED"|"TRANSITIONING"
      ),
      CrawlElapsedTime = 123,
      CreationTime = as.POSIXct(
        "2015-01-01"
      ),
      LastUpdated = as.POSIXct(
        "2015-01-01"
      ),
      LastCrawl = list(
        Status = "SUCCEEDED"|"CANCELLED"|"FAILED",
        ErrorMessage = "string",
        LogGroup = "string",
        LogStream = "string",
        MessagePrefix = "string",
        StartTime = as.POSIXct(
          "2015-01-01"
        )
      ),
      Version = 123,
      Configuration = "string",
      CrawlerSecurityConfiguration = "string"
    )
  ),
  CrawlersNotFound = list(
    "string"
  )
)
}
}
\description{
Returns a list of resource metadata for a given list of crawler names.
After calling the \code{\link[=glue_list_crawlers]{list_crawlers}} operation, you
can call this operation to access the data to which you have been
granted permissions. This operation supports all IAM permissions,
including permission conditions that uses tags.
}
\section{Request syntax}{
\preformatted{svc$batch_get_crawlers(
  CrawlerNames = list(
    "string"
  )
)
}
}

\keyword{internal}
