% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_list_named_queries}
\alias{athena_list_named_queries}
\title{Provides a list of available query IDs only for queries saved in the
specified workgroup}
\usage{
athena_list_named_queries(NextToken, MaxResults, WorkGroup)
}
\arguments{
\item{NextToken}{A token generated by the Athena service that specifies where to continue
pagination if a previous request was truncated. To obtain the next set
of pages, pass in the \code{NextToken} from the response object of the
previous page call.}

\item{MaxResults}{The maximum number of queries to return in this request.}

\item{WorkGroup}{The name of the workgroup from which the named queries are being
returned. If a workgroup is not specified, the saved queries for the
primary workgroup are returned.}
}
\value{
A list with the following syntax:\preformatted{list(
  NamedQueryIds = list(
    "string"
  ),
  NextToken = "string"
)
}
}
\description{
Provides a list of available query IDs only for queries saved in the
specified workgroup. Requires that you have access to the specified
workgroup. If a workgroup is not specified, lists the saved queries for
the primary workgroup.

For code samples using the AWS SDK for Java, see \href{https://docs.aws.amazon.com/athena/latest/ug/code-samples.html}{Examples and Code Samples}
in the \emph{Amazon Athena User Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_named_queries(
  NextToken = "string",
  MaxResults = 123,
  WorkGroup = "string"
)
}
}

\keyword{internal}
