% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getspec.R
\name{getspec}
\alias{getspec}
\title{Import spectra files}
\usage{
getspec(
  where = getwd(),
  ext = "txt",
  lim = c(300, 700),
  decimal = ".",
  sep = NULL,
  subdir = FALSE,
  subdir.names = FALSE,
  ignore.case = TRUE
)
}
\arguments{
\item{where}{Folder in which files are located (defaults to current working
directory).}

\item{ext}{File extension to be searched for, without the "." (defaults to
\code{txt}). You can also use a character vector to specify multiple file
extensions.}

\item{lim}{A vector with two numbers determining the wavelength limits to be
considered (defaults to \code{c(300, 700)}).}

\item{decimal}{Character to be used to identify decimal plates
(defaults to \code{.}).}

\item{sep}{Column delimiting characters to be considered in addition to the
default (which are: tab, space, and ";")}

\item{subdir}{Should subdirectories within the \code{where} folder be included in
the search? (defaults to \code{FALSE}).}

\item{subdir.names}{Should subdirectory path be included in the name of the
spectra? (defaults to \code{FALSE}).}

\item{ignore.case}{Should the extension search be case insensitive? (defaults
to \code{TRUE})}
}
\value{
A data frame, of class \code{rspec}, containing individual imported
spectral files as columns.
Reflectance values are interpolated to the nearest wavelength integer.
}
\description{
Finds and imports spectra files from a folder. Currently works
for reflectance files generated in Ocean Optics SpectraSuite (USB2000,
USB4000 and Jaz spectrometers), CRAIC software (after exporting) and
Avantes (before or after exporting).
}
\details{
You can customise the type of parallel processing used by this function with
the \code{\link[future:plan]{future::plan()}} function. This works on all operating systems, as well
as high performance computing (HPC) environment. Similarly, you can customise
the way progress is shown with the \code{\link[progressr:handlers]{progressr::handlers()}} functions
(progress bar, acoustic feedback, nothing, etc.)
}
\examples{
# Import and inspect example spectral data with a range of set to 400-700nm.
rspecdata <- getspec(system.file("testdata", package = "lightr"), ext = "ttt", lim = c(400, 700))
head(rspecdata)

}
\references{
Gruson H, White TE, Maia R (2019) lightr: import spectral data
and metadata in R. Journal of Open Source Software, 4(43), 1857,
\doi{doi:10.21105/joss.01857}.
}
\seealso{
\code{\link[lightr:lr_get_spec]{lightr::lr_get_spec()}} for a more flexible version of this function
(e.g. uninterpolated wavelengths), and \code{\link[lightr:lr_get_metadata]{lightr::lr_get_metadata()}} for the retrieval
and import of spectral metadata.
See \url{https://docs.ropensci.org/lightr/} for the complete, and up-to-date, list
of supported file formats.
}
\author{
Rafael Maia \email{rm72@zips.uakron.edu}

Hugo Gruson \email{hugo.gruson+R@normalesup.org}
}
