% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patRegRGB.R
\name{patRegRGB}
\alias{patRegRGB}
\title{Aligns images using \code{\link[RNiftyReg]{niftyreg}} utilities for automated image registration
and extracts colors using a predefined RGB values and cutoff value.}
\usage{
patRegRGB(sampleList, target, RGB, resampleFactor = NULL,
  useBlockPercentage = 75, colOffset = 0.1, crop = c(0, 0, 0, 0),
  removebgR = NULL, maskOutline = NULL, plot = FALSE,
  focal = FALSE, sigma = 3, iterations = 0)
}
\arguments{
\item{sampleList}{List of RasterStack objects.}

\item{target}{Image imported as RasterStack used as target for registration.}

\item{RGB}{Values for color pattern extraction specified as RGB vector.}

\item{resampleFactor}{Integer for downsampling used by \code{\link{redRes}} (default = NULL).}

\item{useBlockPercentage}{Block percentage as used in \code{\link[RNiftyReg]{niftyreg}}
(default = 75).}

\item{colOffset}{Color offset for color pattern extraction (default = 0.10).}

\item{crop}{Vector c(xmin, xmax, ymin, ymax) that specifies the pixel coordinates to crop the
original image.}

\item{removebgR}{Integer indicating the range RGB treshold to remove from image (e.g. 100 removes
pixels with average RGB > 100; default = NULL) for registration analysis. This works only to
remove a white background.}

\item{maskOutline}{When outline is specified, everything outside of the outline will be masked for
the color extraction (default = NULL).}

\item{plot}{Whether to plot transformed color patterns while processing (default = FALSE).
Transformed color patterns can be plot on top of each other ('stack') or next to the
original image for each sample ('compare').}

\item{focal}{Whether to perform Gaussian blurring (default = FALSE).}

\item{sigma}{Size of sigma for Gaussian blurring (default = 3).}

\item{iterations}{Number of iterations for recalculating average color (default = 0). If set, the
RGB value for pattern extraction will be iteratively recalculated to be the average of the
extracted area. This may improve extraction of distinct color pattern, but fail for more
gradually distributed (in color space) patterns.}
}
\value{
List of raster objects.
}
\description{
Aligns images using \code{\link[RNiftyReg]{niftyreg}} utilities for automated image registration
and extracts colors using a predefined RGB values and cutoff value.
}
\examples{
IDlist <- c('BC0077','BC0071','BC0050','BC0049','BC0004')
prepath <- system.file("extdata",  package = 'patternize')
extension <- '.jpg'

imageList <- makeList(IDlist, 'image', prepath, extension)

target <- imageList[[1]]

RGB <- c(114,17,0)

# Note that this example only aligns one image with the target,
# remove [2] to run a full examples.
rasterList_regRGB <- patRegRGB(imageList[2], target, RGB,
colOffset= 0.15, crop = c(100,400,40,250), removebgR = 100, plot = 'stack')

}
