% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_functions.R
\name{clean_viewr_batch}
\alias{clean_viewr_batch}
\title{Batch clean viewr files}
\usage{
clean_viewr_batch(obj_list, file_announce = FALSE, ...)
}
\arguments{
\item{obj_list}{A list of viewr objects (i.e. a list of tibbles that each
have attribute \code{pathviewr_steps} that includes \code{"viewr"})}

\item{file_announce}{Should the function report each time a file is
processed? Default FALSE; if TRUE, a message will appear in the console
each time a file has been cleaned successfully.}

\item{...}{Arguments to be passed in that specify how this function should
clean files.}
}
\value{
A list of viewr objects (tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}) that have been passed
through the corresponding cleaning functions.
}
\description{
For a list of viewr objects, run through the pipeline (from relabel axes
up through get full trajectories, as desired) via clean_viewr()
}
\details{
viewr objects should be in a list, e.g. the object generated by
\code{import_batch()}.

See \code{clean_viewr()} for details of how cleaning steps are handled
and/or refer to the corresponding cleaning functions themselves.
}
\examples{
## Since we only have one example file of each type provided
## in pathviewr, we will simply import the same example multiple
## times to simulate batch importing. Replace the contents of
## the following list with your own list of files to be imported.

## Make a list of the same example file 3x
import_list <-
  c(rep(
    system.file("extdata", "pathviewr_motive_example_data.csv",
                package = 'pathviewr'),
    3
  ))

## Batch import
motive_batch_imports <-
  import_batch(import_list,
               import_method = "motive",
               import_messaging = TRUE)

## Batch cleaning of these imported files
## via clean_viewr_batch()
motive_batch_cleaned <-
  clean_viewr_batch(
    file_announce = TRUE,
    motive_batch_imports,
    desired_percent = 50,
    max_frame_gap = "autodetect",
    span = 0.95
  )

## Alternatively, use import_and_clean_batch() to
## combine import with cleaning on a batch of files
motive_batch_import_and_clean <-
  import_and_clean_batch(
    import_list,
    import_method = "motive",
    import_messaging = TRUE,
    motive_batch_imports,
    desired_percent = 50,
    max_frame_gap = "autodetect",
    span = 0.95
  )

## Each of these lists of objects can be bound into
## one viewr object (i.e. one tibble) via
## bind_viewr_objects()
motive_bound_one <-
  bind_viewr_objects(motive_batch_cleaned)

motive_bound_two <-
  bind_viewr_objects(motive_batch_import_and_clean)

## Either route results in the same object ultimately:
identical(motive_bound_one, motive_bound_two)
}
\seealso{
Other batch functions: 
\code{\link{bind_viewr_objects}()},
\code{\link{import_and_clean_batch}()},
\code{\link{import_batch}()}
}
\author{
Vikram B. Baliga
}
\concept{batch functions}
