% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_region_slice.R
\name{sample_region_slice}
\alias{sample_region_slice}
\title{Sample points from a region time slice}
\usage{
sample_region_slice(x, size, method = "random", replace = FALSE, na.rm = TRUE)
}
\arguments{
\item{x}{a \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} returned
by \code{\link[=region_slice]{region_slice()}}}

\item{size}{number of points sampled.}

\item{method}{one of the sampling methods from \code{\link[terra:sample]{terra::spatSample()}}. It
defaults to "random"}

\item{replace}{boolean determining whether we sample with replacement}

\item{na.rm}{boolean determining whether NAs are removed}
}
\value{
a data.frame with the sampled cells and their respective values for
the climate variables.
}
\description{
This function samples points from a region time slice (i.e. a time point).
}
\details{
This function wraps \code{\link[terra:sample]{terra::spatSample()}} to appropriate sample the
\code{\link[terra:SpatRaster-class]{terra::SpatRaster}} returned
by \code{\link[=region_slice]{region_slice()}}. You can also use \code{\link[terra:sample]{terra::spatSample()}} directly
on a slice (which is a standard \code{\link[terra:SpatRaster-class]{terra::SpatRaster}}).
}
