% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_labels.R
\name{var_labels}
\alias{var_labels}
\title{Generate pretty variable labels for plotting}
\usage{
var_labels(x, dataset, with_units = TRUE, abbreviated = FALSE)
}
\arguments{
\item{x}{either a character vector with the names of the variables, or a 
\code{SpatRaster} generated with \code{region_slice}}

\item{dataset}{string defining dataset to be downloaded (a list of possible
values can be obtained with \code{get_available_datasets}). This function
will not work on custom datasets.}

\item{with_units}{boolean defining whether the label should include units}

\item{abbreviated}{boolean defining whether the label should use abbreviations
for the variable}
}
\value{
a \code{expression} that can be used as a label in plots
}
\description{
Generate pretty labels (in the form of an \code{expression}) that can be used
for plotting
}
\examples{
var_labels("bio01", dataset = "Example")

# set the data_path for this example to run on CRAN
# users don't need to run this line
set_data_path_for_CRAN()

# for a SpatRaster
climate_20k <- region_slice(
time_bp = -20000,
bio_variables = c("bio01", "bio10", "bio12"),
dataset = "Example"
)
terra::plot(climate_20k, main = var_labels(climate_20k, dataset = "Example"))
terra::plot(climate_20k, main = var_labels(climate_20k, dataset = "Example",
                   abbreviated = TRUE))
}
