% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_reg_stan_glmer.R
\name{details_linear_reg_stan_glmer}
\alias{details_linear_reg_stan_glmer}
\title{Linear regression via hierarchical Bayesian methods}
\description{
The \code{"stan_glmer"} engine estimates hierarchical regression parameters using
Bayesian estimation.
}
\details{
For this engine, there is a single mode: regression
\subsection{Tuning Parameters}{

This model has no tuning parameters.
}

\subsection{Important engine-specific options}{

Some relevant arguments that can be passed to \code{set_engine()}:
\itemize{
\item \code{chains}: A positive integer specifying the number of Markov chains.
The default is 4.
\item \code{iter}: A positive integer specifying the number of iterations for
each chain (including warmup). The default is 2000.
\item \code{seed}: The seed for random number generation.
\item \code{cores}: Number of cores to use when executing the chains in
parallel.
\item \code{prior}: The prior distribution for the (non-hierarchical)
regression coefficients.
\item \code{prior_intercept}: The prior distribution for the intercept (after
centering all predictors).
}

See \code{?rstanarm::stan_glmer} and \code{?rstan::sampling} for more information.
}

\subsection{Translation from parsnip to the original package}{

The \strong{multilevelmod} extension package is required to fit this model.\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(multilevelmod)

linear_reg() \%>\% 
  set_engine("stan_glmer") \%>\% 
  set_mode("regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Linear Regression Model Specification (regression)
## 
## Computational engine: stan_glmer 
## 
## Model fit template:
## rstanarm::stan_glmer(formula = missing_arg(), data = missing_arg(), 
##     weights = missing_arg(), family = stats::gaussian, refresh = 0)
}
}

\subsection{Predicting new samples}{

This model can use subject-specific coefficient estimates to make
predictions (i.e. partial pooling). For example, this equation shows the
linear predictor (\emph{η}) for a random intercept:

\emph{η}\if{html}{\out{<sub>}}\emph{i}\if{html}{\out{</sub>}} = (\emph{β}\if{html}{\out{<sub>}}0\if{html}{\out{</sub>}}+\emph{b}\if{html}{\out{<sub>}}0\emph{i}\if{html}{\out{</sub>}}) + \emph{β}\if{html}{\out{<sub>}}1\if{html}{\out{</sub>}}\emph{x}\if{html}{\out{<sub>}}\emph{i}1\if{html}{\out{</sub>}}

where \emph{i} denotes the \code{i}th independent experimental unit
(e.g. subject). When the model has seen subject \code{i}, it can use that
subject’s data to adjust the \emph{population} intercept to be more specific
to that subjects results.

What happens when data are being predicted for a subject that was not
used in the model fit? In that case, this package uses \emph{only} the
population parameter estimates for prediction:

\emph{η̂}\if{html}{\out{<sub>}}\emph{i}′\if{html}{\out{</sub>}} = \emph{β̂}\if{html}{\out{<sub>}}0\if{html}{\out{</sub>}} + \emph{β̂**x}\if{html}{\out{<sub>}}\emph{i}′1\if{html}{\out{</sub>}}

Depending on what covariates are in the model, this might have the
effect of making the same prediction for all new samples. The population
parameters are the “best estimate” for a subject that was not included
in the model fit.

The tidymodels framework deliberately constrains predictions for new
data to not use the training set or other data (to prevent information
leakage).
}

\subsection{Preprocessing requirements}{

There are no specific preprocessing needs. However, it is helpful to
keep the clustering/subject identifier column as factor or character
(instead of making them into dummy variables). See the examples in the
next section.
}

\subsection{Other details}{

The model can accept case weights.

With parsnip, we suggest using the formula method when fitting:\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(tidymodels)
data("riesby")

linear_reg() \%>\% 
  set_engine("stan_glmer") \%>\% 
  fit(depr_score ~ week + (1|subject), data = riesby)
}\if{html}{\out{</div>}}

When using tidymodels infrastructure, it may be better to use a
workflow. In this case, you can add the appropriate columns using
\code{add_variables()} then supply the typical formula when adding the model:\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(tidymodels)

glmer_spec <- 
  linear_reg() \%>\% 
  set_engine("stan_glmer")

glmer_wflow <- 
  workflow() \%>\% 
  # The data are included as-is using:
  add_variables(outcomes = depr_score, predictors = c(week, subject)) \%>\% 
  add_model(glmer_spec, formula = depr_score ~ week + (1|subject))

fit(glmer_wflow, data = riesby)
}\if{html}{\out{</div>}}

For prediction, the \code{"stan_glmer"} engine can compute posterior
intervals analogous to confidence and prediction intervals. In these
instances, the units are the original outcome. When \code{std_error = TRUE},
the standard deviation of the posterior distribution (or posterior
predictive distribution as appropriate) is returned.
}

\subsection{References}{
\itemize{
\item McElreath, R. 2020 \emph{Statistical Rethinking}. CRC Press.
\item Sorensen, T, Vasishth, S. 2016. Bayesian linear mixed models using
Stan: A tutorial for psychologists, linguists, and cognitive
scientists, arXiv:1506.06201.
}
}
}
\keyword{internal}
