% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_models.R
\name{doc-tools}
\alias{doc-tools}
\alias{find_engine_files}
\alias{make_engine_list}
\alias{make_seealso_list}
\title{Tools for dynamically documenting packages}
\usage{
find_engine_files(mod, pkg = "parsnip")

make_engine_list(mod, pkg = "parsnip")

make_seealso_list(mod, pkg = "parsnip")
}
\arguments{
\item{mod}{A character string for the model file (e.g. "linear_reg")}

\item{pkg}{A character string for the package where the function is invoked.}
}
\value{
\code{make_engine_list()} returns a character string that creates a
bulleted list of links to more specific help files.

\code{make_seealso_list()} returns a formatted character string of links.

\code{find_engine_files()} returns a tibble.
}
\description{
These are functions used to create dynamic documentation in Rd files
based on which parsnip-related packages are loaded by the user.

These functions can be used to make dynamic lists of documentation help
files. \pkg{parsnip} uses these, along with files contained in \code{man/rmd}
containing expanded documentation, for specific model/engine combinations.
\code{\link[=find_engine_files]{find_engine_files()}} looks for files that have the pattern
\verb{details_\{model\}_\{engine\}.Rd} to link to. These files are generated by files
named \verb{man/rmd/details_\{model\}_\{engine\}.Rmd}. \code{make_engine_list()} creates a
list seen at the top of the model Rd files while \code{make_seealso_list()}
populates the list seen in "See Also" below. See the details section.
}
\details{
The \pkg{parsnip} documentation is generated \emph{dynamically}. Part of the Rd
file populates a list of engines that depends on what packages are loaded
\emph{at the time that the man file is loaded}. For example, if
another package has a new engine for \code{linear_reg()}, the
\code{parsnip::linear_reg()} help can show a link to a detailed help page in the
other package.

To enable this, the process for a package developer is to:
\enumerate{
\item Create an engine-specific R file in the \code{R} directory with the name
\verb{\{model\}_\{engine\}.R} (e.g. \code{boost_tree_C5.0.R}). This has a small amount of
documentation, as well as the directive
"\verb{@includeRmd man/rmd/\{model\}_\{engine\}.Rmd details}".
\item Copy the file in \pkg{parsnip} that is in \code{man/rmd/setup.Rmd} and put
it in the same place in your package.
\item Write your own \verb{man/rmd/\{model\}_\{engine\}.Rmd} file. This can include
packages that are not listed in the DESCRIPTION file. Those are only
required when the documentation file is created locally (probably using
\code{\link[devtools:document]{devtools::document()}}.
\item Run \code{\link[devtools:document]{devtools::document()}} so that the Rmd content is included in the
Rd file.
}

The examples in \pkg{parsnip} can provide guidance for how to organize
technical information about the models.
}
\examples{
find_engine_files("linear_reg")
cat(make_engine_list("linear_reg"))
}
\keyword{internal}
