% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptors.R
\name{descriptors}
\alias{descriptors}
\alias{.obs}
\alias{.cols}
\alias{.preds}
\alias{.facts}
\alias{.lvls}
\alias{.x}
\alias{.y}
\alias{.dat}
\title{Data Set Characteristics Available when Fitting Models}
\usage{
.cols()

.preds()

.obs()

.lvls()

.facts()

.x()

.y()

.dat()
}
\description{
When using the \code{fit()} functions there are some
variables that will be available for use in arguments. For
example, if the user would like to choose an argument value
based on the current number of rows in a data set, the \code{.obs()}
function can be used. See Details below.
}
\details{
Existing functions:
\itemize{
\item \code{.obs()}: The current number of rows in the data set.
\item \code{.preds()}: The number of columns in the data set that are
associated with the predictors prior to dummy variable creation.
\item \code{.cols()}: The number of predictor columns availible after dummy
variables are created (if any).
\item \code{.facts()}: The number of factor predictors in the dat set.
\item \code{.lvls()}: If the outcome is a factor, this is a table
with the counts for each level (and \code{NA} otherwise).
\item \code{.x()}: The predictors returned in the format given. Either a
data frame or a matrix.
\item \code{.y()}: The known outcomes returned in the format given. Either
a vector, matrix, or data frame.
\item \code{.dat()}: A data frame containing all of the predictors and the
outcomes. If \code{fit_xy()} was used, the outcomes are attached as the
column, \code{..y}.
}

For example, if you use the model formula \code{Sepal.Width ~ .} with the \code{iris}
data, the values would be
\preformatted{
 .preds() =   4          (the 4 columns in `iris`)
 .cols()  =   5          (3 numeric columns + 2 from Species dummy variables)
 .obs()   = 150
 .lvls()  =  NA          (no factor outcome)
 .facts() =   1          (the Species predictor)
 .y()     = <vector>     (Sepal.Width as a vector)
 .x()     = <data.frame> (The other 4 columns as a data frame)
 .dat()   = <data.frame> (The full data set)
}

If the formula \code{Species ~ .} where used:
\preformatted{
 .preds() =   4          (the 4 numeric columns in `iris`)
 .cols()  =   4          (same)
 .obs()   = 150
 .lvls()  =  c(setosa = 50, versicolor = 50, virginica = 50)
 .facts() =   0
 .y()     = <vector>     (Species as a vector)
 .x()     = <data.frame> (The other 4 columns as a data frame)
 .dat()   = <data.frame> (The full data set)
}

To use these in a model fit, pass them to a model specification.
The evaluation is delayed until the time when the
model is run via \code{fit()} (and the variables listed above are available).
For example:

\preformatted{

data("lending_club")

rand_forest(mode = "classification", mtry = .cols() - 2)
}

When no descriptors are found, the computation of the descriptor values
is not executed.
}
