% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_med.R
\encoding{UTF-8}
\name{convert_med}
\alias{convert_med}
\title{Adds boolean columns corresponding to a group of medications whether it is present in the given row.}
\usage{
convert_med(
  d,
  code = "med",
  codes_to_find = NULL,
  collapse = NULL,
  code_time = "time_med",
  time_type = "earliest",
  nThread = 4
)
}
\arguments{
\item{d}{data.table, database containing medication data loaded using the \emph{load_med} function.}

\item{code}{string, column name of the medication column. Defaults to \emph{med}.}

\item{codes_to_find}{list, a list of arrays corresponding to sets of medication names. New boolean columns with the name of each list element will be created.
These columns are indicators whether the given medication is present in the set of medication names or not.}

\item{collapse}{string, a column name on which to collapse the data.table.
Used in case we wish to assess whether given medications are present within all the same instances of \emph{collapse}. See vignette for details.}

\item{code_time}{string, column name of the time column. Defaults to \emph{time_med}. Used in case collapse is present to provide the earliest or latest instance of diagnosing the given disease.}

\item{time_type}{string, if multiple diagnoses are present within the same case of \emph{collapse}, which timepoint to return. Supported are: "earliest" or "latest". Defaults to \emph{earliest}.}

\item{nThread}{integer, number of threads to use by \emph{dopar} for parallelization. If it is set to 1, then no parallel backends are created and the function is executed sequentially.
On windows machines sockets are used, while on other operating systems fork parallelization is used.}
}
\value{
data.table, with indicator columns whether given group of codes_to_find is present or not.
If \emph{collapse} is present, then only unique ID and the summary columns are returned.
}
\description{
Analyzes medication data loaded using \emph{load_med}.
By default, the data.table is returned with new columns corresponding to boolean values, whether given group of diagnoses are present in the given diagnosis.
If \emph{collapse} is given, then the information is aggregated based-on the \emph{collapse} column and the earliest of latest time of the given diagnosis is provided.
}
\examples{
\dontrun{
#Define medication group and add an indicator column whether
#the given medication group was administered
meds <- list(statin = c("Simvastatin", "Atorvastatin"),
             NSAID  = c("Acetaminophen", "Paracetamol"))

data_med_indic <- convert_med(d = data_med, codes_to_find = meds, nThread = 1)

#Summarize per patient if they ever had the given medication groups registered
data_med_indic_any <- convert_med(d = data_med,
codes_to_find = meds, collapse = "ID_MERGE", nThread = 2)
}
}
