% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_cplm.R, R/methods_pscl.R
\name{p_value.zcpglm}
\alias{p_value.zcpglm}
\alias{p_value.zeroinfl}
\title{p-values for Models with Zero-Inflation}
\usage{
\method{p_value}{zcpglm}(model, component = c("all", "conditional", "zi", "zero_inflated"), ...)

\method{p_value}{zeroinfl}(
  model,
  component = c("all", "conditional", "zi", "zero_inflated"),
  method = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model.}

\item{component}{Model component for which parameters should be shown. See
the documentation for your object's class in \code{\link[=model_parameters]{model_parameters()}} for
further details.}

\item{...}{Arguments passed down to \code{standard_error_robust()} when confidence intervals or p-values based on robust standard errors should be computed. Only available for models where \code{method = "robust"} is supported.}

\item{method}{If \code{"robust"}, and if model is supported by the \pkg{sandwich} or \pkg{clubSandwich} packages, computes p-values based on robust covariance matrix estimation.}

\item{verbose}{Toggle warnings and messages.}
}
\value{
A data frame with at least two columns: the parameter names and the p-values.
Depending on the model, may also include columns for model components etc.
}
\description{
This function attempts to return, or compute, p-values of hurdle and
zero-inflated models.
}
\examples{
if (require("pscl", quietly = TRUE)) {
  data("bioChemists")
  model <- zeroinfl(art ~ fem + mar + kid5 | kid5 + phd, data = bioChemists)
  p_value(model)
  p_value(model, component = "zi")
}
}
