% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_clusterstructure.R
\name{check_clusterstructure}
\alias{check_clusterstructure}
\title{Check suitability of data for clustering}
\usage{
check_clusterstructure(x, standardize = TRUE, distance = "euclidean", ...)
}
\arguments{
\item{x}{A data frame.}

\item{standardize}{Standardize the dataframe before clustering (default).}

\item{distance}{Distance method used. Other methods than "euclidean"
(default) are exploratory in the context of clustering tendency. See
\code{\link[stats:dist]{stats::dist()}} for list of available methods.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
The H statistic (numeric)
}
\description{
This checks whether the data is appropriate for clustering using the Hopkins'
H statistic of given data. If the value of Hopkins statistic is close to 0
(below 0.5), then we can reject the null hypothesis and conclude that the
dataset is significantly clusterable. A value for H lower than 0.25 indicates
a clustering tendency at the \verb{90\%} confidence level. The visual assessment of
cluster tendency (VAT) approach (Bezdek and Hathaway, 2002) consists in
investigating the heatmap of the ordered dissimilarity matrix. Following
this, one can potentially detect the clustering tendency by counting the
number of square shaped blocks along the diagonal.
}
\examples{
\donttest{
library(parameters)
check_clusterstructure(iris[, 1:4])
plot(check_clusterstructure(iris[, 1:4]))
}
}
\references{
\itemize{
\item Lawson, R. G., & Jurs, P. C. (1990). New index for clustering
tendency and its application to chemical problems. Journal of chemical
information and computer sciences, 30(1), 36-41.

\item Bezdek, J. C., & Hathaway, R. J. (2002, May). VAT: A tool for visual
assessment of (cluster) tendency. In Proceedings of the 2002 International
Joint Conference on Neural Networks. IJCNN02 (3), 2225-2230. IEEE.
}
}
\seealso{
\code{\link[=check_kmo]{check_kmo()}}, \code{\link[=check_sphericity_bartlett]{check_sphericity_bartlett()}} and \code{\link[=check_factorstructure]{check_factorstructure()}}.
}
