% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_base.R, R/methods_brms.R,
%   R/methods_rstanarm.R
\name{model_parameters.data.frame}
\alias{model_parameters.data.frame}
\alias{model_parameters.brmsfit}
\alias{model_parameters.stanreg}
\title{Parameters from Bayesian Models}
\usage{
\method{model_parameters}{data.frame}(
  model,
  centrality = "median",
  dispersion = FALSE,
  ci = 0.89,
  ci_method = "hdi",
  test = c("pd", "rope"),
  rope_range = "default",
  rope_ci = 1,
  parameters = NULL,
  verbose = TRUE,
  ...
)

\method{model_parameters}{brmsfit}(
  model,
  centrality = "median",
  dispersion = FALSE,
  ci = 0.89,
  ci_method = "hdi",
  test = c("pd", "rope"),
  rope_range = "default",
  rope_ci = 1,
  bf_prior = NULL,
  diagnostic = c("ESS", "Rhat"),
  priors = FALSE,
  effects = "fixed",
  component = "all",
  exponentiate = FALSE,
  standardize = NULL,
  group_level = FALSE,
  parameters = NULL,
  verbose = TRUE,
  ...
)

\method{model_parameters}{stanreg}(
  model,
  centrality = "median",
  dispersion = FALSE,
  ci = 0.89,
  ci_method = "hdi",
  test = c("pd", "rope"),
  rope_range = "default",
  rope_ci = 1,
  bf_prior = NULL,
  diagnostic = c("ESS", "Rhat"),
  priors = TRUE,
  effects = "fixed",
  exponentiate = FALSE,
  standardize = NULL,
  group_level = FALSE,
  parameters = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{Bayesian model (including SEM from \pkg{blavaan}. May also be
a data frame with posterior samples.}

\item{centrality}{The point-estimates (centrality indices) to compute.  Character (vector) or list with one or more of these options: \code{"median"}, \code{"mean"}, \code{"MAP"} or \code{"all"}.}

\item{dispersion}{Logical, if \code{TRUE}, computes indices of dispersion related to the estimate(s) (\code{SD} and \code{MAD} for \code{mean} and \code{median}, respectively).}

\item{ci}{Credible Interval (CI) level. Default to 0.89 (89\%). See
\code{\link[bayestestR]{ci}} for further details.}

\item{ci_method}{The type of index used for Credible Interval. Can be
\code{"HDI"} (default, see \code{\link[bayestestR:hdi]{hdi}}), \code{"ETI"}
(see \code{\link[bayestestR:eti]{eti}}), \code{"BCI"} (see
\code{bci}) or \code{"SI"} (see \code{\link[bayestestR:si]{si}}).}

\item{test}{The indices of effect existence to compute. Character (vector) or
list with one or more of these options: \code{"p_direction"} (or \code{"pd"}),
\code{"rope"}, \code{"p_map"}, \code{"equivalence_test"} (or \code{"equitest"}),
\code{"bayesfactor"} (or \code{"bf"}) or \code{"all"} to compute all tests.
For each "test", the corresponding \pkg{bayestestR} function is called
(e.g. \code{\link[bayestestR:rope]{rope}} or \code{\link[bayestestR:p_direction]{p_direction}}) and its results
included in the summary output.}

\item{rope_range}{ROPE's lower and higher bounds. Should be a list of two
values (e.g., \code{c(-0.1, 0.1)}) or \code{"default"}. If \code{"default"},
the bounds are set to \code{x +- 0.1*SD(response)}.}

\item{rope_ci}{The Credible Interval (CI) probability, corresponding to the
proportion of HDI, to use for the percentage in ROPE.}

\item{parameters}{Character vector of length 1 with a regular expression pattern
that describes the parameters that should be returned from the data frame, or
a named list of regular expressions. All non-matching parameters will be
removed from the output. If \code{parameters} is a character vector, every
parameter in the \emph{"Parameters"} column that matches the regular expression in
\code{parameters} will be selected from the returned data frame. Furthermore,
if \code{parameters} has more than one element, these will be merged into
a regular expression pattern like this: \code{"(one|two|three)"}. If
\code{parameters} is a named list of regular expression patterns, the
names of the list-element should equal the column name where selection
should be applied. This is useful for model objects where
\code{model_parameters()} returns multiple columns with parameter components,
like in \code{\link{model_parameters.lavaan}}.}

\item{verbose}{Toggle messages and warnings.}

\item{...}{Currently not used.}

\item{bf_prior}{Distribution representing a prior for the computation of Bayes factors / SI. Used if the input is a posterior, otherwise (in the case of models) ignored.}

\item{diagnostic}{Diagnostic metrics to compute.  Character (vector) or list with one or more of these options: \code{"ESS"}, \code{"Rhat"}, \code{"MCSE"} or \code{"all"}.}

\item{priors}{Add the prior used for each parameter.}

\item{effects}{Should results for fixed effects, random effects or both be returned?
Only applies to mixed models. May be abbreviated.}

\item{component}{Model component for which parameters should be shown. May be
one of \code{"conditional"}, \code{"precision"} (\pkg{betareg}),
\code{"scale"} (\pkg{ordinal}), \code{"extra"} (\pkg{glmx}),
\code{"marginal"} (\pkg{mfx}), \code{"conditional"} or \code{"full"} (for
\code{MuMIn::model.avg()}) or \code{"all"}.}

\item{exponentiate}{Logical, indicating whether or not to exponentiate the
the coefficients (and related confidence intervals). This is typical for
logistic regression, or more generally speaking, for models with log
or logit links. \strong{Note:} Delta-method standard errors are also
computed (by multiplying the standard errors by the transformed
coefficients). This is to mimic behaviour of other software packages, such
as Stata, but these standard errors poorly estimate uncertainty for the
transformed coefficient. The transformed confidence interval more clearly
captures this uncertainty. For \code{compare_parameters()},
\code{exponentiate = "nongaussian"} will only exponentiate coefficients
from non-Gaussian families.}

\item{standardize}{The method used for standardizing the parameters. Can be
\code{"refit"}, \code{"posthoc"}, \code{"smart"}, \code{"basic"},
\code{"pseudo"} or \code{NULL} (default) for no standardization. See
'Details' in \code{\link[effectsize]{standardize_parameters}}.
\strong{Important:} Categorical predictors (i.e. factors) are \emph{never}
standardized by default, which may be a different behaviour compared to
other R packages or other software packages (like SPSS). If standardizing
categorical predictors is desired, either use \code{standardize="basic"}
to mimic behaviour of SPSS or packages such as \pkg{lm.beta}, or standardize
the data with \code{effectsize::standardize(force=TRUE)} before fitting
the model. Robust estimation (i.e. \code{robust=TRUE}) of standardized
parameters only works when \code{standardize="refit"}.}

\item{group_level}{Logical, for multilevel models (i.e. models with random
effects) and when \code{effects = "all"} or \code{effects = "random"},
include the parameters for each group level from random effects. If
\code{group_level = FALSE} (the default), only information on SD and COR
are shown.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Parameters from Bayesian models.
}
\note{
When \code{standardize = "refit"}, columns \code{diagnostic},
  \code{bf_prior} and \code{priors} refer to the \emph{original}
  \code{model}. If \code{model} is a data frame, arguments \code{diagnostic},
  \code{bf_prior} and \code{priors} are ignored. \cr \cr There is also a
  \href{https://easystats.github.io/see/articles/parameters.html}{\code{plot()}-method}
  implemented in the
  \href{https://easystats.github.io/see/}{\pkg{see}-package}.
}
\examples{
\dontrun{
library(parameters)
if (require("rstanarm")) {
  model <- stan_glm(
    Sepal.Length ~ Petal.Length * Species,
    data = iris, iter = 500, refresh = 0
  )
  model_parameters(model)
}
}
}
\seealso{
\code{\link[insight:standardize_names]{standardize_names()}} to
  rename columns into a consistent, standardized naming scheme.
}
