% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize.R, R/standardize.data.frame.R
\name{standardize}
\alias{standardize}
\alias{standardize.numeric}
\alias{standardize.factor}
\title{Standardization}
\usage{
standardize(x, ...)

\method{standardize}{numeric}(x, robust = FALSE, method = "default",
  verbose = TRUE, ...)

\method{standardize}{factor}(x, force = FALSE, ...)
}
\arguments{
\item{x}{Object.}

\item{...}{Arguments passed to or from other methods.}

\item{robust}{Logical, if \code{TRUE}, centering is done by substracting the
median from the variables and divide it by the median absolute deviation
(MAD). If \code{FALSE}, variables are standardized by substracting the
mean and divide it by the standard deviation (SD).
the}

\item{method}{The method of standardization. For data.frames, can be \code{"default"} (variables are divided by SD or MAD depending on \code{robust}) or \code{"2sd"} (divided by two times the deviation).}

\item{verbose}{Toggle warnings on or off.}

\item{force}{Logical, if \code{TRUE}, forces standardization of factors as
well. Factors are converted to numerical values, with the lowest level
being the value \code{1} (unless the factor has numeric levels, which are
converted to the corresponding numeric value).}
}
\value{
The standardized object.
}
\description{
Performs a standardization of data or parameters. See the documentation for your object's class:
\itemize{
 \item{\link[=standardize.data.frame]{Dataframes}}
 \item{\link[=standardize.lm]{Regression models}}
 }
}
