% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\name{peek}
\alias{peek}
\title{Inspect a Backend}
\usage{
peek(backend)
}
\arguments{
\item{backend}{An object of class \code{\link{Backend}} as returned by the
\code{\link[=start_backend]{start_backend()}} function.}
}
\value{
The function returns a list of character vectors, where each list element
corresponds to a node, and each element of the character vector is the name
of a variable present on that node. It throws an error if the value provided
for the \code{backend} argument is not an instance of class \code{\link{Backend}}.
}
\description{
This function can be used to check the names of the variables present on a
\code{\link[=Backend]{backend}} created by \code{\link[=start_backend]{start_backend()}}.
}
\details{
This function is a convenience wrapper around the lower-lever API of
\code{\link{parabar}} aimed at developers. More specifically, this function
calls the \code{\link[=BackendService]{peek}} method on the provided
\code{\link[=Backend]{backend}} instance.
}
\examples{
# Create an asynchronous backend.
backend <- start_backend(cores = 2, cluster_type = "psock", backend_type = "async")

# Check that the backend is active.
backend$active

# Check if there is anything on the backend.
peek(backend)

# Create a dummy variable.
name <- "parabar"

# Export the `name` variable in the current environment to the backend.
export(backend, "name", environment())

# Remove the dummy variable from the current environment.
rm(name)

# Check the backend to see that the variable has been exported.
peek(backend)

# Run an expression on the backend.
# Note that the symbols in the expression are resolved on the backend.
evaluate(backend, {
    # Print the name.
    print(paste0("Hello, ", name, "!"))
})

# Clear the backend.
clear(backend)

# Check that there is nothing on the backend.
peek(backend)

# Use a basic progress bar (i.e., see `parabar::Bar`).
configure_bar(type = "basic", style = 3)

# Run a task in parallel (i.e., approx. 1.25 seconds).
output <- par_sapply(backend, x = 1:10, fun = function(x) {
    # Sleep a bit.
    Sys.sleep(0.25)

    # Compute and return.
    return(x + 1)
})

# Print the output.
print(output)

# Stop the backend.
stop_backend(backend)

# Check that the backend is not active.
backend$active

}
\seealso{
\code{\link[=start_backend]{start_backend()}}, \code{\link[=export]{export()}}, \code{\link[=evaluate]{evaluate()}},
\code{\link[=clear]{clear()}}, \code{\link[=configure_bar]{configure_bar()}}, \code{\link[=par_sapply]{par_sapply()}},
\code{\link[=par_lapply]{par_lapply()}}, \code{\link[=par_apply]{par_apply()}}, \code{\link[=stop_backend]{stop_backend()}},
and \code{\link{BackendService}}.
}
