% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_label.R
\name{simple_codebook}
\alias{simple_codebook}
\title{Simple Codebook}
\usage{
simple_codebook(x, ...)
}
\arguments{
\item{x}{data.frame. Data to be documented.}

\item{...}{
  Arguments passed on to \code{\link[utils:write.table]{utils::write.table}}
  \describe{
    \item{\code{file}}{either a character string naming a file or a \link{connection}
    open for writing.  \code{""} indicates output to the console.}
    \item{\code{append}}{logical. Only relevant if \code{file} is a character
    string.  If \code{TRUE}, the output is appended to the
    file.  If \code{FALSE}, any existing file of the name is destroyed.}
    \item{\code{quote}}{a logical value (\code{TRUE} or \code{FALSE}) or a
    numeric vector.  If \code{TRUE}, any character or factor columns
    will be surrounded by double quotes.  If a numeric vector, its
    elements are taken as the indices of columns to quote.  In both
    cases, row and column names are quoted if they are written.  If
    \code{FALSE}, nothing is quoted.}
    \item{\code{sep}}{the field separator string.  Values within each row of
    \code{x} are separated by this string.}
    \item{\code{eol}}{the character(s) to print at the end of each line (row).
    For example, \code{eol = "\r\n"} will produce Windows' line endings on
    a Unix-alike OS, and \code{eol = "\r"} will produce files as expected by
    Excel:mac 2004.}
    \item{\code{na}}{the string to use for missing values in the data.}
    \item{\code{dec}}{the string to use for decimal points in numeric or complex
    columns: must be a single character.}
    \item{\code{row.names}}{either a logical value indicating whether the row
    names of \code{x} are to be written along with \code{x}, or a
    character vector of row names to be written.}
    \item{\code{col.names}}{either a logical value indicating whether the column
    names of \code{x} are to be written along with \code{x}, or a
    character vector of column names to be written.  See the section on
    \sQuote{CSV files} for the meaning of \code{col.names = NA}.}
    \item{\code{qmethod}}{a character string specifying how to deal with embedded
    double quote characters when quoting strings.  Must be one of
    \code{"escape"} (default for \code{write.table}), in which case the
    quote character is escaped in C style by a backslash, or
    \code{"double"} (default for \code{write.csv} and
    \code{write.csv2}), in which case it is doubled.  You can specify
    just the initial letter.}
    \item{\code{fileEncoding}}{character string: if non-empty declares the
    encoding to be used on a file (not a connection) so the character data can
    be re-encoded as they are written.  See \code{\link{file}}.}
  }}
}
\value{
Returns \code{NULL} invisibly.
}
\description{
Generate a simple codebook in CSV-format from a (labelled) \code{data.frame}.
}
\details{
If the \pkg{skimr} package is installed, an in-line histogram is
added for all numeric variables. If columns are labelled, the labelles
are included in the codebook.
}
\examples{
variable_labels(cars) <- c(speed = "Speed [ft/s]", dist = "Distance traveled [m]")
simple_codebook(cars, file = file.path(tempdir(), "cars_codebook.csv"))
}
\seealso{
\code{\link[utils:write.table]{utils::write.csv()}}
}
