% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc-list.R
\name{pandoc_list_highlight_style}
\alias{pandoc_list_highlight_style}
\title{List supported styles for Pandoc syntax highlighting}
\usage{
pandoc_list_highlight_style(version = "default")
}
\arguments{
\item{version}{Version to use. Default will be the \code{"default"} version. Other possible value are
\itemize{
\item A version number e.g \code{"2.14.1"}
\item The nightly version called \code{"nightly"}
\item The latest installed version with \code{"latest"}
\item Pandoc binary shipped with RStudio IDE with \code{"rstudio"}
\item Pandoc binary found in PATH with \code{"system"}
}}
}
\value{
a character vector of supported highlighting style name to use.
}
\description{
Pandoc includes a highlighter which offer a styling mechanism to specify the
coloring style to be used in highlighted source code. This function returns
the supported values which can be specify at \code{pandoc} command line using the
\href{https://pandoc.org/MANUAL.html#option--highlight-style}{\verb{--highlight-style=} flag}.
}
\examples{
\dontshow{if (pandoc::pandoc_available("2.0")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pandoc_list_highlight_style()
\dontshow{\}) # examplesIf}
\dontshow{if (pandoc::pandoc_is_installed("2.11.4")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# check style available in a specific Pandoc's version
pandoc_list_highlight_style("2.11.4")
\dontshow{\}) # examplesIf}
}
