% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/palr.R
\name{chlPal}
\alias{chlPal}
\title{Ocean colour colours for chlorophyll-a.}
\usage{
chlPal(x, palette = FALSE, alpha = 1)
}
\arguments{
\item{x}{a vector of data values or a single number}

\item{palette}{logical, if \code{TRUE} return a list with matching colours and values}

\item{alpha}{value in 0,1 to specify opacity}
}
\value{
colours, palette, or function, see Details
}
\description{
Ocean colour palette for chlorophyll-a.
}
\details{
Flexible control of the chlorophyll-a palette. If \code{x} is a
single number, the function returns that many colours evenly
spaced from the palette. If \code{x} is a vector of multiple
values the palette is queried for colours matching those values,
and these are returned. If \code{x} is missing and \code{palette}
is \code{FALSE} then a function is returned that will generate n
evenly spaced colours from the palette, as per
\code{\link{colorRampPalette}}.
}
\examples{
\dontrun{
chl <- raadtools::readchla(xylim = c(100, 110, -50, -40))
## just get a small number of evenly space colours
plot(chl, col = chlPal(10))
## store the full palette and work with values and colours
pal <- chlPal()
## the standard full palette
plot(chl, breaks = pal$breaks, col = pal$cols)
## a custom set of values with matching colours
plot(chl, col = chlPal(pal$breaks[seq(1, length(pal$breaks), length = 10)]))
## any number of colours stored as a function
myfun <- chlPal()
plot(chl, col = myfun(18))
## just n colours
plot(chl, col = chlPal(18))
}
}
\references{
Derived from \url{http://oceancolor.gsfc.nasa.gov/DOCS/palette_chl_etc.txt}.
}

