% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hidden.R
\name{.combine}
\alias{.combine}
\title{Combining p-values}
\usage{
.combine(x, method = "simes")
}
\arguments{
\item{x}{local \eqn{p}-values\strong{:}
numeric vector of length \eqn{k}}

\item{method}{character \eqn{"fisher"}, \eqn{"tippet"}, \eqn{"sidak"}, or \eqn{"simes"}}
}
\value{
These functions return a numeric vector of length \eqn{p}
(main effects),
or a numeric matrix with \eqn{p} rows and \eqn{p} columns
(interaction effects).
}
\description{
This function combines local \eqn{p}-values to a global \eqn{p}-value.
}
\examples{
# independence
p <- runif(10)
palasso:::.combine(p)

## dependence 
#runif <- function(n,cor=0){
#    Sigma <- matrix(cor,nrow=n,ncol=n)
#     diag(Sigma) <- 1
#     mu <- rep(0,times=n)
#     q <- MASS::mvrnorm(n=1,mu=mu,Sigma=Sigma)
#     stats::pnorm(q=q)
#}
#p <- runif(n=10,cor=0.8)
#combine(p)

}
\references{
Westfall, P. H. (2005). "Combining p-values".
Encyclopedia of Biostatistics
https://doi.org/10.1002/0470011815.b2a15181
}
\keyword{methods}
