% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tax_range_time.R
\name{tax_range_time}
\alias{tax_range_time}
\title{Calculate the temporal range of fossil taxa}
\usage{
tax_range_time(
  occdf,
  name = "genus",
  min_ma = "min_ma",
  max_ma = "max_ma",
  by = "FAD",
  plot = FALSE
)
}
\arguments{
\item{occdf}{\code{dataframe}. A dataframe of fossil occurrences containing
at least three columns: names of taxa, maximum age and minimum age
(see \code{name}, \code{lng}, and \code{lat} arguments).
These ages should constrain the age range of the fossil occurrence
and are assumed to be in millions of years before present.}

\item{name}{\code{character}. The name of the column you wish to be treated
as the input names, e.g. "genus" (default).}

\item{min_ma}{\code{character}. The name of the column you wish to be treated
as the minimum limit of the age range, e.g. "min_ma" (default).}

\item{max_ma}{\code{character}. The name of the column you wish to be treated
as the maximum limit of the age range, e.g. "max_ma" (default).}

\item{by}{\code{character}. How should the output be sorted?
Either: "FAD" (first-appearance date; default), "LAD" (last-appearance data),
or "name" (alphabetically by taxon names).}

\item{plot}{\code{logical}. Should a plot of the ranges be generated?}
}
\value{
A \code{dataframe} containing the following columns:
unique taxa (\code{taxon}), taxon ID (\code{taxon_id}), first appearance of taxon
(\code{max_ma}), last appearance of taxon (\code{min_ma}), duration of temporal
range (\code{range_myr}), and number of occurrences per taxon (\code{n_occ}) is
returned.
}
\description{
A function to calculate the temporal range of fossil taxa from occurrence
data.
}
\details{
The temporal range(s) of taxa are calculated by extracting all
unique taxa (\code{name} column) from the input \code{occdf}, and checking their first
and last appearance. The temporal duration of each taxon is also calculated.
A plot of the temporal range of each taxon is also returned if \code{plot = TRUE}.
If the input data columns contain NAs, these should be removed prior to
function call.

Note: this function provides output based solely on the user input data. The
true duration of a taxon is likely confounded by uncertainty in dating
occurrences, and incomplete sampling and preservation.
}
\section{Developer(s)}{

Lewis A. Jones
}

\section{Reviewer(s)}{

Bethany Allen & Christopher D. Dean
}

\examples{
# Grab internal data
occdf <- tetrapods
# Remove NAs
occdf <- subset(occdf, !is.na(order))
# Temporal range
ex <- tax_range_time(occdf = occdf, name = "order", plot = TRUE)

}
