% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{cache_summary}
\alias{cache_summary}
\alias{cache_list}
\alias{cache_delete}
\alias{cache_clean}
\title{Package cache utilities}
\usage{
cache_summary()

cache_list(...)

cache_delete(...)

cache_clean()
}
\arguments{
\item{...}{For \code{cache_list()} and \code{cache_delete()}, \code{...} may contain
filters, where the argument name is the column name. E.g. \code{package},
\code{version}, etc. Call \code{cache_list()} without arguments to see the
available column names. If you call \code{cache_delete()} without arguments,
it will delete all cached files.}
}
\value{
\code{cache_summary()} returns a list with elements:
\itemize{
\item \code{cachepath}: absolute path to the package cache
\item \code{files}: number of files (packages) in the cache
\item \code{size}: total size of package cache in bytes
}

\code{cache_list()} returns a data frame with the data about the cache.

\code{cache_delete()} returns nothing.

\code{cache_clean()} returns nothing.
}
\description{
Various utilities to inspect and clean the package cache.
See the pkgcache package if you need for control over the package cache.
}
\details{
\code{cache_summary()} returns a summary of the package cache.

\code{cache_list()} lists all (by default), or a subset of
packages in the package cache.

\code{cache_delete()} deletes files from the cache.

\code{cache_clean()} deletes all files from the cache.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Summary
cache_summary()
\dontshow{\}) # examplesIf}
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# List packages
cache_list()
cache_list(package = "recipes")
cache_list(platform = "source")
\dontshow{\}) # examplesIf}
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Delete packages
cache_delete(package = "knitr")
cache_delete(platform = "macos")
\dontshow{\}) # examplesIf}
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cache_clean()
\dontshow{\}) # examplesIf}
}
