% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipelineHelpers.R
\name{basicP2proc}
\alias{basicP2proc}
\title{Perform basic 'pagoda2' processing, i.e. adjust variance, calculate pca reduction,
make knn graph, identify clusters with multilevel, and generate
largeVis and tSNE embeddings.}
\usage{
basicP2proc(
  cd,
  n.cores = 1,
  n.odgenes = 3000,
  nPcs = 100,
  k = 30,
  perplexity = 50,
  log.scale = TRUE,
  trim = 10,
  keep.genes = NULL,
  min.cells.per.gene = 0,
  min.transcripts.per.cell = 100,
  get.largevis = TRUE,
  get.tsne = TRUE,
  make.geneknn = TRUE
)
}
\arguments{
\item{cd}{count matrix whereby rows are genes, columns are cells.}

\item{n.cores}{numeric Number of cores to use (default=1)}

\item{n.odgenes}{numeric Number of top overdispersed genes to use (dfault=3e3)}

\item{nPcs}{numeric Number of PCs to use (default=100)}

\item{k}{numeric Default number of neighbors to use in kNN graph (default=30)}

\item{perplexity}{numeric Perplexity to use in generating tSNE and largeVis embeddings (default=50)}

\item{log.scale}{boolean Whether to use log scale normalization (default=TRUE)}

\item{trim}{numeric Number of cells to trim in winsorization (default=10)}

\item{keep.genes}{optional set of genes to keep from being filtered out (even at low counts) (default=NULL)}

\item{min.cells.per.gene}{numeric Minimal number of cells required for gene to be kept (unless listed in keep.genes) (default=0)}

\item{min.transcripts.per.cell}{numeric Minimumal number of molecules/reads for a cell to be admitted (default=100)}

\item{get.largevis}{boolean Whether to caluclate largeVis embedding (default=TRUE)}

\item{get.tsne}{boolean Whether to calculate tSNE embedding (default=TRUE)}

\item{make.geneknn}{boolean Whether pre-calculate gene kNN (for gene search) (default=TRUE)}
}
\value{
a new 'Pagoda2' object
}
\description{
Perform basic 'pagoda2' processing, i.e. adjust variance, calculate pca reduction,
make knn graph, identify clusters with multilevel, and generate
largeVis and tSNE embeddings.
}
\examples{
\donttest{
## load count matrix
cm <- p2data::sample_BM1
## perform basic p2 processing
p2 <- basicP2proc(cm)
}

}
