% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_interval.R
\name{get_interval}
\alias{get_interval}
\title{Get the interval of a datetime variable}
\usage{
get_interval(x)
}
\arguments{
\item{x}{A variable of class of class \code{Date} or of class \code{POSIXt}.}
}
\value{
A character string indicating the interval of \code{x}.
}
\description{
The interval is the highest datetime unit that can explain all instances of a
variable of class \code{Date}, class \code{POSIXct}, or class \code{POSIXct}.
This function will determine what the interval of the variable is.
}
\details{
See \code{vignette("padr")} for more information on intervals.
}
\examples{
x_month <- seq(as.Date('2016-01-01'), as.Date('2016-05-01'), by = 'month')
get_interval(x_month)

x_sec <- seq(as.POSIXct('2016-01-01 00:00:00'), length.out = 100, by = 'sec')
get_interval(x_sec)
get_interval(x_sec[seq(0, length(x_sec), by = 5)])
}
