% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{pac_checkred}
\alias{pac_checkred}
\title{Checking the R CRAN package check page status}
\usage{
pac_checkred(pac, scope = c("ERROR", "FAIL"), flavors = NULL)
}
\arguments{
\item{pac}{\code{character} a package name.}

\item{scope}{\code{character} vector scope of the check, accepted values c("ERROR", "FAIL", "WARN", "NOTE"). Default: \code{c("ERROR", "FAIL")}}

\item{flavors}{\code{character} vector of CRAN server names to consider, possible names could be get with \code{pacs::cran_flavors()$Flavor}.
The \code{pacs::match_flavors()} function could be used to get CRAN server names matched for your local \code{OS}.
By default all CRAN machines are considered \code{NULL} value. Default: \code{NULL}}
}
\value{
\code{logical} if the package fail under specified criteria.
}
\description{
using package R CRAN check page to validate if there are ANY errors and/or fails and/or warnings and/or notes.
}
\note{
Results are cached for 30 minutes with \code{memoise} package.
If you need to check many packages at once then is recommended usage of \code{pacs::checked_packages}.
The used repository \verb{https://cran.rstudio.com/}.
Please as a courtesy to the R CRAN, don't overload their server by constantly using this function.
}
\examples{
\dontrun{
pacs::pac_checkred("dplyr")
pacs::pac_checkred("dplyr", scope = c("ERROR"))
pacs::pac_checkred("dplyr",
  scope = c("ERROR", "FAIL", "WARN"),
  flavors = pacs::match_flavors()
)
}
}
