% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale_data.R
\name{rescale_data}
\alias{rescale_data}
\title{Subset a precipitation data product in space}
\usage{
rescale_data(data, new_res, autosave = FALSE)
}
\arguments{
\item{data}{a character string with the path to the data file. Or a RasterBrick.}

\item{new_res}{numeric. Target resolution must be a multiple of 0.25 (e.g., 0.5, 1, 2.5).}

\item{autosave}{logical FALSE (default). If TRUE data will be automatically stored in the same location of the input file}
}
\value{
An aggregated RasterBrick.
}
\description{
The function \code{rescale_data} aggregates the requested data sets into desired resolution and stores it in the same location of the input file.
}
\examples{
\dontrun{
x <- rescale_data("gpcp_tp_mm_global_197901_202205_025_monthly.nc", 1)
z <- rescale_data("dummie.nc", 1)
}
}
