% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uflist.R
\name{uflist}
\alias{uflist}
\title{All the State's UF Codes.}
\usage{
uflist(region = NA)
}
\arguments{
\item{region}{filter the UFs (Units of the Federation or States) by geographical region. If NA, all state are shown. According to the Brazilian Institute of Geography and Statistics, the country is divided in 5 regions: "Norte", "Nordeste", "Centro-Oeste", "Sul" and "Sudeste".}
}
\value{
a tibble with 3 columns.
\describe{
   \item{State}{The full name of the state.}
   \item{UF}{The abbreviation of the state's name.}
   \item{num}{The identification number of the state.}
   \item{region}{Region of the country in which the State is located.}
}
}
\description{
Returns a tibble which contains the IBGE identification code of each one of all 23 UFs (Units of the Federation) in Brazil.
}
\examples{
\dontrun{
uflist(reg = NA) # show all states of the country.
uflist(region = "Sul") # only exhibit States in the 'Sul' region of the country.
}
}
\references{
Source: \href{https://cidades.ibge.gov.br}{IBGE (Brazilian Institute of Geography and Statistics)}
}
\author{
Joao Pedro Oliveira dos Santos, International Relations Institute, Pontifical Catholic University of Rio de Janeiro
}
