% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetDetectorScore_getWindowLength.R
\name{GetWindowLength}
\alias{GetWindowLength}
\title{Get Window Length}
\usage{
GetWindowLength(data.length, num.real.anomaly, window.length.perc = 0.1)
}
\arguments{
\item{data.length}{Dataset length.}

\item{num.real.anomaly}{Number of real anomalies contained in the data set.}

\item{window.length.perc}{Window length in percentage of the total data}
}
\value{
Window length as numeric.
}
\description{
\code{GetWindowLength} Calculates the size of the window. This window focuses on
the real anomaly and it can be used to know if the detected anomaly is a true positive or not.
}
\details{
\code{nrow.data} and \code{num.real.anomaly} must be numeric. Window length is
calculated by default as 10\% of the length of the data set divided by the number of real
anomalies contained in it.
}
\examples{
## Generate data
set.seed(100)
n <- 180
x <- sample(1:100, n, replace = TRUE)
x[70:90] <- sample(110:115, 21, replace = TRUE)
x[25] <- 200
x[150] <- 170
df <- data.frame(timestamp = 1:n, value = x)

# Add is.real.anomaly column
df$is.real.anomaly <- 0
df[c(25,80,150), "is.real.anomaly"] <- 1

# Get window length
GetWindowLength(data.length = nrow(df), num.real.anomaly = 3)
}
\references{
A. Lavin and S. Ahmad, “Evaluating Real-time Anomaly Detection Algorithms – the
Numenta Anomaly Benchmark,” in 14th International Conference on Machine Learning and
Applications (IEEE ICMLA 15), 2015.
}
