% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tagVariantsAndStudiesForIndexVariant.R
\name{tagVariantsAndStudiesForIndexVariant}
\alias{tagVariantsAndStudiesForIndexVariant}
\title{Retrieves tag variants and studies for a given index variant.}
\usage{
tagVariantsAndStudiesForIndexVariant(variant_id, pageindex = 0, pagesize = 20)
}
\arguments{
\item{variant_id}{Character: Open Targets Genetics generated ID for a variant (CHRPOSITION_REFALLELE_ALTALLELE or rsId).}

\item{pageindex}{Integer: Index of the current page for pagination (>= 0).}

\item{pagesize}{Integer: Number of records in a page for pagination (> 0).}
}
\value{
Returns a data frame containing the variant associations connected to the input index variant.
The columns in the data frame are as follows:
\itemize{
  \item{\code{tagVariant.id}:} \emph{Character}. Tag variant ID.
  \item{\code{tagVariant.chromosome}:} \emph{Character}. Chromosome of the tag variant.
  \item{\code{tagVariant.rsId}:} \emph{Character}. rsID of the tag variant.
  \item{\code{tagVariant.position}:} \emph{Integer}. Position of the tag variant.
  \item{\code{study.studyId}:} \emph{Character}. Study ID.
  \item{\code{study.traitReported}:} \emph{Character}. Reported trait of the study.
  \item{\code{study.traitCategory}:} \emph{Character}. Category of the trait in the study.
  \item{\code{pval}:} \emph{Numeric}. P-value.
  \item{\code{pvalMantissa}:} \emph{Numeric}. Mantissa of the p-value.
  \item{\code{pvalExponent}:} \emph{Integer}. Exponent of the p-value.
  \item{\code{nTotal}:} \emph{Integer}. Total number of samples.
  \item{\code{nCases}:} \emph{Integer}. Number of cases in the study.
  \item{\code{overallR2}:} \emph{Numeric}. Overall R-squared value.
  \item{\code{afr1000GProp}:} \emph{Numeric}. Proportion in African 1000 Genomes population.
  \item{\code{amr1000GProp}:} \emph{Numeric}. Proportion in Admixed American 1000 Genomes population.
  \item{\code{eas1000GProp}:} \emph{Numeric}. Proportion in East Asian 1000 Genomes population.
  \item{\code{eur1000GProp}:} \emph{Numeric}. Proportion in European 1000 Genomes population.
  \item{\code{sas1000GProp}:} \emph{Numeric}. Proportion in South Asian 1000 Genomes population.
  \item{\code{oddsRatio}:} \emph{Numeric}. Odds ratio.
  \item{\code{oddsRatioCILower}:} \emph{Numeric}. Lower bound of the odds ratio confidence interval.
  \item{\code{oddsRatioCIUpper}:} \emph{Numeric}. Upper bound of the odds ratio confidence interval.
  \item{\code{posteriorProbability}:} \emph{Numeric}. Posterior probability.
  \item{\code{beta}:} \emph{Numeric}. Beta value.
  \item{\code{betaCILower}:} \emph{Numeric}. Lower bound of the beta value confidence interval.
  \item{\code{betaCIUpper}:} \emph{Numeric}. Upper bound of the beta value confidence interval.
  \item{\code{direction}:} \emph{Character}. Direction of the effect.
  \item{\code{log10Abf}:} \emph{Numeric}. Log base 10 of the approximate Bayes factor.
}
}
\description{
For an input index variant ID, this function fetches information about the tag variants
and associated studies, including scores.
}
\examples{
\dontrun{
result <- tagVariantsAndStudiesForIndexVariant(variant_id = "1_109274968_G_T")
result <- tagVariantsAndStudiesForIndexVariant(variant_id = "1_109274968_G_T"
    ,pageindex = 1, pagesize = 50)
    }
}
