% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrmIsochrone.R
\name{osrmIsochrone}
\alias{osrmIsochrone}
\title{Get a SpatialPolygonsDataFrame of Isochrones}
\usage{
osrmIsochrone(loc, breaks = seq(from = 0, to = 60, length.out = 7),
  exclude = NULL, res = 30)
}
\arguments{
\item{loc}{a numeric vector of longitude and latitude (WGS84) or a 
SpatialPointsDataFrame or a SpatialPolygonsDataFrame of the origine point.}

\item{breaks}{a numeric vector of isochrone values (in minutes).}

\item{exclude}{pass an optional "exclude" request option to the OSRM API.}

\item{res}{number of points used to compute isochrones, one side of the square 
grid, the total number of points will be res*res.}
}
\value{
A SpatialPolygonsDateFrame of isochrones is returned. 
The data frame of the output contains four fields: 
id (id of each polygon), min and max (minimum and maximum breaks of the polygon), 
center (central values of classes).
}
\description{
Based on \code{\link{osrmTable}}, this function buids a 
SpatialPolygonsDataFrame of isochrones.
}
\examples{
\dontrun{
# Load data
data("berlin")

# Get isochones with lon/lat coordinates, default breaks
iso <- osrmIsochrone(loc = c(13.43853,52.47728), breaks = seq(0,15,1), res = 70)
library(sp)
plot(iso, col = colorRampPalette(colors = c('grey80', 'grey20'))(14))

# Map
if(require("cartography")){
  osm <- getTiles(x = iso, crop = TRUE, type = "osmgrayscale")
  tilesLayer(x = osm)
  breaks <- sort(c(unique(iso$min), max(iso$max)))
  cartography::choroLayer(spdf = iso,
                          var = "center", breaks = breaks,
                          col = paste0(rev(carto.pal("green.pal",
                                                     length(breaks)+1)),99),
                          border = NA,
                          legend.pos = "topleft",legend.frame = TRUE,
                          legend.title.txt = "Isochrones\\n(min)",
                          add = TRUE)
}


# Get isochones with a SpatialPointsDataFrame, custom breaks
iso2 <- osrmIsochrone(loc = apotheke.sp[10,],
                      breaks = seq(from = 0, to = 16, by = 2))

# Map
if(require("cartography")){
  osm2 <- getTiles(x = iso2, crop = FALSE, type = "osmgrayscale")
  tilesLayer(x = osm2)
  breaks2 <- sort(c(unique(iso2$min), max(iso2$max)))
  cartography::choroLayer(spdf = iso2,
                          var = "center", breaks = breaks2,
                          border = NA,
                          legend.pos = "topleft",legend.frame = TRUE,
                          legend.title.txt = "Isochrones\\n(min)",
                          add = TRUE)
}
}
}
\seealso{
\link{osrmTable}
}
