% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation-helpers.R
\name{validatePathIsAbsolute}
\alias{validatePathIsAbsolute}
\title{Check if path is absolute}
\usage{
validatePathIsAbsolute(path)
}
\arguments{
\item{path}{A valid file path name.}
}
\value{
Error in case a relative path is found, otherwise no output will be returned.
}
\description{
Relative paths will be detected based on the presence of wildcard
character(*) in the path specification.
}
\examples{
# no error if path is absolute
validatePathIsAbsolute("Organism|path")

# error otherwise
# validatePathIsAbsolute("Organism|*path")

}
