/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.process.mortality;

import fr.ird.osmose.School;
import fr.ird.osmose.Species;
import fr.ird.osmose.process.mortality.AbstractMortality;
import fr.ird.osmose.process.mortality.AbstractMortalitySpecies;
import fr.ird.osmose.process.mortality.additional.AnnualAdditionalMortality;
import fr.ird.osmose.process.mortality.additional.ByDtAdditionalMortality;
import fr.ird.osmose.process.mortality.additional.ByDtByClassAdditionalMortality;
import fr.ird.osmose.process.mortality.additional.ByDtLarvaMortality;
import fr.ird.osmose.process.mortality.additional.ConstantLarvaMortality;
import fr.ird.osmose.util.GridMap;
import java.util.List;

public class AdditionalMortality
extends AbstractMortality {
    private AbstractMortalitySpecies[] eggMortality;
    private AbstractMortalitySpecies[] additionalMortality;
    private GridMap[] spatialD;

    public AdditionalMortality(int rank) {
        super(rank);
    }

    @Override
    public void init() {
        Species species;
        int iSpec;
        int rank = this.getRank();
        this.eggMortality = new AbstractMortalitySpecies[this.getNSpecies()];
        for (iSpec = 0; iSpec < this.getNSpecies(); ++iSpec) {
            species = this.getSpecies(iSpec);
            if (!this.getConfiguration().isNull("mortality.natural.larva.rate.bytDt.file.sp" + iSpec)) {
                this.eggMortality[iSpec] = new ByDtLarvaMortality(rank, species);
                continue;
            }
            if (!this.getConfiguration().isNull("mortality.natural.larva.rate.sp" + iSpec)) {
                this.eggMortality[iSpec] = new ConstantLarvaMortality(rank, species);
                continue;
            }
            this.eggMortality[iSpec] = new ConstantLarvaMortality(rank, species, 0.0);
            this.getSimulation().warning("Could not find any parameters for egg mortality (mortality.natural.larva.rate.bytDt.file.sp# or mortality.natural.larva.rate.sp#) for species {0}. Osmose assumes egg mortality = 0", species.getName());
        }
        this.additionalMortality = new AbstractMortalitySpecies[this.getNSpecies()];
        for (iSpec = 0; iSpec < this.getNSpecies(); ++iSpec) {
            species = this.getSpecies(iSpec);
            if (!this.getConfiguration().isNull("mortality.natural.rate.byDt.byAge.file.sp" + iSpec) || !this.getConfiguration().isNull("mortality.natural.rate.byDt.bySize.file.sp" + iSpec)) {
                this.additionalMortality[iSpec] = new ByDtByClassAdditionalMortality(rank, species);
                continue;
            }
            if (!this.getConfiguration().isNull("mortality.natural.rate.bytDt.file.sp" + iSpec)) {
                this.additionalMortality[iSpec] = new ByDtAdditionalMortality(rank, species);
                continue;
            }
            if (!this.getConfiguration().isNull("mortality.natural.rate.sp" + iSpec)) {
                this.additionalMortality[iSpec] = new AnnualAdditionalMortality(rank, species);
                continue;
            }
            this.error("Could not find any parameters for natural mortality (mortality.natural.rate.byDt.byAge.file.sp# or mortality.natural.rate.byDt.bySize.file.sp mortality.natural.rate.byDt.file.sp or mortality.natural.rate.sp#) for species " + species.getName(), null);
        }
        for (iSpec = 0; iSpec < this.getNSpecies(); ++iSpec) {
            this.eggMortality[iSpec].init();
            this.additionalMortality[iSpec].init();
        }
        this.spatialD = new GridMap[this.getNSpecies()];
        List<String> keys = this.getConfiguration().findKeys("mortality.natural.spatial.distrib.file.sp*");
        if (keys != null && !keys.isEmpty()) {
            for (int iSpec2 = 0; iSpec2 < this.getConfiguration().getNSpecies(); ++iSpec2) {
                if (this.getConfiguration().isNull("mortality.natural.spatial.distrib.file.sp" + iSpec2)) continue;
                this.spatialD[iSpec2] = new GridMap(this.getConfiguration().getFile("mortality.natural.spatial.distrib.file.sp" + iSpec2));
            }
        }
    }

    @Override
    public double getRate(School school) {
        Species spec = school.getSpecies();
        double D = school.getAgeDt() == 0 ? this.eggMortality[school.getSpeciesIndex()].getRate(school) : (null != this.spatialD[spec.getIndex()] && !school.isUnlocated() ? (double)this.spatialD[spec.getIndex()].getValue(school.getCell()) * this.additionalMortality[school.getSpeciesIndex()].getRate(school) : this.additionalMortality[school.getSpeciesIndex()].getRate(school));
        return D;
    }
}

